/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata;

import com.sas.metadata.CMetadata;
import com.sas.metadata.MdChangeManagementEventListener;
import com.sas.metadata.MdException;
import com.sas.metadata.MdObjectFactory;
import com.sas.metadata.MdObjectStore;
import com.sas.metadata.MetadataUtil;
import com.sas.metadata.Root;
import com.sas.metadata.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MdChangeManagementUtil {
    protected static EventListenerList listenerList = new EventListenerList();
    protected static List groupableTypes = null;
    protected static List checkoutableTypes = null;
    public static final String UPDATEDOBJECTS = "UpdatedObjects";
    public static final String DELETEDOBJECTS = "DeletedObjects";
    public static final String NEW = "New";

    public static void checkOut(Vector metaObjects, CMetadata projectRepository) throws MdException {
        Document ioutDoc;
        if (metaObjects == null || metaObjects.size() == 0) {
            return;
        }
        int flags = 1032;
        StringBuffer outXML = new StringBuffer("<CheckoutMetadata><METADATA>");
        for (int i = 0; i < metaObjects.size(); ++i) {
            CMetadata object = (CMetadata)metaObjects.get(i);
            StringBuffer appendXML = new StringBuffer("<");
            appendXML.append(object.getCMetadataType());
            appendXML.append(" Id=\"");
            appendXML.append(object.getFQID());
            appendXML.append("\" />");
            outXML.append(appendXML);
        }
        outXML.append("</METADATA><ProjectReposid>");
        outXML.append("</ProjectReposid><ns>SAS</ns><flags>");
        outXML.append(flags);
        outXML.append("</flags><options/></CheckoutMetadata>");
        try {
            ioutDoc = MetadataUtil.DoRequest(outXML.toString(), false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        MdObjectStore store = MdObjectFactory.createObjectStore();
        Vector newSimpleObjects = MdChangeManagementUtil.createAllObjects(store, ioutDoc);
        MdChangeManagementUtil.fireMetadataCheckOut(new ChangeEvent(projectRepository), newSimpleObjects);
        store.dispose();
    }

    public static void addObjects(MdObjectStore store, CMetadata projectRepository) throws MdException {
        throw new MdException("NOT IMPLEMENTED");
    }

    public static void newObjectsAdded(CMetadata projectRepository, ArrayList objects) throws MdException {
        MdChangeManagementUtil.fireNewObjectsAdded(new ChangeEvent(projectRepository), objects);
    }

    public static boolean isGroupableObject(CMetadata object) {
        List groups = MdChangeManagementUtil.getGroupObjectTypes();
        return groups.contains(object.getCMetadataType());
    }

    public static boolean isCheckoutableObject(CMetadata object) {
        return MdChangeManagementUtil.isCheckoutableObject(object.getCMetadataType());
    }

    public static boolean isCheckoutableObject(String sType) {
        List types = MdChangeManagementUtil.getCheckoutObjectTypes();
        return types.contains(sType);
    }

    protected static Vector createAllObjects(MdObjectStore store, Document outDoc) throws MdException {
        Node newNode = outDoc.getFirstChild().getFirstChild();
        Vector<Root> objects = new Vector<Root>();
        NodeList newNodeList = newNode.getChildNodes();
        int newNodeListLength = newNodeList.getLength();
        if (newNodeListLength == 0) {
            return objects;
        }
        NodeList tempNodeList = newNodeList;
        if (tempNodeList.item(0).getNodeName().equals(UPDATEDOBJECTS)) {
            newNodeList = tempNodeList.item(0).getChildNodes();
        } else if (tempNodeList.item(0).getNodeName().equals(DELETEDOBJECTS)) {
            return objects;
        }
        int length = newNodeList.getLength();
        for (int i = 0; i < length; ++i) {
            String strType = newNodeList.item(i).getNodeName();
            NamedNodeMap newNodeMap = newNodeList.item(i).getAttributes();
            if (newNodeMap == null || newNodeMap.getLength() == 0) continue;
            String strNewId = newNodeMap.getNamedItem("Id").getNodeValue();
            String strName = "";
            Node nameNode = newNodeMap.getNamedItem("Name");
            if (nameNode != null) {
                strName = nameNode.getNodeValue();
            }
            String strChangeState = null;
            Node changestateNode = newNodeMap.getNamedItem("ChangeState");
            if (changestateNode != null) {
                strChangeState = changestateNode.getNodeValue();
            } else {
                Util.printOutputln("Missing changestate ");
            }
            Root object = (Root)MdObjectFactory.createComplexMetadataObject(store, strName, strType, strNewId);
            if (strChangeState != null) {
                object.setChangeState(strChangeState);
            }
            if (strChangeState == null) {
                objects.add(object);
                continue;
            }
            if (strChangeState.indexOf(NEW) >= 0) continue;
            objects.add(object);
        }
        return objects;
    }

    protected static Vector createDestroyedObjects(Document outDoc) {
        Node newNode = outDoc.getFirstChild().getFirstChild();
        Vector<String> objects = new Vector<String>();
        NodeList newNodeList = newNode.getChildNodes();
        int newNodeListLength = newNodeList.getLength();
        if (newNodeListLength == 0) {
            return objects;
        }
        NodeList tempNodeList = newNodeList;
        for (int j = 0; j < newNodeListLength; ++j) {
            if (!tempNodeList.item(j).getNodeName().equals(DELETEDOBJECTS)) continue;
            newNodeList = tempNodeList.item(j).getChildNodes();
            int length = newNodeList.getLength();
            for (int i = 0; i < length; ++i) {
                String strType = newNodeList.item(i).getNodeName();
                NamedNodeMap newNodeMap = newNodeList.item(i).getAttributes();
                String strNewId = newNodeMap.getNamedItem("Id").getNodeValue();
                objects.add(strNewId);
            }
        }
        return objects;
    }

    public static Vector checkIn(CMetadata projectRepository, String strChangeName, String strChangeDesc) throws MdException {
        Vector oldDestroyedObjects;
        Document ioutDoc;
        String strCleanChangeName = MetadataUtil.cleanStringForXML(strChangeName);
        String strCleanChangeDesc = MetadataUtil.cleanStringForXML(strChangeDesc);
        StringBuffer outXML = new StringBuffer("<CheckinMetadata><Metadata/><ProjectReposid>");
        outXML.append(projectRepository.getFQID());
        outXML.append("</ProjectReposid><ChangeName>");
        outXML.append(strCleanChangeName);
        outXML.append("</ChangeName>");
        if (strChangeDesc != null && strChangeDesc.length() > 0) {
            outXML.append("<ChangeDesc>");
            outXML.append(strCleanChangeDesc);
            outXML.append("</ChangeDesc>");
        }
        outXML.append("<ns>SAS</ns><flags>");
        outXML.append(1024);
        outXML.append("</flags><options></options></CheckinMetadata>");
        Util.printOutputln("Starting checkin");
        try {
            ioutDoc = MetadataUtil.DoRequest(outXML.toString(), false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        MdObjectStore store = MdObjectFactory.createObjectStore();
        Vector newSimpleObjects = MdChangeManagementUtil.createAllObjects(store, ioutDoc);
        if (newSimpleObjects.size() > 0) {
            MdChangeManagementUtil.fireMetadataCheckIn(new ChangeEvent(projectRepository), newSimpleObjects);
        }
        if ((oldDestroyedObjects = MdChangeManagementUtil.createDestroyedObjects(ioutDoc)).size() > 0) {
            MdChangeManagementUtil.fireMetadataDestroyed(new ChangeEvent(projectRepository), oldDestroyedObjects);
        }
        if (newSimpleObjects.size() == 0) {
            store.dispose();
        }
        Util.printOutputln("Ending checkin");
        return newSimpleObjects;
    }

    public static void fetch(Vector metaObjects, CMetadata projectRepository) throws MdException {
        Document ioutDoc;
        StringBuffer outXML = new StringBuffer("<FetchMetadata><METADATA>");
        for (int i = 0; i < metaObjects.size(); ++i) {
            CMetadata object = (CMetadata)metaObjects.get(i);
            StringBuffer appXML = new StringBuffer("<");
            appXML.append(object.getCMetadataType());
            appXML.append(" Id=\"");
            appXML.append(object.getFQID());
            appXML.append("\" />");
            outXML.append(appXML);
        }
        outXML.append("</METADATA><ProjectReposid>");
        outXML.append(projectRepository.getFQID());
        outXML.append("</ProjectReposid><ns>SAS</ns><flags>");
        outXML.append(1024);
        outXML.append("</flags><options></options></FetchMetadata>");
        Util.printOutputln("Starting fetch");
        try {
            ioutDoc = MetadataUtil.DoRequest(outXML.toString(), false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        MdObjectStore store = MdObjectFactory.createObjectStore();
        Vector newSimpleObjects = MdChangeManagementUtil.createAllObjects(store, ioutDoc);
        MdChangeManagementUtil.fireMetadataFetched(new ChangeEvent(projectRepository), newSimpleObjects);
        store.dispose();
        Util.printOutputln("Ending fetch");
    }

    public static void copyObjects(Vector metaObjects, CMetadata repository) throws MdException {
        Document ioutDoc;
        StringBuffer outXML = new StringBuffer("<CopyMetadata><METADATA>");
        for (int i = 0; i < metaObjects.size(); ++i) {
            CMetadata object = (CMetadata)metaObjects.get(i);
            StringBuffer appXML = new StringBuffer("<");
            appXML.append(object.getCMetadataType());
            appXML.append(" Id=\"");
            appXML.append(object.getFQID());
            appXML.append("\" />");
            outXML.append(appXML);
        }
        outXML.append("</METADATA><ToReposid>");
        outXML.append(repository.getFQID());
        outXML.append("</ToReposid><ns>SAS</ns><flags>");
        outXML.append(1024);
        outXML.append("</flags><options></options></CopyMetadata>");
        Util.printOutputln("Starting copy");
        try {
            ioutDoc = MetadataUtil.DoRequest(outXML.toString(), false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        MdObjectStore store = MdObjectFactory.createObjectStore();
        Vector newSimpleObjects = MdChangeManagementUtil.createAllObjects(store, ioutDoc);
        MdChangeManagementUtil.fireMetadataCopied(new ChangeEvent(repository), newSimpleObjects);
        store.dispose();
        Util.printOutputln("Ending copy");
    }

    public static void undoCheckout(Vector metaObjects, CMetadata projectRepository) throws MdException {
        Document ioutDoc;
        StringBuffer outXML = new StringBuffer("<UndoCheckoutMetadata><METADATA>");
        for (int i = 0; i < metaObjects.size(); ++i) {
            CMetadata object = (CMetadata)metaObjects.get(i);
            StringBuffer appXML = new StringBuffer("<");
            appXML.append(object.getCMetadataType());
            appXML.append(" Id=\"");
            appXML.append(object.getFQID());
            appXML.append("\" />");
            outXML.append(appXML);
        }
        outXML.append("</METADATA><ns>SAS</ns><flags>");
        int flags = 1032;
        outXML.append(flags);
        outXML.append("</flags><options></options></UndoCheckoutMetadata>");
        Util.printOutputln("Starting undocheckout");
        try {
            ioutDoc = MetadataUtil.DoRequest(outXML.toString(), false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        MdObjectStore store = MdObjectFactory.createObjectStore();
        Vector newSimpleObjects = MdChangeManagementUtil.createAllObjects(store, ioutDoc);
        MdChangeManagementUtil.fireMetadataUndoCheckout(new ChangeEvent(projectRepository), newSimpleObjects);
        Util.printOutputln("Ending undocheckout");
        store.dispose();
    }

    public static void destroy(Vector metaObjects, CMetadata projectRepository) throws MdException {
        StringBuffer outXML = new StringBuffer("<DeleteMetadata><METADATA>");
        for (int i = 0; i < metaObjects.size(); ++i) {
            CMetadata object = (CMetadata)metaObjects.get(i);
            StringBuffer appXML = new StringBuffer("<");
            appXML.append(object.getCMetadataType());
            appXML.append(" Id=\"");
            appXML.append(object.getFQID());
            appXML.append("\" />");
            outXML.append(appXML);
        }
        outXML.append("</METADATA><ns>SAS</ns><flags>");
        outXML.append(0x10000000);
        outXML.append("</flags><options></options></DeleteMetadata>");
        Util.printOutputln("Starting destroy");
        try {
            Document ioutDoc = MetadataUtil.DoRequest(outXML.toString(), false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        MdChangeManagementUtil.fireMetadataUndoCheckout(new ChangeEvent(projectRepository), metaObjects);
        Util.printOutputln("Ending destroy");
    }

    public static void lockObjects(CMetadata cmGroupTop, Vector nodeObjects, CMetadata projectRepository) throws MdException {
    }

    public static void addMdChangeManagementEventListener(MdChangeManagementEventListener l) {
        listenerList.add(MdChangeManagementEventListener.class, l);
    }

    public static void removeMdChangeManagementEventListener(MdChangeManagementEventListener l) {
        listenerList.remove(MdChangeManagementEventListener.class, l);
    }

    public static void fireMetadataCheckOut(ChangeEvent e, Vector items) {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdChangeManagementEventListener.class) continue;
            ((MdChangeManagementEventListener)listeners[i + 1]).objectsCheckedOut(e, items);
        }
    }

    public static void fireNewObjectsAdded(ChangeEvent e, ArrayList objects) {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdChangeManagementEventListener.class) continue;
            ((MdChangeManagementEventListener)listeners[i + 1]).objectsNewAdded(e, objects);
        }
    }

    public static void fireMetadataFetched(ChangeEvent e, Vector items) {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdChangeManagementEventListener.class) continue;
            ((MdChangeManagementEventListener)listeners[i + 1]).objectsFetched(e, items);
        }
    }

    public static void fireMetadataCopied(ChangeEvent e, Vector items) {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdChangeManagementEventListener.class) continue;
            ((MdChangeManagementEventListener)listeners[i + 1]).objectsCopied(e, items);
        }
    }

    public static void fireMetadataLocked(ChangeEvent e, Vector items) {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdChangeManagementEventListener.class) continue;
            ((MdChangeManagementEventListener)listeners[i + 1]).objectsLocked(e, items);
        }
    }

    public static void fireMetadataUnLocked(ChangeEvent e, Vector items) {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdChangeManagementEventListener.class) continue;
            ((MdChangeManagementEventListener)listeners[i + 1]).objectsUnLocked(e, items);
        }
    }

    public static void fireMetadataCheckIn(ChangeEvent e, Vector items) {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdChangeManagementEventListener.class) continue;
            ((MdChangeManagementEventListener)listeners[i + 1]).objectsCheckedIn(e, items);
        }
    }

    public static void fireMetadataDestroyed(ChangeEvent e, Vector items) {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdChangeManagementEventListener.class) continue;
            ((MdChangeManagementEventListener)listeners[i + 1]).objectsDestroyed(e, items);
        }
    }

    public static void fireMetadataUndoCheckout(ChangeEvent e, Vector items) {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdChangeManagementEventListener.class) continue;
            ((MdChangeManagementEventListener)listeners[i + 1]).objectsUndoCheckout(e, items);
        }
    }

    private static List getGroupObjectTypes() {
        if (groupableTypes == null || groupableTypes.size() == 0) {
            groupableTypes = new ArrayList();
            groupableTypes.add("Cube");
            groupableTypes.add("ExternalTable");
            groupableTypes.add("PhysicalTable");
            groupableTypes.add("Report");
            groupableTypes.add("TextStore");
            groupableTypes.add("Document");
            groupableTypes.add("DeployedComponent");
            groupableTypes.add("SASLibrary");
            groupableTypes.add("Tree");
            groupableTypes.add("Job");
        }
        return groupableTypes;
    }

    private static List getCheckoutObjectTypes() {
        if (checkoutableTypes == null || checkoutableTypes.size() == 0) {
            checkoutableTypes = new ArrayList();
            checkoutableTypes.add("Cube");
            checkoutableTypes.add("ExternalTable");
            checkoutableTypes.add("PhysicalTable");
            checkoutableTypes.add("Report");
            checkoutableTypes.add("TextStore");
            checkoutableTypes.add("Document");
            checkoutableTypes.add("DeployedComponent");
            checkoutableTypes.add("SASLibrary");
            checkoutableTypes.add("Tree");
            checkoutableTypes.add("Job");
        }
        return checkoutableTypes;
    }
}

