/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata;

import com.sas.metadata.CMetadata;
import com.sas.metadata.MdException;
import com.sas.metadata.MdObjectFactory;
import com.sas.metadata.MdObjectStore;
import com.sas.metadata.MdStore;
import com.sas.metadata.MetadataState;
import com.sas.metadata.MetadataUtil;
import com.sas.metadata.Util;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class AssociationList
extends AbstractList
implements MetadataState,
Cloneable {
    private int m_state = 0;
    protected String m_strAssociationName;
    protected List m_deletedItems;
    protected String m_strAssociationType = null;
    protected boolean m_isPredAssoc = false;
    protected CMetadata m_parent = null;
    protected String m_props = null;
    private volatile Vector m_ids;
    private static final int FUNCTION_NORMAL = 0;
    private static final int FUNCTION_REPLACE = 1;
    private static final int FUNCTION_REMOVE = 2;
    protected transient int modCount = 0;

    public AssociationList(String strAssociationName, int initialCapacity, int capacityIncrement) {
        this.m_ids = new Vector(initialCapacity, capacityIncrement);
        this.m_strAssociationName = strAssociationName;
    }

    public AssociationList(String strAssociationName, int initialCapacity) {
        this(strAssociationName, initialCapacity, 0);
    }

    public AssociationList(String strAssociationName) {
        this(strAssociationName, 10);
    }

    public AssociationList(String strAssociationType, String strAssociationName, boolean isPredAssoc, String properties, CMetadata parentObj) {
        this(strAssociationName, 10);
        this.setAssociationType(strAssociationType);
        this.setIsPredAssoc(isPredAssoc);
        this.setParent(parentObj);
        this.setProperties(properties);
    }

    public AssociationList(String strAssociationName, Object obj) {
        this.m_ids = new Vector(1);
        String id = ((CMetadata)obj).getFQID();
        if (id != null && id.length() > 0) {
            this.m_ids.add(id);
        }
        this.m_state = 0;
        this.m_strAssociationName = strAssociationName;
    }

    public AssociationList(String strAssociationName, Collection c) {
        this.m_ids = new Vector(c.size());
        for (Object obj : c) {
            String id = ((CMetadata)obj).getFQID();
            if (id == null || id.length() <= 0) continue;
            this.m_ids.add(id);
        }
        this.m_strAssociationName = strAssociationName;
    }

    public String generateAssociationXML(boolean fRequired, String callingObjectID) {
        StringBuffer strXML = new StringBuffer("");
        boolean fCreatedStartingBlock = false;
        if (!fRequired) {
            if (this.m_state == 0) {
                return strXML.toString();
            }
            if (this.m_state == 1) {
                return strXML.toString();
            }
            if (this.m_state == 64 || this.m_state == 32) {
                return strXML.toString();
            }
            if (((this.m_state & 0x20) > 0 || (this.m_state & 0x40) > 0) && (this.m_state & 0x10) <= 0 && this.m_ids.size() > 0) {
                if ((this.m_state & 2) > 0) {
                    return strXML.toString();
                }
                if ((this.m_state & 4) > 0 && !this.getIsPredAssoc()) {
                    return strXML.toString();
                }
            }
        }
        if ((this.m_state & 2) > 0 && (this.m_state & 0x20) <= 0 || (this.m_state & 0x10) > 0) {
            strXML.append("<");
            strXML.append(this.m_strAssociationName);
            strXML.append(" Function=\"Replace\">");
            fCreatedStartingBlock = true;
        }
        for (int i = 0; i < this.m_ids.size(); ++i) {
            String objID;
            CMetadata obj;
            if (!fCreatedStartingBlock) {
                fCreatedStartingBlock = true;
                strXML.append("<");
                strXML.append(this.m_strAssociationName);
                strXML.append(">");
            }
            if ((obj = (CMetadata)this.getObjectforID(objID = (String)this.m_ids.elementAt(i))) == null) continue;
            strXML.append("<");
            strXML.append(obj.getCMetadataType());
            strXML.append(" ObjRef=\"");
            strXML.append(obj.getId());
            strXML.append("\"/>");
        }
        if (fCreatedStartingBlock) {
            strXML.append("</");
            strXML.append(this.m_strAssociationName);
            strXML.append(">");
        }
        return strXML.toString();
    }

    public String generateAssociationAllXML(boolean fRequired, String callingObjectID) {
        if (this.m_ids != null && this.m_ids.size() == 0) {
            StringBuffer strXML = new StringBuffer(this.m_strAssociationName.length() + 3);
            strXML.append("<");
            strXML.append(this.m_strAssociationName);
            strXML.append("/>");
            return strXML.toString();
        }
        StringBuffer strXML = new StringBuffer();
        boolean fCreatedStartingBlock = false;
        for (int i = 0; i < this.m_ids.size(); ++i) {
            String objID;
            CMetadata obj;
            if (!fCreatedStartingBlock) {
                fCreatedStartingBlock = true;
                strXML.append("<");
                strXML.append(this.m_strAssociationName);
                strXML.append(">");
            }
            if ((obj = (CMetadata)this.getObjectforID(objID = (String)this.m_ids.elementAt(i))) == null) continue;
            strXML.append("<");
            strXML.append(obj.getCMetadataType());
            strXML.append(" ObjRef=\"");
            strXML.append(obj.getId());
            strXML.append("\"/>");
        }
        if (fCreatedStartingBlock) {
            strXML.append("</");
            strXML.append(this.m_strAssociationName);
            strXML.append(">");
        }
        return strXML.toString();
    }

    public String generateEmptyReplaceXML() {
        StringBuffer strXML = new StringBuffer("");
        if (this.m_strAssociationName.length() > 0) {
            strXML.append("<");
            strXML.append(this.m_strAssociationName);
            strXML.append(" Function=\"Replace\"></");
            strXML.append(this.m_strAssociationName);
            strXML.append(">");
        }
        return strXML.toString();
    }

    public String generateAssociationWriteXML(boolean fRequired, String callingObjectID) {
        boolean writeableOutput = false;
        int function = 0;
        if (fRequired || this.getIsRequired()) {
            if (this.m_parent.isNewObject()) {
                writeableOutput = true;
            } else if (!this.getMaxCardinality().equals("1")) {
                writeableOutput = true;
            }
            if (writeableOutput) {
                if ((this.m_state & 0x10) > 0) {
                    function = 1;
                } else if ((this.m_state & 4) > 0 && (this.m_state & 2) > 0) {
                    this.generateObjectAndAssociationRemoveXML();
                } else if ((this.m_state & 2) > 0) {
                    function = 2;
                }
            }
        } else if ((this.m_state & 0x10) > 0) {
            function = 1;
            writeableOutput = true;
        } else if ((this.m_state & 4) > 0 && (this.m_state & 2) > 0) {
            this.generateObjectAndAssociationRemoveXML();
            writeableOutput = true;
        } else if ((this.m_state & 2) > 0) {
            function = 2;
            if (!this.m_parent.isNewObject()) {
                writeableOutput = true;
            }
        } else if ((this.m_state & 4) > 0) {
            writeableOutput = true;
        }
        if (writeableOutput) {
            StringBuffer strXML = new StringBuffer();
            strXML.append("<");
            strXML.append(this.m_strAssociationName);
            switch (function) {
                case 1: {
                    strXML.append(" Function=\"Replace\">");
                    break;
                }
                case 2: {
                    strXML.append(" Function=\"Remove\">");
                    break;
                }
                default: {
                    strXML.append(">");
                }
            }
            if (function == 2) {
                for (int i = 0; this.m_deletedItems != null && i < this.m_deletedItems.size(); ++i) {
                    String objID = (String)this.m_deletedItems.get(i);
                    CMetadata obj = (CMetadata)this.getObjectforID(objID);
                    if (obj == null || this.contains(obj)) continue;
                    strXML.append("<");
                    strXML.append(obj.getCMetadataType());
                    strXML.append(" ObjRef=\"");
                    strXML.append(obj.getId());
                    strXML.append("\"/>");
                }
            } else {
                for (int i = 0; this.m_ids != null && i < this.m_ids.size(); ++i) {
                    String objID = (String)this.m_ids.get(i);
                    CMetadata obj = (CMetadata)this.getObjectforID(objID);
                    if (obj == null) continue;
                    strXML.append("<");
                    strXML.append(obj.getCMetadataType());
                    strXML.append(" ObjRef=\"");
                    strXML.append(obj.getId());
                    strXML.append("\"/>");
                }
            }
            strXML.append("</");
            strXML.append(this.m_strAssociationName);
            strXML.append(">");
            return strXML.toString();
        }
        return "";
    }

    public String generateObjectAndAssociationRemoveXML() {
        MdStore parentStore;
        if (this.m_parent.isNewObject()) {
            return "";
        }
        StringBuffer outXML = new StringBuffer();
        boolean createdStart = false;
        if (this.m_deletedItems != null && this.m_deletedItems.size() > 0) {
            for (String deletedId : this.m_deletedItems) {
                CMetadata otherObject = (CMetadata)this.getObjectforID(deletedId);
                if (otherObject == null || this.contains(otherObject)) continue;
                if (!createdStart) {
                    outXML.append("<");
                    outXML.append(this.m_parent.getCMetadataType());
                    outXML.append(" Id=\"");
                    outXML.append(this.m_parent.getId());
                    outXML.append("\" >");
                    outXML.append("<");
                    outXML.append(this.m_strAssociationName);
                    outXML.append(" Function=\"Remove\">");
                    createdStart = true;
                }
                outXML.append("<");
                outXML.append(otherObject.getCMetadataType());
                outXML.append(" ObjRef=\"");
                outXML.append(otherObject.getId());
                outXML.append("\"/>");
            }
            if (createdStart) {
                outXML.append("</");
                outXML.append(this.m_strAssociationName);
                outXML.append(">");
                outXML.append("</");
                outXML.append(this.m_parent.getCMetadataType());
                outXML.append(">");
            }
        }
        if (outXML.length() != 0 && (parentStore = this.m_parent.getObjectStore()).getStoreType() == 1) {
            ((MdObjectStore)parentStore).appendWriteBuffer(outXML.toString());
        }
        return outXML.toString();
    }

    public void updateObjectID(String strOldId, String strNewId) {
        if (this.m_parent == null) {
            return;
        }
        String parentID = this.m_parent.getFQID();
        if (parentID.equalsIgnoreCase(strOldId) || parentID.equalsIgnoreCase(strNewId)) {
            for (int i = 0; i < this.m_ids.size(); ++i) {
                String id = (String)this.m_ids.get(i);
                CMetadata otherObject = (CMetadata)this.getObjectforID(id);
                if (otherObject == null) continue;
                otherObject.updateAssnsIds(strOldId, strNewId);
            }
        } else {
            for (int i = 0; i < this.m_ids.size(); ++i) {
                String id = (String)this.m_ids.get(i);
                if (!id.equalsIgnoreCase(strOldId)) continue;
                this.m_ids.set(i, strNewId);
            }
        }
    }

    protected void removeOppositeAssn(String otherID) throws MdException {
        if (this.m_parent == null) {
            return;
        }
        CMetadata otherObject = (CMetadata)this.getObjectforID(otherID, true);
        if (otherObject == null) {
            return;
        }
        if (this.getIsPredAssoc()) {
            AssociationList inObjectList = null;
            inObjectList = otherObject.getMdObjectAssociation(this.m_strAssociationType.substring(this.m_strAssociationType.indexOf(45) + 1, this.m_strAssociationType.length()));
            if (inObjectList != null && inObjectList.contains(this.m_parent)) {
                inObjectList.removeElement(this.m_parent, false);
            }
        } else {
            AssociationList inObjectList = null;
            inObjectList = otherObject.getMdObjectAssociation(this.m_strAssociationType.substring(0, this.m_strAssociationType.indexOf(45)));
            if (inObjectList != null && inObjectList.contains(this.m_parent)) {
                inObjectList.removeElement(this.m_parent, false);
            }
        }
    }

    public void updateOppositeSideAssn() {
        if (this.m_ids != null) {
            for (int i = 0; i < this.m_ids.size(); ++i) {
                try {
                    this.setOppositeAssn((String)this.m_ids.get(i));
                    continue;
                }
                catch (MdException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void setOppositeAssn(String otherID) throws MdException {
        if (this.m_parent == null) {
            return;
        }
        CMetadata otherObject = (CMetadata)this.getObjectforID(otherID);
        if (otherObject == null) {
            return;
        }
        if (this.getIsPredAssoc()) {
            AssociationList inObjectList = null;
            inObjectList = otherObject.getMdObjectAssociation(this.m_strAssociationType.substring(this.m_strAssociationType.indexOf(45) + 1, this.m_strAssociationType.length()));
            if (inObjectList != null) {
                if (inObjectList.contains(this.m_parent)) {
                    return;
                }
                if (this.m_props != null && this.m_props.charAt(3) == '1') {
                    inObjectList.add(this.m_parent, 64, false);
                } else {
                    inObjectList.add(this.m_parent, 32, false);
                }
            }
            inObjectList = null;
        } else {
            AssociationList inObjectList = null;
            inObjectList = otherObject.getMdObjectAssociation(this.m_strAssociationType.substring(0, this.m_strAssociationType.indexOf(45)));
            if (inObjectList != null) {
                if (inObjectList.contains(this.m_parent)) {
                    return;
                }
                if (this.m_props != null && this.m_props.charAt(1) == '1') {
                    inObjectList.add(this.m_parent, 64, false);
                } else {
                    inObjectList.add(this.m_parent, 32, false);
                }
            }
            Object var3_4 = null;
        }
    }

    protected AssociationList getOppositeAssn(String otherID) throws MdException {
        if (this.m_parent == null) {
            return null;
        }
        CMetadata otherObject = (CMetadata)this.getObjectforID(otherID);
        if (otherObject == null) {
            return null;
        }
        if (this.getIsPredAssoc()) {
            AssociationList inObjectList = null;
            inObjectList = otherObject.getMdObjectAssociation(this.m_strAssociationType.substring(this.m_strAssociationType.indexOf(45) + 1, this.m_strAssociationType.length()));
            return inObjectList;
        }
        AssociationList inObjectList = null;
        inObjectList = otherObject.getMdObjectAssociation(this.m_strAssociationType.substring(0, this.m_strAssociationType.indexOf(45)));
        return inObjectList;
    }

    public Vector getObjectIDs() {
        return this.m_ids;
    }

    public void setObjectIDs(List newIds) {
        ++this.modCount;
        this.m_ids = new Vector(newIds);
        this.setSize(this.m_ids.size());
    }

    public CMetadata getParent() {
        return this.m_parent;
    }

    public void setParent(CMetadata inParent) {
        this.m_parent = inParent;
    }

    public void setProperties(String inProperties) {
        this.m_props = inProperties;
    }

    public String getProperties() {
        return this.m_props;
    }

    public String getAssociationName() {
        return this.m_strAssociationName;
    }

    public String getAssociationType() {
        return this.m_strAssociationType;
    }

    public void setAssociationType(String type) {
        this.m_strAssociationType = type;
    }

    public void setIsPredAssoc(boolean ispred) {
        this.m_isPredAssoc = ispred;
    }

    public boolean getIsPredAssoc() {
        return this.m_isPredAssoc;
    }

    public String getMinCardinality() {
        if (this.m_props != null && this.m_props.length() == 6) {
            if (this.m_isPredAssoc) {
                return this.m_props.substring(0, 1);
            }
            return this.m_props.substring(2, 3);
        }
        return null;
    }

    public String getMaxCardinality() {
        if (this.m_props != null && this.m_props.length() == 6) {
            if (this.m_isPredAssoc) {
                return this.m_props.substring(1, 2);
            }
            return this.m_props.substring(3, 4);
        }
        return null;
    }

    public boolean getIsRequired() {
        if (this.m_props != null && this.m_props.length() == 6) {
            if (this.m_isPredAssoc) {
                return this.m_props.charAt(4) != '0';
            }
            return this.m_props.charAt(5) != '0';
        }
        return false;
    }

    public List getDeletedItems() {
        return this.m_deletedItems;
    }

    public int getState() {
        return this.m_state;
    }

    public void setState(int iValue) {
        this.setState(iValue, true);
    }

    public void setState(int iValue, boolean AddToChangeIfChanged) {
        switch (iValue) {
            case 0: 
            case 1: {
                this.m_state = iValue;
                break;
            }
            case 32: 
            case 64: {
                if ((this.m_state & 0x20) > 0) {
                    this.m_state &= 0xFFFFFFDF;
                }
                if ((this.m_state & 0x40) > 0) {
                    this.m_state &= 0xFFFFFFBF;
                }
                if ((this.m_state & 1) > 0) {
                    this.m_state &= 0xFFFFFFFE;
                }
                this.m_state |= iValue;
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                if ((this.m_state & 1) > 0) {
                    this.m_state &= 0xFFFFFFFE;
                }
                this.m_state |= iValue;
                break;
            }
            default: {
                this.m_state = iValue;
            }
        }
        if ((iValue == 2 || iValue == 4 || iValue == 16) && this.m_parent != null && AddToChangeIfChanged) {
            this.m_parent.setState(1);
            this.m_parent.addElementToChangeList(this.m_parent);
        }
    }

    public void resetState(int iValue) {
        this.resetState(iValue, false);
    }

    public void resetState(int iValue, boolean forceState) {
        this.m_state = forceState ? ((this.m_state & 0x20) > 0 ? 32 : ((this.m_state & 0x40) > 0 ? 64 : iValue)) : (this.m_state &= ~iValue);
    }

    public boolean isGoToServerForAssoc() {
        if (this.m_parent == null || this.m_parent.isNewObject()) {
            return false;
        }
        if (this.m_parent.getObjectStore() == null) {
            Util.printOutputln("DEBUG NOTE: Object Store does not exist for " + this.m_parent.getName());
            return false;
        }
        return (this.m_state & 0x20) > 0 || this.m_state == 0;
    }

    public void setSize(int newSize) {
        ++this.modCount;
        if (newSize < this.m_ids.size()) {
            this.setState(2);
            for (int index = newSize; index < this.m_ids.size(); ++index) {
                this._addDeletedItem(this.m_ids.elementAt(index));
            }
        }
        this.m_ids.setSize(newSize);
    }

    public void setElementAt(Object obj, int index) {
        this.setState(4);
        this.setState(2);
        if (obj != null && this.m_ids.size() > 0 && index < this.m_ids.size()) {
            this._addDeletedItem(this.m_ids.elementAt(index));
            String id = ((CMetadata)obj).getFQID();
            if (id != null && id.length() > 0) {
                this.m_ids.setElementAt(id, index);
                try {
                    this.setOppositeAssn(id);
                }
                catch (MdException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public synchronized void removeElementAt(int index) {
        ++this.modCount;
        if (this.m_ids.size() > 0 && index < this.m_ids.size()) {
            this._addDeletedItem(this.m_ids.elementAt(index));
            this.m_ids.removeElementAt(index);
        }
    }

    public synchronized void insertElementAt(Object obj, int index) {
        String id;
        ++this.modCount;
        this.setState(4);
        if (obj != null && (id = ((CMetadata)obj).getFQID()) != null && id.length() > 0) {
            this.m_ids.insertElementAt(id, index);
            try {
                this.setOppositeAssn(id);
            }
            catch (MdException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void insertElementAt(Object obj, int index, boolean objectModified) {
        String id;
        ++this.modCount;
        if (objectModified) {
            this.setState(4);
        }
        if (obj != null && (id = ((CMetadata)obj).getFQID()) != null && id.length() > 0) {
            this.m_ids.insertElementAt(id, index);
            try {
                this.setOppositeAssn(id);
            }
            catch (MdException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void addElement(Object obj) {
        String id;
        ++this.modCount;
        this.setState(4);
        if (obj != null && (id = ((CMetadata)obj).getFQID()) != null && id.length() > 0) {
            this.m_ids.addElement(id);
            try {
                this.setOppositeAssn(id);
            }
            catch (MdException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized boolean removeElement(Object obj) {
        String id;
        ++this.modCount;
        boolean removed = false;
        if (obj != null && (id = ((CMetadata)obj).getFQID()) != null && id.length() > 0) {
            removed = this.m_ids.remove(id);
            this._addDeletedItem(id);
        }
        return removed;
    }

    public synchronized boolean removeElement(Object obj, boolean processOtherSide) {
        String id;
        ++this.modCount;
        boolean removed = false;
        if (obj != null && (id = ((CMetadata)obj).getFQID()) != null && id.length() > 0) {
            removed = this.m_ids.remove(id);
            this._addDeletedItem(id, processOtherSide);
        }
        return removed;
    }

    public synchronized void removeAllElements() {
        this.setState(16);
        int id_size = this.m_ids.size();
        for (int index = id_size - 1; index >= 0; --index) {
            this._addDeletedItem(this.m_ids.elementAt(index));
        }
        this.m_ids.removeAllElements();
    }

    public synchronized void removeAllElements(boolean objectChanged) throws MdException {
        if (this.m_ids == null || this.m_ids.size() == 0) {
            return;
        }
        int id_size = this.m_ids.size();
        for (int index = id_size - 1; index >= 0; --index) {
            if (objectChanged) {
                this._addDeletedItem(this.m_ids.elementAt(index));
                continue;
            }
            this.removeOppositeAssn((String)this.m_ids.elementAt(index));
        }
        this.m_ids.removeAllElements();
    }

    @Override
    public synchronized Object set(int index, Object obj) {
        if (this.m_ids.size() == 0) {
            String id;
            if (obj != null && (id = ((CMetadata)obj).getFQID()) != null) {
                this.setState(4);
                this.m_ids.add(id);
                try {
                    this.setOppositeAssn(id);
                }
                catch (MdException e) {
                    e.printStackTrace();
                }
                return null;
            }
        } else {
            String id;
            this._addDeletedItem(this.m_ids.elementAt(index));
            if (obj != null && (id = ((CMetadata)obj).getFQID()) != null) {
                this.setState(4);
                this.setState(2);
                String oldID = this.m_ids.set(index, id);
                try {
                    this.setOppositeAssn(id);
                }
                catch (MdException e) {
                    e.printStackTrace();
                }
                return this.getObjectforID(oldID);
            }
        }
        return null;
    }

    protected synchronized boolean add(Object obj, int state) {
        return this.add(obj, state, true);
    }

    protected synchronized boolean add(Object obj, int state, boolean processOtherSideOfAssn) {
        String objID;
        ++this.modCount;
        if (this.getState() == 0) {
            this.setState(state, false);
        } else {
            this.setState(8, false);
        }
        boolean ret = false;
        if (obj != null && (objID = ((CMetadata)obj).getFQID()) != null && objID.length() > 0) {
            ret = this.m_ids.add(objID);
            if (processOtherSideOfAssn) {
                try {
                    this.setOppositeAssn(objID);
                }
                catch (MdException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    @Override
    public synchronized boolean add(Object obj) {
        String objID;
        ++this.modCount;
        this.setState(4);
        boolean ret = false;
        if (obj != null && (objID = ((CMetadata)obj).getFQID()) != null && objID.length() > 0) {
            ret = this.m_ids.add(objID);
            try {
                this.setOppositeAssn(objID);
            }
            catch (MdException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    @Override
    public synchronized boolean remove(Object o) {
        return this.removeElement(o);
    }

    @Override
    public synchronized void add(int index, Object element) {
        this.insertElementAt(element, index);
    }

    @Override
    public synchronized Object remove(int index) {
        ++this.modCount;
        if (this.m_ids.size() > 0) {
            String oldID = (String)this.m_ids.remove(index);
            this._addDeletedItem(oldID);
            return this.getObjectforID(oldID);
        }
        return null;
    }

    protected Object getObjectforID(String ID) {
        return this.getObjectforID(ID, false);
    }

    protected Object getObjectforID(String ID, boolean hashOnly) {
        CMetadata ret = null;
        if (ID != null && ID.length() > 0 && this.m_parent != null) {
            MdStore oStore = this.m_parent.getObjectStore();
            if (oStore.getStoreType() == 1) {
                ret = ((MdObjectStore)oStore).getObject(ID, hashOnly);
                if (ret == null && !hashOnly && ID.indexOf(36) <= -1 && !((MdObjectStore)oStore).getDeletedObjects().containsKey(ID)) {
                    try {
                        Util.printOutputln("DEBUG_NOTE: " + this.m_parent.getCMetadataType() + "Id: " + this.m_parent.getId() + ", AssociationList, (" + this.getAssociationName() + ") going to server for object" + ID);
                        List returnObjects = MetadataUtil.getMetadataObjectsSubset(oStore, "A0000001." + ID.substring(0, ID.indexOf(".")), "Root", 412, "<XMLSelect search=\"*[@Id='" + ID + "']\"/>", true);
                        if (returnObjects != null && returnObjects.size() == 1) {
                            ret = (CMetadata)returnObjects.get(0);
                        }
                    }
                    catch (MdException mex) {
                        mex.printStackTrace();
                    }
                }
            } else if (oStore.getStoreType() == 0) {
                ret = MdObjectFactory.getObject(ID);
            }
        }
        return ret;
    }

    @Override
    public synchronized void clear() {
        this.removeAllElements();
    }

    @Override
    public synchronized boolean addAll(Collection c) {
        ++this.modCount;
        this.setState(4);
        boolean ret = false;
        for (Object obj : c) {
            String id;
            if (obj == null || (id = ((CMetadata)obj).getFQID()) == null || id.length() <= 0) continue;
            ret = this.m_ids.add(id);
            try {
                this.setOppositeAssn(id);
            }
            catch (MdException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    @Override
    public synchronized boolean removeAll(Collection c) {
        boolean ret = false;
        for (Object obj : c) {
            String id;
            if (obj == null || !(obj instanceof CMetadata) || (id = ((CMetadata)obj).getFQID()) == null || id.length() <= 0) continue;
            this._addDeletedItem(id);
            if (!this.m_ids.remove(id)) continue;
            ret = true;
        }
        return ret;
    }

    @Override
    public synchronized boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean addAll(int index, Collection c) {
        ++this.modCount;
        this.setState(4);
        int numnew = c.size();
        int incrementer = 0;
        for (Object obj : c) {
            String id;
            if (obj == null || !(obj instanceof CMetadata) || (id = ((CMetadata)obj).getFQID()) == null || id.length() <= 0) continue;
            this.m_ids.add(index + incrementer, id);
            ++incrementer;
            try {
                this.setOppositeAssn(id);
            }
            catch (MdException e) {
                e.printStackTrace();
            }
        }
        return numnew != 0;
    }

    @Override
    protected synchronized void removeRange(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    public synchronized void flushAll() {
        this.removeAllElements();
    }

    protected void _addDeletedItem(Object obj) {
        this._addDeletedItem(obj, true);
    }

    protected void _addDeletedItem(Object obj, boolean processOtherSide) {
        if (this.m_deletedItems == null) {
            this.m_deletedItems = new Vector();
        }
        if (!this.m_deletedItems.contains(obj)) {
            this.m_deletedItems.add(obj);
        }
        if (processOtherSide) {
            this.setState(2);
        } else {
            this.setState(8, false);
        }
        if (obj != null && obj instanceof String && processOtherSide) {
            try {
                this.removeOppositeAssn((String)obj);
            }
            catch (MdException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized Iterator iterator() {
        return new Itr();
    }

    @Override
    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public synchronized ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    public int capacity() {
        return this.m_ids.capacity();
    }

    public synchronized Object clone() {
        try {
            AssociationList cloneList = (AssociationList)super.clone();
            cloneList.modCount = 0;
            return cloneList;
        }
        catch (CloneNotSupportedException e) {
            return new InternalError();
        }
    }

    public void dispose() {
    }

    @Override
    public synchronized boolean contains(Object obj) {
        boolean ret = false;
        if (obj != null && obj instanceof CMetadata) {
            String id = ((CMetadata)obj).getFQID();
            ret = this.m_ids.contains(id);
        }
        return ret;
    }

    @Override
    public synchronized boolean containsAll(Collection c) {
        boolean ret = false;
        for (Object obj : c) {
            String id;
            if (obj == null || !(obj instanceof CMetadata) || this.m_ids.contains(id = ((CMetadata)obj).getFQID())) continue;
            return ret;
        }
        return true;
    }

    public synchronized void copyInto(Object[] anArray) {
        int num = 0;
        for (String id : this.m_ids) {
            if (id != null && id.length() > 0) {
                anArray[num] = this.getObjectforID(id);
            }
            ++num;
        }
    }

    public synchronized Object elementAt(int index) {
        String id = (String)this.m_ids.elementAt(index);
        if (id != null && id.length() > 0) {
            return this.getObjectforID(id);
        }
        return null;
    }

    public synchronized Enumeration elements() {
        return new Enumeration(){
            int count = 0;

            @Override
            public boolean hasMoreElements() {
                return this.count < AssociationList.this.getObjectIDs().size();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object nextElement() {
                AssociationList associationList = AssociationList.this;
                synchronized (associationList) {
                    if (this.count < AssociationList.this.getObjectIDs().size()) {
                        String id = (String)AssociationList.this.getObjectIDs().elementAt(this.count);
                        ++this.count;
                        if (id != null && id.length() > 0) {
                            return AssociationList.this.getObjectforID(id);
                        }
                        return null;
                    }
                }
                throw new NoSuchElementException(MdObjectFactory.getBundle().getString("List_Enumeration_68"));
            }
        };
    }

    public synchronized void ensureCapacity(int minCapacity) {
        ++this.modCount;
        this.m_ids.ensureCapacity(minCapacity);
    }

    public synchronized Object firstElement() {
        String id = (String)this.m_ids.firstElement();
        if (id != null && id.length() > 0) {
            return this.getObjectforID(id);
        }
        return null;
    }

    @Override
    public synchronized Object get(int index) {
        String id = (String)this.m_ids.get(index);
        if (id != null && id.length() > 0) {
            return this.getObjectforID(id);
        }
        return null;
    }

    @Override
    public synchronized int hashCode() {
        return super.hashCode();
    }

    @Override
    public synchronized int indexOf(Object elem) {
        return this.indexOf(elem, 0);
    }

    public synchronized int indexOf(Object elem, int index) {
        if (elem == null) {
            this.m_ids.indexOf(elem, index);
        } else if (elem instanceof CMetadata) {
            String id = ((CMetadata)elem).getFQID();
            return this.m_ids.indexOf(id, index);
        }
        return -1;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.m_ids.isEmpty();
    }

    public synchronized Object lastElement() {
        String id = (String)this.m_ids.get(this.m_ids.size() - 1);
        return this.getObjectforID(id);
    }

    @Override
    public synchronized int lastIndexOf(Object elem) {
        return this.lastIndexOf(elem, this.m_ids.size() - 1);
    }

    public synchronized int lastIndexOf(Object elem, int index) {
        if (elem == null) {
            return this.m_ids.lastIndexOf(elem, index);
        }
        if (elem instanceof CMetadata) {
            String id = ((CMetadata)elem).getFQID();
            return this.m_ids.lastIndexOf(id, index);
        }
        return -1;
    }

    @Override
    public synchronized int size() {
        if (this.m_ids != null) {
            return this.m_ids.size();
        }
        return 0;
    }

    @Override
    public synchronized List subList(int fromIndex, int toIndex) {
        List<String> idslist = Collections.synchronizedList(this.m_ids.subList(fromIndex, toIndex));
        ArrayList<Object> objList = new ArrayList<Object>(idslist.size());
        for (String objId : idslist) {
            objList.add(this.getObjectforID(objId));
        }
        return objList;
    }

    @Override
    public synchronized Object[] toArray() {
        Object[] result = new Object[this.m_ids.size()];
        int index = 0;
        for (String id : this.m_ids) {
            result[index] = this.getObjectforID(id);
            ++index;
        }
        return result;
    }

    @Override
    public synchronized Object[] toArray(Object[] a) {
        if (a.length < this.m_ids.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.m_ids.size());
        }
        int index = 0;
        for (String id : this.m_ids) {
            a[index] = this.getObjectforID(id);
            ++index;
        }
        if (a.length > this.m_ids.size()) {
            a[this.m_ids.size()] = null;
        }
        return a;
    }

    @Override
    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        Object[] objects = this.toArray();
        buf.append("[");
        int maxIndex = this.m_ids.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            buf.append(String.valueOf(objects[i]));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public synchronized void trimToSize() {
        ++this.modCount;
        this.m_ids.trimToSize();
    }

    protected class Itr
    implements Iterator {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount;

        protected Itr() {
            this.expectedModCount = AssociationList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != AssociationList.this.size();
        }

        public Object next() {
            try {
                Object next = AssociationList.this.get(this.cursor);
                this.checkForComodification();
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                AssociationList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = AssociationList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (AssociationList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        public Object previous() {
            try {
                Object previous = AssociationList.this.get(--this.cursor);
                this.checkForComodification();
                this.lastRet = this.cursor;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        public void set(Object o) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                AssociationList.this.set(this.lastRet, o);
                this.expectedModCount = AssociationList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object o) {
            this.checkForComodification();
            try {
                AssociationList.this.add(this.cursor++, o);
                this.lastRet = -1;
                this.expectedModCount = AssociationList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

