/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities;

import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeTypeInterface;
import com.sas.entities.AttributeTypeUtility;
import com.sas.entities.BaseAttributeDescriptor;
import com.sas.entities.EntityUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@SASScope(value="ALL")
public class AttributeType
extends BaseAttributeDescriptor
implements AttributeTypeInterface {
    static final long serialVersionUID = 4233132649438731517L;
    @SASScope
    public static String JAVA_LANG_OBJECT = "java.lang.Object";
    @SASScope
    public static String OBJECT_CONSTANT = "Object";
    private int sqlType;
    private Map validatorMappings;
    private String objectType;
    private String type;

    public AttributeType() {
        this(null, null);
    }

    public AttributeType(String name, String type) {
        this.initialize();
        if (name != null) {
            this.setName(name);
        }
        if (type != null) {
            this.setType(type);
        }
    }

    public AttributeType(String name, int sqlType) {
        this(name, sqlType, null);
    }

    public AttributeType(String name, int sqlType, String objectType) {
        this.initialize();
        if (name != null) {
            this.setName(name);
        }
        this.setSQLType(sqlType);
        this.setObjectType(objectType);
    }

    @SASScope
    protected void initialize() {
        this.sqlType = AttributeTypeUtility.NO_SQL_TYPE_DEFINED;
    }

    @Override
    public int getSQLType() {
        return this.sqlType;
    }

    @Override
    public void setSQLType(int sqlType) {
        this.sqlType = sqlType;
    }

    @Override
    public String getType() {
        Class javaClass = AttributeTypeUtility.getJavaClass(this.getSQLType());
        if (javaClass != null) {
            String className = javaClass.getName();
            if (this.getSQLType() == 2003) {
                className = this.getObjectType() + "[]";
            }
            return className;
        }
        if (this.getSQLType() == 2000) {
            return this.getObjectType();
        }
        return null;
    }

    @Override
    public void setType(String type) {
        if (AttributeTypeUtility.isArrayPropertyType(type)) {
            this.setSQLType(2003);
            this.setObjectType(AttributeTypeUtility.getArrayComponentType(type));
        } else if (AttributeTypeUtility.isNonComplexType(type)) {
            this.setSQLType(AttributeTypeUtility.getSQLDataType(type));
        } else if (AttributeTypeUtility.isWrapperType(type)) {
            String primitiveType = AttributeTypeUtility.getPrimitiveTypeFromWrapper(type);
            this.setSQLType(AttributeTypeUtility.getSQLDataType(primitiveType));
        } else if (type.equals(JAVA_LANG_OBJECT) || type.equals(OBJECT_CONSTANT)) {
            this.setSQLType(2000);
        } else {
            this.setSQLType(2000);
            this.setObjectType(type);
        }
    }

    @Override
    public List getValidators(String context) {
        ArrayList list = new ArrayList();
        if (this.validatorMappings != null && this.validatorMappings.containsKey(context)) {
            return (List)this.validatorMappings.get(context);
        }
        return list;
    }

    @Override
    public List getValidatorsContexts() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.validatorMappings != null) {
            Iterator iter = this.validatorMappings.keySet().iterator();
            String context = null;
            while (iter.hasNext()) {
                context = (String)iter.next();
                list.add(context);
            }
            return list;
        }
        return list;
    }

    @Override
    public void setValidators(String context, List validators) {
        if (this.validatorMappings == null) {
            this.validatorMappings = EntityUtil.newMap();
        }
        this.validatorMappings.put(context, validators);
    }

    @Override
    public String getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }
}

