/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities;

import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeType;
import com.sas.entities.AttributeTypeFactory;
import com.sas.entities.AttributeTypeInterface;
import com.sas.entities.AttributeTypeUtility;
import com.sas.entities.BaseAttributeDescriptor;
import com.sas.entities.EntityRB;
import com.sas.entities.EntityUtil;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@SASScope(value="ALL")
public class AttributeDescriptor
extends BaseAttributeDescriptor
implements Serializable,
AttributeDescriptorInterface {
    private Object value;
    private Object defaultValue;
    private boolean visible;
    private boolean modifiable;
    private boolean expert;
    private boolean required;
    private boolean property;
    private boolean defaultValueHasBeenSet;
    private AttributeTypeInterface attributeType;
    private String editor;
    private Map editorMappings;
    private Map validatorMappings;
    protected Map supplementalProperties;
    private Map defaultSupplementalProperties;
    public static final String RB_KEY = "AttributeDescriptor.";

    public AttributeDescriptor() {
        this(null);
    }

    public AttributeDescriptor(String name) {
        this.setName(name);
        this.modifiable = true;
        this.visible = true;
    }

    public AttributeDescriptor(String name, Map supplementalProperties) {
        this.setName(name);
        this.modifiable = true;
        this.visible = true;
        if (supplementalProperties != null && supplementalProperties.containsKey(null)) {
            throw new IllegalArgumentException(EntityRB.getStringResource(RB_KEY, "nullSupplementalPropertyName.ex.txt"));
        }
        this.defaultSupplementalProperties = supplementalProperties;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isProperty() {
        return this.property;
    }

    @Override
    public void setProperty(boolean property) {
        this.property = property;
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable;
    }

    @Override
    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    @Override
    public boolean isExpert() {
        return this.expert;
    }

    @Override
    public void setExpert(boolean expert) {
        this.expert = expert;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public AttributeTypeInterface getType() {
        if (this.attributeType == AttributeTypeFactory.NULL_ATTRIBUTE_TYPE) {
            return new AttributeType(null, 0, null);
        }
        return this.attributeType;
    }

    @Override
    public void setType(AttributeTypeInterface attributeType) {
        AttributeTypeInterface at = this.getType();
        if (at == null) {
            this.attributeType = attributeType;
        } else if (this.isDefaultValueHasBeenSet()) {
            if (!at.equals(attributeType)) {
                this.attributeType = attributeType;
                at = this.getType();
                String defaultValue = this.getStringDefault();
                if (AttributeTypeUtility.validateDefaultValue(defaultValue, at, true, this.getName())) {
                    this.defaultValue = AttributeTypeUtility.transformAttributeValue(defaultValue, this);
                }
            } else {
                this.attributeType = attributeType;
            }
        } else {
            this.attributeType = attributeType;
        }
    }

    @Override
    public String getStringDefault() {
        if (this.defaultValue == null) {
            return null;
        }
        return AttributeTypeUtility.transformValueToSASFormat(this.defaultValue, this.getType());
    }

    @Override
    public Object getDefault() {
        AttributeTypeInterface ati = this.getType();
        if (this.isDefaultValueHasBeenSet()) {
            if (ati == null) {
                return this.defaultValue;
            }
            String atiName = ati.getName();
            if (AttributeTypeUtility.isColorStringClass(ati)) {
                return AttributeTypeUtility.convertValueToColor(this.defaultValue);
            }
            return AttributeTypeUtility.transformAttributeValue(this.defaultValue, this);
        }
        if (ati == null) {
            return null;
        }
        int sqlType = this.getType().getSQLType();
        if (!AttributeTypeUtility.isNullValidForAttributeType(sqlType)) {
            return AttributeTypeUtility.createDefaultValue(sqlType);
        }
        return null;
    }

    @Override
    public void setDefault(Object defaultValue) {
        AttributeTypeInterface at = this.getType();
        if (AttributeTypeUtility.validateDefaultValue(defaultValue, at, true, this.getName())) {
            this.defaultValue = defaultValue;
            this.setDefaultValueHasBeenSet(true);
        }
    }

    @Override
    public String getEditor(String context) {
        if (this.editorMappings != null) {
            if (this.editorMappings.containsKey(context)) {
                return (String)this.editorMappings.get(context);
            }
            return null;
        }
        return null;
    }

    @Override
    public void setEditor(String context, String editor) {
        this.getAttributeEditors().put(context, editor);
    }

    @Override
    public Map getAttributeEditors() {
        if (this.editorMappings == null) {
            this.editorMappings = EntityUtil.newMap();
        }
        return this.editorMappings;
    }

    @Override
    public List getAttributeEditorContexts() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.editorMappings != null) {
            Iterator iter = this.editorMappings.keySet().iterator();
            String context = null;
            while (iter.hasNext()) {
                context = (String)iter.next();
                list.add(context);
            }
            return list;
        }
        return list;
    }

    @Override
    public List getValidators(String context) {
        ArrayList list = new ArrayList();
        if (this.validatorMappings != null && this.validatorMappings.containsKey(context)) {
            return (List)this.validatorMappings.get(context);
        }
        return list;
    }

    @Override
    public List getValidatorsContexts() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.validatorMappings != null) {
            Iterator iter = this.validatorMappings.keySet().iterator();
            String context = null;
            while (iter.hasNext()) {
                context = (String)iter.next();
                list.add(context);
            }
            return list;
        }
        return list;
    }

    @Override
    public void setValidators(String context, List validators) {
        if (this.validatorMappings == null) {
            this.validatorMappings = EntityUtil.newMap();
        }
        this.validatorMappings.put(context, validators);
    }

    @Override
    public boolean isDefaultValueHasBeenSet() {
        return this.defaultValueHasBeenSet;
    }

    @Override
    public void setDefaultValueHasBeenSet(boolean defaultValueHasBeenSet) {
        this.defaultValueHasBeenSet = defaultValueHasBeenSet;
    }

    @Override
    public Object getSupplementalProperty(String propertyName) {
        if (this.supplementalProperties != null && this.supplementalProperties.containsKey(propertyName)) {
            return this.supplementalProperties.get(propertyName);
        }
        if (this.defaultSupplementalProperties != null && this.defaultSupplementalProperties.containsKey(propertyName)) {
            return this.defaultSupplementalProperties.get(propertyName);
        }
        throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource(RB_KEY, "nonExistentSupplementalPropertyName.ex.txt"), propertyName));
    }

    @Override
    public void setSupplementalProperty(String propertyName, Object value) {
        this.getSupplementalProperties().put(propertyName, value);
    }

    @Override
    public Map getSupplementalProperties() {
        if (this.supplementalProperties == null) {
            this.supplementalProperties = EntityUtil.newMap();
            if (this.defaultSupplementalProperties != null) {
                this.supplementalProperties.putAll(this.defaultSupplementalProperties);
            }
        }
        return this.supplementalProperties;
    }

    @Override
    public void setSupplementalProperties(Map additionalProperties) {
        if (additionalProperties == null || additionalProperties.containsKey(null)) {
            throw new IllegalArgumentException(EntityRB.getStringResource(RB_KEY, "nullSupplementalPropertyName.ex.txt"));
        }
        this.getSupplementalProperties().putAll(additionalProperties);
    }

    @SASScope
    protected boolean isStandardProperty(String propertyName) {
        if (propertyName.equals("required")) {
            return true;
        }
        if (propertyName.equals("expert")) {
            return true;
        }
        if (propertyName.equals("modifiable")) {
            return true;
        }
        if (propertyName.equals("visible")) {
            return true;
        }
        if (propertyName.equals("default")) {
            return true;
        }
        if (propertyName.equals("defaultValueHasBeenSet")) {
            return true;
        }
        if (propertyName.equals("type")) {
            return true;
        }
        if (propertyName.equals("editor")) {
            return true;
        }
        if (propertyName.equals("customizer")) {
            return true;
        }
        if (propertyName.equals("attributeCustomizers")) {
            return true;
        }
        if (propertyName.equals("supplementalProperty")) {
            return true;
        }
        if (propertyName.equals("supplementalProperties")) {
            return true;
        }
        if (propertyName.equals("name")) {
            return true;
        }
        if (propertyName.equals("label") || propertyName.equals("labels")) {
            return true;
        }
        if (propertyName.equals("description") || propertyName.equals("descriptions")) {
            return true;
        }
        if (propertyName.equals("property")) {
            return true;
        }
        if (propertyName.equals("configurationXML")) {
            return true;
        }
        if (propertyName.equals("smallIconURL") || propertyName.equals("smallIconURLs")) {
            return true;
        }
        return propertyName.equals("largeIconURL") || propertyName.equals("largeIconURLs");
    }
}

