/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities;

import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeGroup;
import com.sas.entities.AttributeGroupInterface;
import com.sas.entities.AttributeSetException;
import com.sas.entities.AttributeTypeInterface;
import com.sas.entities.EntityAttr;
import com.sas.entities.EntityInterface;
import com.sas.entities.EntityKeyInterface;
import com.sas.entities.RemoteEntityInterface;
import java.beans.VetoableChangeListener;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

@SASScope(value="ALL")
public class AggregateEntity {
    @SASScope
    public static final String RB_KEY = "AggregateEntity.";
    private String m_aggregateName = "";
    private Map m_allEntities = new HashMap();
    private Map m_allEntityKeys = new HashMap();
    private Map m_allEntityNames = new HashMap();
    private ArrayList m_exposedAttrNames = new ArrayList();
    private Map m_exposedAttrMappings = new HashMap();
    private transient EntityInterface m_exposedEntityInterface;
    private transient EntityAttrMappingTreeModel m_mappingTreeModel = new EntityAttrMappingTreeModel();
    private static final transient String RootPropertyChange = "root";

    public AggregateEntity() {
        this.m_exposedEntityInterface = new EntityAttrCombinedEntityInterface();
    }

    public AggregateEntity(String name) {
        this();
        this.setName(name);
    }

    public Map getEntities() {
        return this.m_allEntities;
    }

    public void setName(String name) {
        this.m_aggregateName = name;
        this.refreshModelListeners();
    }

    public String getName() {
        return this.m_aggregateName;
    }

    public String toString() {
        return this.m_aggregateName;
    }

    public void addEntityKey(String entityKey, String entityName) {
        this.m_allEntityKeys.put(entityKey, null);
        this.m_allEntityNames.put(entityKey, entityName);
    }

    public void addEntity(EntityInterface entity, String entityName) {
        if (!this.m_allEntities.containsKey(entity)) {
            this.m_allEntities.put(entity, entityName);
            try {
                AttributeDescriptorInterface[] attributeDescriptorInterfaceArray = entity.getAttributeDescriptors();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String[] entityAttrKeys = null;
            try {
                entityAttrKeys = entity.listAttributeNames();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            try {
                AttributeDescriptorInterface[] adi = entity.getAttributeGroup().getAttributeDescriptors(true);
                int adiLength = adi.length;
                if (adiLength > 0) {
                    for (int i = 0; i < adiLength; ++i) {
                        String key = adi[i].getName();
                        EntityAttr newItem = new EntityAttr(entity, key);
                        newItem.setEntityName(entityName);
                        this.addToKeyList(key, newItem, -1);
                    }
                }
                this.refreshModelListeners();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
        }
    }

    public void removeEntity(EntityInterface entity) {
        if (this.m_allEntities.containsKey(entity)) {
            this.m_allEntities.remove(entity);
            String[] entityAttrKeys = null;
            try {
                entityAttrKeys = entity.listAttributeNames();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (entityAttrKeys != null) {
                for (int i = 0; i < entityAttrKeys.length; ++i) {
                    String attrName = entityAttrKeys[i];
                    EntityAttr oldItem = new EntityAttr(entity, attrName);
                    Set keys = this.m_exposedAttrMappings.keySet();
                    Iterator keyIter = keys.iterator();
                    while (keyIter.hasNext()) {
                        String key = (String)keyIter.next();
                        ArrayList mappedToAttrs = this.getKeyList(key);
                        if (!mappedToAttrs.contains(oldItem)) continue;
                        mappedToAttrs.remove(oldItem);
                        if (!mappedToAttrs.isEmpty()) continue;
                        keyIter.remove();
                        this.m_exposedAttrNames.remove(key);
                    }
                }
            }
            this.refreshModelListeners();
        }
    }

    public void addToKeyList(String key, EntityAttr item, int index) {
        this._addToKeyList(key, item, index);
        this.refreshModelListeners();
    }

    private void _addToKeyList(String key, EntityAttr item, int index) {
        if (this.m_exposedAttrNames.contains(key)) {
            ArrayList mappedToAttrs = this.getKeyList(key);
            if (index == -1 || index > mappedToAttrs.size()) {
                mappedToAttrs.add(item);
            } else {
                mappedToAttrs.add(index, item);
            }
        } else {
            this.m_exposedAttrNames.add(key);
            ArrayList<EntityAttr> mappedToAttrs = new ArrayList<EntityAttr>();
            mappedToAttrs.add(item);
            this.m_exposedAttrMappings.put(key, mappedToAttrs);
        }
    }

    public void removeFromKeyList(String key, EntityAttr item) {
        this._removeFromKeyList(key, item);
        this.refreshModelListeners();
    }

    private void _removeFromKeyList(String key, EntityAttr item) {
        ArrayList mappedToAttrs = this.getKeyList(key);
        if (mappedToAttrs.contains(item)) {
            mappedToAttrs.remove(item);
            if (mappedToAttrs.isEmpty()) {
                this.m_exposedAttrMappings.remove(key);
                this.m_exposedAttrNames.remove(key);
            }
        }
    }

    public void moveBetweenKeyLists(String keyFrom, String keyTo, EntityAttr item, int index) {
        this._removeFromKeyList(keyFrom, item);
        this._addToKeyList(keyTo, item, index);
        this.refreshModelListeners();
    }

    public ArrayList getKeyList(String key) {
        return (ArrayList)this.m_exposedAttrMappings.get(key);
    }

    private EntityAttr getDefaultEntityAttr(String key) {
        ArrayList mappedToAttrs = this.getKeyList(key);
        if (mappedToAttrs == null || mappedToAttrs.isEmpty()) {
            return null;
        }
        return (EntityAttr)mappedToAttrs.get(0);
    }

    private int indexinKeyList(String key, EntityAttr item) {
        ArrayList mappedToAttrs = this.getKeyList(key);
        if (mappedToAttrs.contains(item)) {
            return mappedToAttrs.indexOf(item);
        }
        return -1;
    }

    public TreeModel getMappingTreeModel() {
        return this.m_mappingTreeModel;
    }

    public EntityInterface getEntityInterface() {
        return this.m_exposedEntityInterface;
    }

    public void refreshModelListeners() {
        this.m_mappingTreeModel.fireTreeStructureChange(RootPropertyChange, null, null);
    }

    public boolean relink(EntityInterface entity) {
        boolean success = false;
        if (entity != null) {
            try {
                String key = null;
                String[] attrs = entity.listAttributeNames();
                for (int i = 0; i < attrs.length; ++i) {
                    String tempKey = attrs[i];
                    if (!tempKey.equals("entityKey")) continue;
                    key = (String)entity.getAttribute(tempKey);
                    break;
                }
                Collection attrList = this.m_exposedAttrMappings.values();
                for (ArrayList mappedToAttrs : attrList) {
                    if (mappedToAttrs == null) continue;
                    for (EntityAttr item : mappedToAttrs) {
                        if (item == null) continue;
                        EntityInterface entityStored = item.getEntity();
                        String entityKeyStored = item.getEntityKey();
                        if (entityStored != null || !entityKeyStored.equals(key)) continue;
                        item.setEntity(entity);
                        if (!this.m_allEntityNames.containsKey(key)) continue;
                        String entityName = (String)this.m_allEntityNames.get(key);
                        item.setEntityName(entityName);
                        this.m_allEntities.put(entity, entityName);
                        this.m_allEntityKeys.put(key, entity);
                        success = true;
                    }
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return success;
    }

    public boolean validateRelink() {
        Collection entities = this.m_allEntityKeys.values();
        return entities != null && !entities.contains(null);
    }

    public String[] getMissingEntities() {
        Collection entities = this.m_allEntityKeys.values();
        ArrayList<String> missingAL = new ArrayList<String>();
        if (entities.contains(null)) {
            Set keySet = this.m_allEntityKeys.keySet();
            for (String key : keySet) {
                if (this.m_allEntityKeys.get(key) != null) continue;
                missingAL.add(key);
            }
        }
        String[] stringArray = new String[]{};
        String[] missingEntities = missingAL.toArray(stringArray);
        return missingEntities;
    }

    @SASScope
    class EntityAttrMappingTreeModel
    implements TreeModel {
        protected transient Vector m_modelListenerList = null;

        EntityAttrMappingTreeModel() {
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent == this) {
                return AggregateEntity.this.m_exposedAttrNames.get(index);
            }
            if (parent instanceof exposedLeaf) {
                String key = ((exposedLeaf)parent).m_keyName;
                return AggregateEntity.this.getKeyList(key).get(index);
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent == this) {
                return AggregateEntity.this.m_exposedAttrNames.size();
            }
            if (parent instanceof exposedLeaf) {
                String key = ((exposedLeaf)parent).m_keyName;
                return AggregateEntity.this.getKeyList(key).size();
            }
            return 0;
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent == this) {
                String key = ((exposedLeaf)child).m_keyName;
                return AggregateEntity.this.m_exposedAttrNames.indexOf(key);
            }
            if (parent instanceof exposedLeaf) {
                EntityAttr item = (EntityAttr)child;
                String key = ((exposedLeaf)parent).m_keyName;
                return AggregateEntity.this.indexinKeyList(key, item);
            }
            return -1;
        }

        @Override
        public Object getRoot() {
            if (AggregateEntity.this.m_exposedAttrNames.isEmpty()) {
                return null;
            }
            return this;
        }

        @Override
        public boolean isLeaf(Object node) {
            if (node == this) {
                return true;
            }
            if (node instanceof EntityAttr) {
                return false;
            }
            if (node instanceof exposedLeaf) {
                return true;
            }
            return true;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public void addTreeModelListener(TreeModelListener listener) {
            if (this.m_modelListenerList == null) {
                this.m_modelListenerList = new Vector();
            }
            int listenerSize = this.m_modelListenerList.size();
            for (int index = 0; index < listenerSize; ++index) {
                if (this.m_modelListenerList.elementAt(index) != listener) continue;
                return;
            }
            this.m_modelListenerList.addElement(listener);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener listener) {
            if (this.m_modelListenerList == null) {
                return;
            }
            this.m_modelListenerList.removeElement(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireTreeStructureChange(String propertyName, Object oldValue, Object newValue) {
            Vector targets;
            if (oldValue != null && oldValue.equals(newValue)) {
                return;
            }
            EntityAttrMappingTreeModel entityAttrMappingTreeModel = this;
            synchronized (entityAttrMappingTreeModel) {
                if (this.m_modelListenerList == null) {
                    return;
                }
                targets = (Vector)this.m_modelListenerList.clone();
            }
            TreeModelEvent event = new TreeModelEvent((Object)this, new TreePath(this));
            int vectorSize = targets.size();
            for (int index = 0; index < vectorSize; ++index) {
                TreeModelListener target = (TreeModelListener)targets.elementAt(index);
                target.treeStructureChanged(event);
            }
        }

        @SASScope
        class exposedLeaf {
            public String m_keyName;

            exposedLeaf(String name) {
                this.m_keyName = name;
            }
        }
    }

    @SASScope
    class EntityAttrCombinedEntityInterface
    implements EntityInterface {
        EntityAttrCombinedEntityInterface() {
        }

        @Override
        public AttributeDescriptorInterface[] getAttributeDescriptors() throws RemoteException {
            Iterator propNames = AggregateEntity.this.m_exposedAttrNames.iterator();
            ArrayList<AttributeDescriptorInterface> attributeDescriptors = new ArrayList<AttributeDescriptorInterface>();
            AttributeDescriptorInterface ad = null;
            while (propNames.hasNext()) {
                String key = (String)propNames.next();
                try {
                    ad = this.getAttributeDescriptor(key);
                    attributeDescriptors.add(ad);
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
            return attributeDescriptors.toArray(new AttributeDescriptorInterface[attributeDescriptors.size()]);
        }

        @Override
        public AttributeDescriptorInterface getAttributeDescriptor(String attributeName) throws RemoteException {
            EntityAttr item = AggregateEntity.this.getDefaultEntityAttr(attributeName);
            if (item == null) {
                return null;
            }
            EntityInterface entity = item.getEntity();
            String attrName = item.getAttrName();
            return entity.getAttributeDescriptor(attrName);
        }

        @Override
        public boolean isAttributeAssigned(String attributeName) throws RemoteException {
            List attrList = (List)AggregateEntity.this.m_exposedAttrMappings.get(attributeName);
            int size = attrList.size();
            boolean flag = false;
            for (int i = 0; i < size; ++i) {
                EntityAttr entityAttr = (EntityAttr)attrList.get(i);
                EntityInterface entity = entityAttr.getEntity();
                if (i == 0) {
                    flag = entity.isAttributeAssigned(attributeName);
                } else {
                    boolean bl = flag = flag && entity.isAttributeAssigned(attributeName);
                }
                if (!flag) break;
            }
            return flag;
        }

        @Override
        public boolean isAllRequiredAttributesAssigned() throws RemoteException {
            boolean flag = false;
            Map entitiesMap = AggregateEntity.this.getEntities();
            Iterator keyIter = entitiesMap.keySet().iterator();
            int i = 0;
            while (keyIter.hasNext()) {
                EntityInterface entity = (EntityInterface)keyIter.next();
                if (i == 0) {
                    flag = entity.isAllRequiredAttributesAssigned();
                } else {
                    boolean bl = flag = flag && entity.isAllRequiredAttributesAssigned();
                }
                if (!flag) break;
                ++i;
            }
            return flag;
        }

        @Override
        public void clear() throws RemoteException {
            Map entitiesMap = AggregateEntity.this.getEntities();
            for (EntityInterface entity : entitiesMap.keySet()) {
                entity.clear();
            }
        }

        @Override
        public void clearAttribute(String attributeName) throws RemoteException {
            List attrList = (List)AggregateEntity.this.m_exposedAttrMappings.get(attributeName);
            int size = attrList.size();
            for (int i = 0; i < size; ++i) {
                EntityAttr entityAttr = (EntityAttr)attrList.get(i);
                EntityInterface entity = entityAttr.getEntity();
                entity.clearAttribute(attributeName);
            }
        }

        @Override
        public String getEntityKey() {
            return null;
        }

        @Override
        public void setEntityKey(String key) {
        }

        @Override
        public boolean sameEntity(EntityKeyInterface entity) {
            return true;
        }

        @Override
        public void setAttribute(String valueName, Object value) throws RemoteException, AttributeSetException {
            this._setValue(valueName, value);
            AggregateEntity.this.refreshModelListeners();
        }

        private void _setValue(String valueName, Object value) throws RemoteException, AttributeSetException {
            if (!this.containsAttributeNamed(valueName)) {
                throw new UnsupportedOperationException(MessageFormat.format("AggregateEntity.notSupported.txt", "setValue()"));
            }
            ArrayList mappedToAttrs = AggregateEntity.this.getKeyList(valueName);
            for (EntityAttr item : mappedToAttrs) {
                if (item == null) continue;
                EntityInterface entity = item.getEntity();
                String attrName = item.getAttrName();
                entity.setAttribute(attrName, value);
            }
        }

        @Override
        public void setAttributes(Map update) throws RemoteException, AttributeSetException {
            Set keys = update.keySet();
            for (String key : keys) {
                this._setValue(key, update.get(key));
            }
            AggregateEntity.this.refreshModelListeners();
        }

        @Override
        public Map getAttributes(Map query) throws RemoteException {
            Set keys = query.keySet();
            for (String key : keys) {
                Object value = this.getAttribute(key);
                query.put(key, value);
            }
            return query;
        }

        @Override
        public AttributeDescriptorInterface[] getBooleanSpecifiedAttributeDescriptors(Map map) {
            return new AttributeDescriptorInterface[0];
        }

        @Override
        public boolean containsAttributeNamed(String name) throws RemoteException {
            return AggregateEntity.this.m_exposedAttrNames.contains(name);
        }

        @Override
        public Object getAttribute(String valueName) throws RemoteException, NoSuchElementException {
            EntityAttr item = AggregateEntity.this.getDefaultEntityAttr(valueName);
            if (item == null) {
                return null;
            }
            EntityInterface entity = item.getEntity();
            String attrName = item.getAttrName();
            return entity.getAttribute(attrName);
        }

        @Override
        public String getStringAttribute(String valueName, String defaultValue) throws RemoteException {
            String value = (String)this.getAttribute(valueName);
            if (value == null) {
                value = defaultValue;
            }
            return value;
        }

        @Override
        public Object getAttribute(String valueName, Object defaultValue) throws RemoteException {
            Object value = this.getAttribute(valueName);
            if (value == null) {
                value = defaultValue;
            }
            return value;
        }

        @Override
        public String[] listAttributeNames() throws RemoteException {
            Iterator propNames = AggregateEntity.this.m_exposedAttrNames.iterator();
            String[] attributeNames = new String[AggregateEntity.this.m_exposedAttrNames.size()];
            int i = 0;
            while (propNames.hasNext()) {
                attributeNames[i++] = (String)propNames.next();
            }
            return attributeNames;
        }

        @Override
        public AttributeGroupInterface getAttributeGroup() throws RemoteException {
            AttributeGroup agi = new AttributeGroup();
            AttributeDescriptorInterface[] adi = this.getAttributeDescriptors();
            if (adi.length > 0) {
                agi.addAttributeDescriptors(adi);
                return agi;
            }
            return new AttributeGroup(this);
        }

        @Override
        public AttributeTypeInterface getAttributeType(String name) throws RemoteException {
            EntityAttr item = AggregateEntity.this.getDefaultEntityAttr(name);
            if (item == null) {
                return null;
            }
            EntityInterface entity = item.getEntity();
            String attrName = item.getAttrName();
            return entity.getAttributeType(attrName);
        }

        public List getAttributes() throws RemoteException {
            ArrayList attrs = new ArrayList(AggregateEntity.this.m_exposedAttrNames);
            return attrs;
        }

        @Override
        public Map getAttributeValidators() throws RemoteException {
            HashMap<EntityInterface, Map> allValidators = new HashMap<EntityInterface, Map>();
            Set entities = AggregateEntity.this.m_allEntities.keySet();
            for (EntityInterface entity : entities) {
                Map entityValidators = entity.getAttributeValidators();
                allValidators.put(entity, entityValidators);
            }
            HashMap exposedValidators = new HashMap();
            for (String key : AggregateEntity.this.m_exposedAttrNames) {
                ArrayList exposedlistenerList = new ArrayList();
                exposedValidators.put(key, exposedlistenerList);
                ArrayList mappedToAttrs = AggregateEntity.this.getKeyList(key);
                for (EntityAttr item : mappedToAttrs) {
                    List entityAttrListeners;
                    if (item == null) continue;
                    EntityInterface entity = item.getEntity();
                    String attrName = item.getAttrName();
                    Map entityValidators = (Map)allValidators.get(entity);
                    if (entityValidators == null || (entityAttrListeners = (List)entityValidators.get(attrName)) == null) continue;
                    exposedlistenerList.addAll(entityAttrListeners);
                }
            }
            return exposedValidators;
        }

        @Override
        public void removeAttribute(String valueName) throws RemoteException {
            throw new UnsupportedOperationException(MessageFormat.format("AggregateEntity.notSupported.txt", "removeAttribute"));
        }

        @Override
        public void removeAllAttributes() throws RemoteException {
            throw new UnsupportedOperationException(MessageFormat.format("AggregateEntity.notSupported.txt", "removeAllAttributes"));
        }

        @Override
        public void addAttributeValidator(String valueName, VetoableChangeListener listener) throws RemoteException {
            throw new UnsupportedOperationException(MessageFormat.format("AggregateEntity.notSupported.txt", "addAttributeValidator"));
        }

        @Override
        public void removeAttributeValidator(String valueName, VetoableChangeListener listener) throws RemoteException {
            throw new UnsupportedOperationException(MessageFormat.format("AggregateEntity.notSupported.txt", "removeAttributeValidator()"));
        }

        @Override
        public RemoteEntityInterface getPrototype() throws RemoteException {
            throw new UnsupportedOperationException(MessageFormat.format("AggregateEntity.notSupported.txt", "getPrototype()"));
        }

        @Override
        public void setPrototype(RemoteEntityInterface prototype) throws RemoteException {
            throw new UnsupportedOperationException(MessageFormat.format("AggregateEntity.notSupported.txt", "setPrototype()"));
        }

        @Override
        public String getCustomizer(String context) throws RemoteException {
            throw new UnsupportedOperationException(MessageFormat.format("AggregateEntity.notSupported.txt", "getCustomizer()"));
        }

        @Override
        public void setCustomizer(String context, String customizer) throws RemoteException {
            throw new UnsupportedOperationException(MessageFormat.format("AggregateEntity.notSupported.txt", "setCustomizer()"));
        }

        @Override
        public List getCustomizerContexts() {
            return null;
        }
    }
}

