/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.core.password.crypto;

import com.sas.solstice.platform.core.password.crypto.CipherInterface;
import com.sas.solstice.platform.core.password.crypto.CryptoException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;

public abstract class Crypto {
    private static final String defaultProviders = "com.sas.net.crypto.sas.SasCrypto,com.sas.net.crypto.rsa.RsaCrypto";
    private String name = null;

    public abstract CipherInterface openCipher() throws CryptoException;

    public abstract String getSupportedNames();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.toUpperCase();
    }

    public static Crypto getCrypto(String algorithm, Properties properties) {
        if (algorithm == null) {
            return null;
        }
        String providerList = properties.getProperty("encryptionProviders", defaultProviders);
        String providerName = null;
        int index = 0;
        Class[] argt = new Class[1];
        Object[] argv = new Object[1];
        do {
            if ((providerName = Crypto.getNameFromList(providerList, ',', index)) != null) {
                try {
                    Class<?> providerClass = Class.forName(providerName);
                    argt[0] = Properties.class;
                    Constructor<?> providerConstructor = providerClass.getConstructor(argt);
                    argv[0] = properties;
                    Crypto provider = (Crypto)providerConstructor.newInstance(argv);
                    String supportedNames = provider.getSupportedNames();
                    String supportedName = null;
                    int j = 0;
                    do {
                        if ((supportedName = Crypto.getNameFromList(supportedNames, ',', j)) != null && algorithm.equalsIgnoreCase(supportedName)) {
                            provider.setName(supportedName);
                            return provider;
                        }
                        ++j;
                    } while (supportedName != null);
                }
                catch (ClassNotFoundException e) {
                    if (!providerName.equals("com.sas.net.crypto.rsa.RsaCrypto")) {
                        e.printStackTrace();
                    }
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            ++index;
        } while (providerName != null);
        return null;
    }

    private static String getNameFromList(String list, char delim, int index) {
        char c;
        if (list == null) {
            return null;
        }
        int offset = 0;
        int end = 0;
        int listLength = list.length();
        block0: for (int i = 0; i < index; ++i) {
            while (offset < listLength) {
                char c2 = list.charAt(offset);
                if (c2 == delim) {
                    ++offset;
                    continue block0;
                }
                ++offset;
            }
        }
        if (offset >= listLength) {
            return null;
        }
        for (end = offset; end < listLength && (c = list.charAt(end)) != delim; ++end) {
        }
        if (end - offset == 0) {
            return null;
        }
        return list.substring(offset, end);
    }
}

