/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.core.context;

import com.sas.solstice.platform.core.model.ArtifactType;
import com.sas.solstice.platform.core.model.BaseParameterType;
import com.sas.solstice.platform.core.model.BooleanParameterType;
import com.sas.solstice.platform.core.model.ContentType;
import com.sas.solstice.platform.core.model.ContentsType;
import com.sas.solstice.platform.core.model.DeploymentDescriptorType;
import com.sas.solstice.platform.core.model.ElementValueType;
import com.sas.solstice.platform.core.model.FeatureType;
import com.sas.solstice.platform.core.model.IntegerParameterType;
import com.sas.solstice.platform.core.model.LanguageSelectionsType;
import com.sas.solstice.platform.core.model.LanguageSetType;
import com.sas.solstice.platform.core.model.LanguageType;
import com.sas.solstice.platform.core.model.LanguagesType;
import com.sas.solstice.platform.core.model.NestedFeatureType;
import com.sas.solstice.platform.core.model.OptionalLanguagesType;
import com.sas.solstice.platform.core.model.PackageDescriptorType;
import com.sas.solstice.platform.core.model.PackageIdentityType;
import com.sas.solstice.platform.core.model.ResourceType;
import com.sas.solstice.platform.core.model.ResultingPropertyType;
import com.sas.solstice.platform.core.model.ResultingResourceType;
import com.sas.solstice.platform.core.model.SDDContentPurposeType;
import com.sas.solstice.platform.core.model.StringParameterType;
import com.sas.solstice.platform.core.model.URIParameterType;
import com.sas.solstice.platform.core.model.Variable;
import com.sas.solstice.platform.core.model.VariablesTypeExt;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SDDContext {
    static final String PURPOSE_DESCRIPTION_LANGUAGE_BUNDLE = "descriptorLanguageBundle";
    private static final String DEFAULT_COUNTRY = "US";
    private static final String DEFAULT_LANGUAGE = "en";
    private static final Pattern PATTERN = Pattern.compile("\\$\\(.+?\\)");
    private static final Pattern WINDOWS_PATTERN = Pattern.compile("\\%[a-zA-Z_]+[0-9a-zA-Z_]*%");
    private static final Pattern UNIX_PATTERN = Pattern.compile("\\$\\{[a-zA-Z_]+[0-9a-zA-Z_]*\\}");
    private static Logger logger = LogManager.getLogger(SDDContext.class);
    private static final String MSG_ARTIFACT = "artifact";
    private static final String MSG_CONTENT = "content";
    private static final String MSG_DEPENDENCY = "dependency";
    private static final String MSG_DEPLOYMENT_DESCRIPTOR = "deploymentDescriptor";
    private static final String MSG_FEATURE_ID = "featureId";
    private static final String MSG_FEATURE_IDS = "featureIds";
    private static final String MSG_FILENAME = "filename";
    private static final String MSG_FOREIGN_ID = "foreignId";
    private static final String MSG_ID = "id";
    private static final String MSG_IDENTITY = "identity";
    private static final String MSG_KEY = "key";
    private static final String MSG_LANGUAGE = "language";
    private static final String MSG_PACKAGE_URI = "packageUri";
    private static final String MSG_PARAMETER_ID = "parameterId";
    private static final String MSG_PATH = "path";
    private static final String MSG_PURPOSE = "purpose";
    private static final String MSG_REFERENCE_ID = "referenceId";
    private static final String MSG_RESOURCE = "resource";
    private static final String MSG_RESULTING_RESOURCE = "resultingResource";
    private static final String MSG_TYPE = "type";
    private static final String MSG_UNIT_ID = "unitId";
    private static final String MSG_URL = "url";
    private static final String PROGRAM_FILES = "programfiles";
    private static final String PROGRAM_FILES_64BIT_ENV_VARIABLE = "ProgramW6432";
    private static final String PROGRAM_FILES_32BIT_ENV_VARIABLE = "ProgramFiles(x86)";
    private Unmarshaller _unmarshaller;
    private PackageDescriptorType _packageDescriptor;
    private DeploymentDescriptorType _deploymentDescriptor;
    private String _p2Location;
    private String _rootLocation;
    private URI _packageUri;
    private VariablesTypeExt _variables;
    private Map<String, Object> _parameters;
    private Map<String, Object> _requestParameters;
    private Map<String, String> _responseParameters;
    private Deque<DeploymentDescriptorType> _descriptors;
    private Map<String, ContentType> _packageContent;
    private Map<String, ArtifactType> _artifacts;
    private List<ArtifactType> _configurationArtifacts;
    private Map<String, ResultingResourceType> _resultingResources;
    private Map<String, Object> _resourceModel;
    private Map<String, String> _requiredResourceMap;
    private Map<String, String> _selectedFeatureMap;
    private Map<String, PackageIdentityType> _identityMap;
    private Map<String, String> _exReqs;
    private Map<String, String> _coReqs;
    private Map<String, List<ArtifactType>> _featuresCollection;
    private Map<String, List<ArtifactType>> _featuresConfiguration;
    private FeatureType _currentFeature;
    private NestedFeatureType _currentNestedFeature;
    private boolean _ok = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigurationUnitArtifact(ArtifactType artifact) {
        Map<String, List<ArtifactType>> featuresConfiguration;
        List<ArtifactType> configurationArtifacts;
        this.check(artifact, MSG_ARTIFACT);
        List<ArtifactType> list = configurationArtifacts = this.getConfigurationUnitArtifacts();
        synchronized (list) {
            configurationArtifacts.add(artifact);
        }
        logger.info("addConfigurationUnitArtifact() - storing artifact reference for " + artifact.getType());
        FeatureType currentFeature = this.getCurrentFeature();
        if (currentFeature == null) {
            return;
        }
        String id = currentFeature.getId();
        Map<String, List<ArtifactType>> map = featuresConfiguration = this.getFeaturesConfiguration();
        synchronized (map) {
            List<ArtifactType> value = featuresConfiguration.get(id);
            if (value == null) {
                featuresConfiguration.put(id, configurationArtifacts);
                return;
            }
            value.add(artifact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCoRequisite(String id, String dependency) {
        Map<String, String> map;
        this.check(id, MSG_ID);
        this.check(dependency, MSG_DEPENDENCY);
        Map<String, String> map2 = map = this.getCoRequisites();
        synchronized (map2) {
            map.put(id, dependency);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExRequisite(String id, String dependency) {
        Map<String, String> exReqs;
        this.check(id, MSG_ID);
        this.check(dependency, MSG_DEPENDENCY);
        Map<String, String> map = exReqs = this.getExRequisites();
        synchronized (map) {
            exReqs.put(id, dependency);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstallableUnitArtifact(ArtifactType artifact) {
        Map<String, ArtifactType> installableUnitArtifacts;
        this.check(artifact, MSG_ARTIFACT);
        String key = artifact.getContentRef();
        Map<String, ArtifactType> map = installableUnitArtifacts = this.getInstallableUnitArtifacts();
        synchronized (map) {
            boolean exists = installableUnitArtifacts.containsKey(key);
            if (!exists) {
                installableUnitArtifacts.put(key, artifact);
                logger.info("addInstallableUnitArtifact() - storing artifact reference for contentRef:" + key);
            }
        }
        Map<String, List<ArtifactType>> featuresCollection = this.getFeaturesCollection();
        FeatureType currentFeature = this.getCurrentFeature();
        String id = currentFeature.getId();
        Map<String, List<ArtifactType>> map2 = featuresCollection;
        synchronized (map2) {
            List<ArtifactType> list = featuresCollection.get(id);
            if (list == null) {
                logger.info("addInstallableUnitArtifact() - creating new features collection for :" + id);
                list = new ArrayList<ArtifactType>(10);
                logger.info("addInstallableUnitArtifact() - adding the list of artifacts for :" + id);
                featuresCollection.put(id, list);
            }
            list.add(artifact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPackageIdentity(PackageIdentityType identity) {
        Map<String, PackageIdentityType> identityMap;
        this.check(identity, MSG_IDENTITY);
        String key = identity.getSoftwareID();
        Map<String, PackageIdentityType> map = identityMap = this.getPackageIdentity();
        synchronized (map) {
            identityMap.put(key, identity);
        }
    }

    public void addRequestParameter(BooleanParameterType type) {
        this.check(type, MSG_TYPE);
        ElementValueType defaultValueType = type.getDefaultValue();
        ElementValueType valueType = type.getValue();
        this.addRequestParameter(type, defaultValueType, valueType);
    }

    public void addRequestParameter(IntegerParameterType type) {
        this.check(type, MSG_TYPE);
        ElementValueType defaultValueType = type.getDefaultValue();
        ElementValueType valueType = type.getValue();
        this.addRequestParameter(type, defaultValueType, valueType);
    }

    public void addRequestParameter(StringParameterType type) {
        this.check(type, MSG_TYPE);
        ElementValueType defaultValueType = type.getDefaultValue();
        ElementValueType valueType = type.getValue();
        this.addRequestParameter(type, defaultValueType, valueType);
    }

    private <T extends BaseParameterType> void addRequestParameter(T type, ElementValueType defaultValueType, ElementValueType valueType) {
        Map<String, Object> map = this.getRequestParameters();
        this.set(type, defaultValueType, valueType, map);
    }

    public void addRequestParameter(URIParameterType type) {
        this.check(type, MSG_TYPE);
        ElementValueType defaultValueType = type.getDefaultValue();
        ElementValueType valueType = type.getValue();
        this.addRequestParameter(type, defaultValueType, valueType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequiredResource(String referenceId, String foreignId) {
        Map<String, String> requiredResourceMap;
        this.check(referenceId, MSG_REFERENCE_ID);
        this.check(foreignId, MSG_FOREIGN_ID);
        String message = String.format("addRequiredResource() - adding key referenceId of \"%s\" for value \"%s\"", referenceId, foreignId);
        logger.info(message);
        Map<String, String> map = requiredResourceMap = this.getRequiredResourceMap();
        synchronized (map) {
            requiredResourceMap.put(referenceId, foreignId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceModel(String id, Object resource) {
        Map<String, Object> resourceModel;
        String message;
        this.check(id, MSG_ID);
        this.check(resource, MSG_RESOURCE);
        String key = id;
        String foreignId = this.getRequiredResource(id);
        if (foreignId != null) {
            message = String.format("addResourceModel() - resetting resource id from \"%s\" to foreign id of \"%s\"", id, foreignId);
            logger.info(message);
            key = foreignId;
        }
        message = String.format("addResourceModel() - adding resource model for  \"%s\" of \"%s\"", key, resource);
        logger.info(message);
        Map<String, Object> map = resourceModel = this.getResourceModel();
        synchronized (map) {
            resourceModel.put(key, resource);
        }
    }

    public void addResponseParameters(Map<String, String> responseParameters) {
        this._responseParameters = responseParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultingResource(List<ResultingResourceType> resultingResource) {
        this.check(resultingResource, MSG_RESULTING_RESOURCE);
        for (ResultingResourceType resource : resultingResource) {
            Map<String, ResultingResourceType> resultingResources;
            List<ResultingPropertyType> properties = resource.getProperty();
            for (ResultingPropertyType prop : properties) {
                ElementValueType newType = new ElementValueType();
                newType.setValue(this.substituteVariables(prop.getValue().getValue()));
                prop.setValue(newType);
            }
            String hostedResourceId = ((ResourceType)resource.getResourceRef()).getId();
            Map<String, ResultingResourceType> map = resultingResources = this.getResultingResources();
            synchronized (map) {
                boolean exists = resultingResources.containsKey(hostedResourceId);
                if (!exists) {
                    logger.info("addResultingResource() - storing resource for hosted id:" + hostedResourceId);
                    resultingResources.put(hostedResourceId, resource);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectedFeature(String featureId) {
        Map<String, String> selectedFeatureMap;
        this.check(featureId, MSG_FEATURE_ID);
        Map<String, String> map = selectedFeatureMap = this.getSelectedFeatures();
        synchronized (map) {
            selectedFeatureMap.put(featureId, featureId);
        }
    }

    public void addSelectedFeatures(List<String> featureIds) {
        this.check(featureIds, MSG_FEATURE_IDS);
        for (String featureId : featureIds) {
            this.addSelectedFeature(featureId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicSetCurrentFeature(FeatureType currentFeature) {
        SDDContext sDDContext = this;
        synchronized (sDDContext) {
            this._currentFeature = currentFeature;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildReferenceMaps(PackageDescriptorType pd) {
        if (pd == null) {
            return;
        }
        Map<String, ContentType> map = this.getPackageContent();
        ContentsType contents = pd.getContents();
        List<ContentType> list = contents.getContent();
        for (ContentType value : list) {
            String key = value.getId();
            Map<String, ContentType> map2 = map;
            synchronized (map2) {
                boolean exists = map.containsKey(key);
                if (!exists) {
                    map.put(key, value);
                }
            }
        }
    }

    private void check(Object object, String label) {
        if (object != null) {
            return;
        }
        String message = String.format("%s must not be null", label);
        throw new IllegalArgumentException(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsParameter(String parameterId) {
        Map<String, Object> parameters;
        this.check(parameterId, MSG_PARAMETER_ID);
        Map<String, Object> map = parameters = this.getParameters();
        synchronized (map) {
            return parameters.containsKey(parameterId);
        }
    }

    public boolean containsVariable(String id) {
        logger.info(String.format("containsVariable(%s)", id));
        VariablesTypeExt variables = this.getVariables();
        return variables.contains(id);
    }

    private InputStream createInputStream(String filename) throws IOException {
        this.check(filename, MSG_FILENAME);
        if (filename.startsWith("http:") || filename.startsWith("file:")) {
            URL url = new URL(filename);
            return url.openStream();
        }
        return new FileInputStream(filename);
    }

    private Unmarshaller createUnmarshaller() throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)"com.sas.solstice.platform.core.model");
        return jc.createUnmarshaller();
    }

    private boolean existsInList(LanguageType languageType, List<LanguageType> listOfLanguageTypes) {
        Iterator<LanguageType> iterator = listOfLanguageTypes.iterator();
        boolean match = false;
        while (!match && iterator.hasNext()) {
            LanguageType item = iterator.next();
            match = this.matches(languageType, item);
        }
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushFeaturesConfiguration() {
        Map<String, List<ArtifactType>> featuresConfiguration;
        Map<String, List<ArtifactType>> map = featuresConfiguration = this.getFeaturesConfiguration();
        synchronized (map) {
            featuresConfiguration.clear();
        }
    }

    public String getCacheLocation() throws UnknownHostException {
        return this._p2Location + File.separator + InetAddress.getLocalHost().getCanonicalHostName() + File.separator + "plugins";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ArtifactType> getConfigurationUnitArtifacts() {
        SDDContext sDDContext = this;
        synchronized (sDDContext) {
            if (this._configurationArtifacts == null) {
                this._configurationArtifacts = new ArrayList<ArtifactType>(10);
            }
            return this._configurationArtifacts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentType getContentById(String id) {
        Map<String, ContentType> map;
        Map<String, ContentType> map2 = map = this.getPackageContent();
        synchronized (map2) {
            return map.get(id);
        }
    }

    public List<ContentType> getContentByPurpose(String purpose) {
        this.check(purpose, MSG_PURPOSE);
        Map<String, ContentType> map = this.getPackageContent();
        int size = map.size();
        ArrayList<ContentType> result = new ArrayList<ContentType>(size);
        Collection<ContentType> values = map.values();
        for (ContentType content : values) {
            String contentPurpose = content.getPurpose();
            boolean match = purpose.equals(contentPurpose);
            if (!match) continue;
            result.add(content);
        }
        return result;
    }

    public ContentType getContentTypeById(String contentRef) {
        if (contentRef == null) {
            return null;
        }
        Map<String, ContentType> map = this.getPackageContent();
        Collection<ContentType> values = map.values();
        Iterator<ContentType> iterator = values.iterator();
        boolean match = false;
        ContentType content = null;
        while (!match && iterator.hasNext()) {
            content = iterator.next();
            String id = content.getId();
            match = contentRef.equals(id);
        }
        return match ? content : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCoRequisite(String id) {
        Map<String, String> coReqs;
        this.check(id, MSG_ID);
        Map<String, String> map = coReqs = this.getCoRequisites();
        synchronized (map) {
            return coReqs.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getCoRequisites() {
        SDDContext sDDContext = this;
        synchronized (sDDContext) {
            if (this._coReqs == null) {
                this._coReqs = new HashMap<String, String>(17);
            }
            return this._coReqs;
        }
    }

    private String getCountry() {
        Locale locale = Locale.getDefault();
        return locale.getCountry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureType getCurrentFeature() {
        SDDContext sDDContext = this;
        synchronized (sDDContext) {
            return this._currentFeature;
        }
    }

    public NestedFeatureType getCurrentNestedFeature() {
        return this._currentNestedFeature;
    }

    public DeploymentDescriptorType getDeploymentDescriptor() {
        return this._deploymentDescriptor;
    }

    public Properties getDescriptorLanguageBundle() {
        Properties properties = null;
        PackageDescriptorType descriptor = this.getPackageDescriptor();
        ContentsType contents = descriptor.getContents();
        List<ContentType> list = contents.getContent();
        Iterator<ContentType> iterator = list.iterator();
        boolean found = false;
        ContentType content = null;
        while (!found && iterator.hasNext()) {
            content = iterator.next();
            found = this.isDescriptorLanguageBundle(content);
        }
        if (found) {
            String filename = this.getFilename(content);
            try {
                properties = this.loadProperties(filename);
            }
            catch (IOException exception) {
                String error = exception.getMessage();
                String message = String.format("Failed to load the properties file \"%s\": %s", filename, error);
                logger.info(message);
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Deque<DeploymentDescriptorType> getDescriptors() {
        SDDContext sDDContext = this;
        synchronized (sDDContext) {
            if (this._descriptors == null) {
                this._descriptors = new LinkedList<DeploymentDescriptorType>();
            }
            return this._descriptors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExRequisite(String id) {
        Map<String, String> exReqs;
        this.check(id, MSG_ID);
        Map<String, String> map = exReqs = this.getExRequisites();
        synchronized (map) {
            return exReqs.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getExRequisites() {
        SDDContext sDDContext = this;
        synchronized (sDDContext) {
            if (this._exReqs == null) {
                this._exReqs = new HashMap<String, String>(17);
            }
            return this._exReqs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<ArtifactType>> getFeaturesCollection() {
        SDDContext sDDContext = this;
        synchronized (sDDContext) {
            if (this._featuresCollection == null) {
                this._featuresCollection = new HashMap<String, List<ArtifactType>>(17);
            }
            return this._featuresCollection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getFeaturesCollectionKeys() {
        Map<String, List<ArtifactType>> featuresCollection;
        Map<String, List<ArtifactType>> map = featuresCollection = this.getFeaturesCollection();
        synchronized (map) {
            return featuresCollection.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<ArtifactType>> getFeaturesConfiguration() {
        SDDContext sDDContext = this;
        synchronized (sDDContext) {
            if (this._featuresConfiguration == null) {
                this._featuresConfiguration = new HashMap<String, List<ArtifactType>>(17);
            }
            return this._featuresConfiguration;
        }
    }

    private String getFilename(ContentType content) {
        this.check(content, MSG_CONTENT);
        String filename = content.getPathname();
        if (this.isDefaultCountry() && this.isDefaultLanguage()) {
            return filename;
        }
        filename = this.toLocalizedFilename(filename);
        return filename;
    }

    public InputStream getInputStreamForPath(String path) throws IOException {
        this.check(path, MSG_PATH);
        String substitutedPath = this.substituteVariables(path);
        File file = new File(substitutedPath);
        boolean readable = file.canRead();
        if (readable) {
            return new FileInputStream(file);
        }
        String message = String.format("The file \"%s\" is not readable", file);
        throw new IOException(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getInstallableFeatures() {
        Map<String, ArtifactType> map;
        Map<String, ArtifactType> map2 = map = this.getInstallableUnitArtifacts();
        synchronized (map2) {
            int size = map.size();
            String[] features = new String[size];
            Set<String> keys = map.keySet();
            logger.debug("InstallableFeatures:  ");
            for (String key : keys) {
                logger.debug("\t" + key);
            }
            return keys.toArray(features);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ArtifactType> getInstallableUnitArtifacts() {
        SDDContext sDDContext = this;
        synchronized (sDDContext) {
            if (this._artifacts == null) {
                this._artifacts = new HashMap<String, ArtifactType>();
            }
            return this._artifacts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ArtifactType> getInstallableUnitArtifactsForFeature(String featureId) {
        Map<String, List<ArtifactType>> featuresCollection;
        this.check(featureId, MSG_FEATURE_ID);
        Map<String, List<ArtifactType>> map = featuresCollection = this.getFeaturesCollection();
        synchronized (map) {
            return featuresCollection.get(featureId);
        }
    }

    private String getLanguage() {
        Locale locale = Locale.getDefault();
        return locale.getLanguage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ContentType> getPackageContent() {
        SDDContext sDDContext = this;
        synchronized (sDDContext) {
            if (this._packageContent == null) {
                this._packageContent = new HashMap<String, ContentType>();
            }
            return this._packageContent;
        }
    }

    public PackageDescriptorType getPackageDescriptor() {
        return this._packageDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, PackageIdentityType> getPackageIdentity() {
        SDDContext sDDContext = this;
        synchronized (sDDContext) {
            if (this._identityMap == null) {
                this._identityMap = new HashMap<String, PackageIdentityType>(17);
            }
            return this._identityMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageIdentityType getPackageIdentity(String id) {
        Map<String, PackageIdentityType> identityMap;
        this.check(id, MSG_ID);
        Map<String, PackageIdentityType> map = identityMap = this.getPackageIdentity();
        synchronized (map) {
            return identityMap.get(id);
        }
    }

    public URI getPackageUri() {
        return this._packageUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getParameter(String key) {
        Map<String, Object> parameters;
        this.check(key, MSG_KEY);
        Map<String, Object> map = parameters = this.getParameters();
        synchronized (map) {
            return parameters.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getParameters() {
        SDDContext sDDContext = this;
        synchronized (sDDContext) {
            if (this._parameters == null) {
                this._parameters = new LinkedHashMap<String, Object>(17);
            }
            return this._parameters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getRequestParameters() {
        SDDContext sDDContext = this;
        synchronized (sDDContext) {
            if (this._requestParameters == null) {
                this._requestParameters = new LinkedHashMap<String, Object>(17);
            }
            return this._requestParameters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRequiredResource(String foreignId) {
        String resource;
        Map<String, String> requiredResourceMap;
        this.check(foreignId, MSG_FOREIGN_ID);
        logger.info(String.format("getRequiredResource() - looking for a required resource using \"%s\"", foreignId));
        Map<String, String> map = requiredResourceMap = this.getRequiredResourceMap();
        synchronized (map) {
            resource = requiredResourceMap.get(foreignId);
        }
        String message = resource == null ? String.format("getRequiredResource() - there was no required resource found for \"%s\"", foreignId) : String.format("getRequiredResource() - found required resource \"%s\" using \"%s\"", resource, foreignId);
        logger.info(message);
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getRequiredResourceMap() {
        SDDContext sDDContext = this;
        synchronized (sDDContext) {
            if (this._requiredResourceMap == null) {
                this._requiredResourceMap = new HashMap<String, String>(17);
            }
            return this._requiredResourceMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getResourceModel() {
        SDDContext sDDContext = this;
        synchronized (sDDContext) {
            if (this._resourceModel == null) {
                this._resourceModel = new HashMap<String, Object>(17);
            }
            return this._resourceModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResourceModel(String id) {
        Object value;
        Map<String, Object> resourceModel;
        this.check(id, MSG_ID);
        String key = id;
        String foreignId = this.getRequiredResource(id);
        if (foreignId != null) {
            String message = String.format("getResourceModel() - resetting resource id from \"%s\" to foreign id of \"%s\"", id, foreignId);
            logger.info(message);
            key = foreignId;
        }
        Map<String, Object> map = resourceModel = this.getResourceModel();
        synchronized (map) {
            value = resourceModel.get(key);
        }
        String message = value == null ? String.format("getResourceModel() - DID NOT find a resource model for \"%s\"", key) : String.format("getResourceModel() - found resource model for \"%s\"", key);
        logger.info(message);
        return value;
    }

    public Map<String, String> getResponseParameters() {
        return this._responseParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultingResourceType getResultingResource(String unitId) {
        Map<String, ResultingResourceType> resultingResources;
        this.check(unitId, MSG_UNIT_ID);
        Map<String, ResultingResourceType> map = resultingResources = this.getResultingResources();
        synchronized (map) {
            return resultingResources.get(unitId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ResultingResourceType> getResultingResources() {
        SDDContext sDDContext = this;
        synchronized (sDDContext) {
            if (this._resultingResources == null) {
                this._resultingResources = new HashMap<String, ResultingResourceType>(17);
            }
            return this._resultingResources;
        }
    }

    public String getRootLocation() {
        return this._rootLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getSelectedFeatures() {
        SDDContext sDDContext = this;
        synchronized (sDDContext) {
            if (this._selectedFeatureMap == null) {
                this._selectedFeatureMap = new HashMap<String, String>(17);
            }
            return this._selectedFeatureMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Unmarshaller getUnmarshaller() throws JAXBException {
        SDDContext sDDContext = this;
        synchronized (sDDContext) {
            if (this._unmarshaller == null) {
                this._unmarshaller = this.createUnmarshaller();
            }
            return this._unmarshaller;
        }
    }

    public String getVariable(String id) {
        this.check(id, MSG_ID);
        logger.info(String.format("getVariable(%s)", id));
        VariablesTypeExt variables = this.getVariables();
        Variable variable = variables.get(id);
        if (variable == null) {
            return null;
        }
        String template = "getVariable(%s) - returning default=%s";
        String value = variable.getValue();
        if (value != null) {
            logger.info(String.format(template, id, value));
            return value;
        }
        value = variable.getDefaultValue();
        logger.info(String.format(template, id, value));
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariablesTypeExt getVariables() {
        SDDContext sDDContext = this;
        synchronized (sDDContext) {
            if (this._variables == null) {
                this._variables = new VariablesTypeExt();
            }
            return this._variables;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleFeature(String featureId) {
        Map<String, String> selectedFeatureMap;
        this.check(featureId, MSG_FEATURE_ID);
        Map<String, String> map = selectedFeatureMap = this.getSelectedFeatures();
        synchronized (map) {
            return selectedFeatureMap.containsKey(featureId);
        }
    }

    public boolean handleLanguage(LanguageType language) {
        this.check(language, MSG_LANGUAGE);
        NestedFeatureType nestedFeature = this.getCurrentNestedFeature();
        if (nestedFeature == null) {
            return false;
        }
        LanguageSelectionsType languageSelectionsType = nestedFeature.getLanguages();
        if (languageSelectionsType == null) {
            return false;
        }
        boolean handled = this.handleMandatoryLanguages(language, languageSelectionsType);
        if (handled) {
            return true;
        }
        handled = this.handleOptionalLanguages(language, languageSelectionsType);
        return handled;
    }

    private boolean handleMandatoryLanguages(LanguageType languageType, LanguageSelectionsType languageSelectionsType) {
        LanguagesType mandatoryLanguageType = languageSelectionsType.getMandatory();
        if (mandatoryLanguageType == null) {
            return false;
        }
        List<LanguageType> languages = mandatoryLanguageType.getLanguage();
        boolean match = this.existsInList(languageType, languages);
        return match;
    }

    private boolean handleOptionalLanguages(LanguageType languageType, LanguageSelectionsType languageSelectionsType) {
        OptionalLanguagesType optionalLanguagesType = languageSelectionsType.getOptional();
        if (optionalLanguagesType == null) {
            return false;
        }
        List<Serializable> languages = optionalLanguagesType.getLanguageOrLanguageSet();
        boolean handled = this.handleOptionalLanguages(languageType, languages);
        return handled;
    }

    private boolean handleOptionalLanguages(LanguageType languageType, List<Serializable> languages) {
        boolean handled = false;
        Iterator<Serializable> iterator = languages.iterator();
        while (!handled && iterator.hasNext()) {
            LanguageSetType optionalLanguageSetType;
            List<LanguageType> list;
            LanguageType optionalLanguageType;
            Serializable object = iterator.next();
            if (object instanceof LanguageType && (handled = this.matches(languageType, optionalLanguageType = (LanguageType)object))) {
                return true;
            }
            if (!(object instanceof LanguageSetType) || !(handled = this.existsInList(languageType, list = (optionalLanguageSetType = (LanguageSetType)object).getLanguage()))) continue;
            return true;
        }
        return handled;
    }

    public boolean hasResponseParameter(String id) {
        Map<String, String> map = this.getResponseParameters();
        if (map == null) {
            return false;
        }
        return map.containsKey(id);
    }

    public void initialize(URI packageUri) {
        this.check(packageUri, MSG_PACKAGE_URI);
        logger.info("initialize(URI) - uri= " + packageUri);
        this.setPackageUri(packageUri);
        this.setPackageDescriptor(this.loadPackageDescriptor(this.toQualifiedUri(packageUri)));
        this.loadResponseFiles();
        this.setDeploymentDescriptor(this.loadDeploymentDescriptor(this._packageDescriptor));
    }

    private boolean isDefaultCountry() {
        String value = this.getCountry();
        return value.equalsIgnoreCase(DEFAULT_COUNTRY);
    }

    private boolean isDefaultLanguage() {
        String value = this.getLanguage();
        return value.equalsIgnoreCase(DEFAULT_LANGUAGE);
    }

    private boolean isDescriptorLanguageBundle(ContentType content) {
        String purpose = content.getPurpose();
        return purpose.equalsIgnoreCase(PURPOSE_DESCRIPTION_LANGUAGE_BUNDLE);
    }

    public boolean isOk() {
        return this._ok;
    }

    protected DeploymentDescriptorType loadDeploymentDescriptor(PackageDescriptorType pd) {
        String deploymentDescriptorUri = null;
        if (pd != null) {
            byte[] bytes = pd.getDescriptorID();
            String id = String.valueOf(bytes);
            logger.info(String.format("loadDeploymentDescriptor() - loading associated package descriptor=%s", id));
            String ddPurpose = SDDContentPurposeType.DEPLOYMENT_DESCRIPTOR.value();
            for (ContentType ct : pd.getContents().getContent()) {
                if (!ddPurpose.equals(ct.getPurpose())) continue;
                deploymentDescriptorUri = ct.getPathname();
                break;
            }
        }
        this.buildReferenceMaps(pd);
        URI uri = null;
        try {
            uri = new URI(deploymentDescriptorUri);
        }
        catch (URISyntaxException exception) {
            logger.error("failed to create URI", (Throwable)exception);
        }
        uri = this.toQualifiedUri(uri);
        return this.loadDeploymentDescriptor(uri);
    }

    protected DeploymentDescriptorType loadDeploymentDescriptor(URI uri) {
        return (DeploymentDescriptorType)this.loadDescriptor(uri);
    }

    private <T> T loadDescriptor(URI uri) {
        logger.info("load(URI) - loading descriptor, uri=" + uri);
        if (uri == null) {
            return null;
        }
        T result = null;
        URI qualifiedUri = this.toQualifiedUri(uri);
        try {
            URL url = qualifiedUri.toURL();
            result = this.loadDescriptor(url);
        }
        catch (MalformedURLException exception) {
            String message = String.format("failed to load descriptor \"%s\"", uri);
            logger.error(message, (Throwable)exception);
        }
        return result;
    }

    private <T> T loadDescriptor(URL url) {
        this.check(url, MSG_URL);
        Object result = null;
        try {
            Unmarshaller unmarshaller = this.getUnmarshaller();
            JAXBElement element = (JAXBElement)unmarshaller.unmarshal(url);
            result = element.getValue();
        }
        catch (JAXBException exception) {
            String message = String.format("failed to unmarshal \"%s\"", url);
            logger.error(message, (Throwable)exception);
        }
        return (T)result;
    }

    protected PackageDescriptorType loadPackageDescriptor(URI uri) {
        return (PackageDescriptorType)this.loadDescriptor(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(String filename) throws IOException {
        String propertyFilename;
        this.check(filename, MSG_FILENAME);
        logger.info("loadProperties() - from reference " + filename);
        try {
            URI uri = new URI(filename);
            uri = this.toQualifiedUri(uri);
            propertyFilename = uri.toString();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        logger.info("loadProperties() - from " + propertyFilename);
        Properties properties = new Properties();
        try (InputStream stream = this.createInputStream(propertyFilename);){
            properties.load(stream);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadResponseFiles() {
        List<ContentType> responseFiles = this.getContentByPurpose(SDDContentPurposeType.RESPONSE_FILE.value());
        for (ContentType responseFile : responseFiles) {
            String path = responseFile.getPathname();
            Properties props = new Properties();
            try (InputStream stream = this.getInputStreamForPath(path);){
                props.load(stream);
            }
            catch (IOException exception) {
                String message = String.format("Failed to load response file \"%s\"", path);
                logger.error(message, (Throwable)exception);
                continue;
            }
            Set<Map.Entry<Object, Object>> set = props.entrySet();
            for (Map.Entry<Object, Object> entry : set) {
                String variable = (String)entry.getKey();
                String value = (String)entry.getValue();
                this.setVariable(variable, value);
            }
        }
    }

    private boolean matches(LanguageType left, LanguageType right) {
        String leftValue = left.getType();
        String rightValue = right.getType();
        boolean equal = rightValue.equalsIgnoreCase(leftValue);
        return equal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentDescriptorType popDeploymentDescriptor() {
        Deque<DeploymentDescriptorType> descriptors;
        Deque<DeploymentDescriptorType> deque = descriptors = this.getDescriptors();
        synchronized (deque) {
            boolean empty = descriptors.isEmpty();
            return empty ? null : descriptors.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushDeploymentDescriptor(DeploymentDescriptorType deploymentDescriptor) {
        Deque<DeploymentDescriptorType> descriptors;
        this.check(deploymentDescriptor, MSG_DEPLOYMENT_DESCRIPTOR);
        Deque<DeploymentDescriptorType> deque = descriptors = this.getDescriptors();
        synchronized (deque) {
            descriptors.push(deploymentDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends BaseParameterType> void set(T type, ElementValueType defaultValueType, ElementValueType valueType, Map<String, Object> map) {
        String id = type.getId();
        boolean required = type.isRequired();
        String defaultValue = defaultValueType == null ? null : defaultValueType.getValue();
        String value = valueType == null ? null : valueType.getValue();
        this.setParameter(id, required, defaultValue, value);
        Map<String, Object> map2 = map;
        synchronized (map2) {
            map.put(id, type);
        }
    }

    public void setCacheLocation(String location) {
        this._p2Location = location;
    }

    public void setCurrentFeature(FeatureType feature) {
        this.basicSetCurrentFeature(feature);
        this.flushFeaturesConfiguration();
    }

    public void setCurrentNestedFeature(NestedFeatureType nestedFeature) {
        this._currentNestedFeature = nestedFeature;
    }

    public void setDeploymentDescriptor(DeploymentDescriptorType deploymentDescriptor) {
        this._deploymentDescriptor = deploymentDescriptor;
    }

    public void setOk(boolean ok) {
        this._ok = ok;
    }

    public void setPackageDescriptor(PackageDescriptorType packageDescriptor) {
        this._packageDescriptor = packageDescriptor;
    }

    public void setPackageUri(URI packageURI) {
        this._packageUri = packageURI;
    }

    public void setParameter(BooleanParameterType type) {
        this.check(type, MSG_TYPE);
        ElementValueType defaultValueType = type.getDefaultValue();
        ElementValueType valueType = type.getValue();
        this.setParameter(type, defaultValueType, valueType);
    }

    public void setParameter(IntegerParameterType type) {
        this.check(type, MSG_TYPE);
        ElementValueType defaultValueType = type.getDefaultValue();
        ElementValueType valueType = type.getValue();
        this.setParameter(type, defaultValueType, valueType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter(String id, boolean required, String defaultValue, String value) {
        VariablesTypeExt variables;
        this.check(id, MSG_ID);
        VariablesTypeExt variablesTypeExt = variables = this.getVariables();
        synchronized (variablesTypeExt) {
            Variable v = variables.get(id);
            if (v == null) {
                v = new Variable(id, null);
            }
            v.setParameter(true);
            v.setRequired(required);
            if (defaultValue != null) {
                v.setDefaultValue(defaultValue);
            }
            if (value != null) {
                v.setValue(value);
            }
            variables.add(v);
        }
    }

    public void setParameter(StringParameterType type) {
        this.check(type, MSG_TYPE);
        ElementValueType defaultValueType = type.getDefaultValue();
        ElementValueType valueType = type.getValue();
        Map<String, Object> parameters = this.getParameters();
        this.set(type, defaultValueType, valueType, parameters);
    }

    private <T extends BaseParameterType> void setParameter(T type, ElementValueType defaultValueType, ElementValueType valueType) {
        Map<String, Object> map = this.getParameters();
        this.set(type, defaultValueType, valueType, map);
    }

    public void setParameter(URIParameterType type) {
        this.check(type, MSG_TYPE);
        ElementValueType defaultValueType = type.getDefaultValue();
        ElementValueType valueType = type.getValue();
        this.setParameter(type, defaultValueType, valueType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setParameters(Map<String, Object> parameters) {
        SDDContext sDDContext = this;
        synchronized (sDDContext) {
            this._parameters = parameters;
        }
    }

    public void setRootLocation(String location) {
        if (location == null) {
            throw new IllegalArgumentException("location must not be null");
        }
        this._rootLocation = location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVariable(String id, String value) {
        VariablesTypeExt variables;
        logger.info(String.format("setVariable(%s, %s)", id, value));
        VariablesTypeExt variablesTypeExt = variables = this.getVariables();
        synchronized (variablesTypeExt) {
            Variable v = variables.get(id);
            if (v == null) {
                v = new Variable(id, value);
                variables.add(v);
                return;
            }
            v.setValue(value);
        }
    }

    public String substituteVariables(String expression) {
        String variable;
        if (expression == null) {
            return null;
        }
        logger.info(String.format("substituteVariables(%s)", expression));
        String result = expression;
        Matcher matcher = PATTERN.matcher(result);
        int findIndex = 0;
        while (matcher.find(findIndex)) {
            variable = result.substring(matcher.start() + 2, matcher.end() - 1);
            String value = this.getVariable(variable);
            if (value == null) {
                findIndex = matcher.end();
            } else {
                result = result.replace(result.substring(matcher.start(), matcher.end()), value);
                findIndex = matcher.start() + value.length();
            }
            matcher = PATTERN.matcher(result);
        }
        matcher = WINDOWS_PATTERN.matcher(result);
        while (matcher.find()) {
            variable = result.substring(matcher.start() + 1, matcher.end() - 1);
            if (variable.equalsIgnoreCase(PROGRAM_FILES) && System.getenv(PROGRAM_FILES_32BIT_ENV_VARIABLE) != null) {
                variable = PROGRAM_FILES_64BIT_ENV_VARIABLE;
            }
            result = result.replace(result.substring(matcher.start(), matcher.end()), System.getenv(variable));
            matcher = PATTERN.matcher(result);
        }
        matcher = UNIX_PATTERN.matcher(result);
        while (matcher.find()) {
            variable = result.substring(matcher.start() + 2, matcher.end() - 1);
            result = result.replace(result.substring(matcher.start(), matcher.end()), System.getenv(variable));
            matcher = PATTERN.matcher(result);
        }
        logger.info(String.format("substituteVariables() - returning %s", result));
        return result;
    }

    private String toLocalizedFilename(String filename) {
        String localizedFilename;
        boolean withExtension;
        String language = this.getLanguage();
        String country = this.getCountry();
        int lastPeriod = filename.lastIndexOf(46);
        boolean bl = withExtension = lastPeriod != -1;
        if (withExtension) {
            String name = filename.substring(0, lastPeriod);
            int length = filename.length();
            String extension = filename.substring(lastPeriod, length);
            localizedFilename = String.format("%s_%s_%s%s", name, language, country, extension);
        } else {
            localizedFilename = String.format("%s_%s_%s", filename, language, country);
        }
        File file = new File(localizedFilename);
        boolean exists = file.exists();
        if (!exists) {
            localizedFilename = filename;
        }
        return localizedFilename;
    }

    public URI toQualifiedUri(URI uri) {
        logger.info("toQualifiedUri() - uri= " + uri);
        if (uri == null) {
            return null;
        }
        try {
            if (uri.isAbsolute()) {
                logger.info("toQualifiedUri() - absolute returning " + uri);
                return uri;
            }
            String rootLocation = this.getRootLocation();
            logger.info("toQualifiedUri() - URI found to be relative - returning with appended root of " + rootLocation + " for full path of " + rootLocation + uri);
            return new URI(rootLocation + uri);
        }
        catch (URISyntaxException exception) {
            logger.error("toQualifiedUri() - failed to create qualified URI", (Throwable)exception);
            return null;
        }
    }
}

