/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common.menu;

import com.sas.solstice.platform.application.common.api.IAvailabilityPolicy;
import com.sas.solstice.platform.application.common.api.IConsole;
import com.sas.solstice.platform.application.common.api.command.ICommand;
import com.sas.solstice.platform.application.common.api.command.ICommandProvider;
import com.sas.solstice.platform.application.common.api.menu.IMenu;
import com.sas.solstice.platform.application.common.api.menu.IMenuManager;
import com.sas.solstice.platform.application.common.api.menu.IMenuProvider;
import com.sas.solstice.platform.application.common.internal.util.StringUtility;
import com.sas.solstice.platform.application.common.internal.util.SystemConsole;
import com.sas.solstice.platform.application.common.menu.ConsoleMenuVisibilityPolicy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class ConsoleMenuManager
implements IMenuManager {
    private static final String CHILD_MENU_OPTION_TEMPLATE = "%s.%s";
    private static final String CHILD_MENU_TEMPLATE = "%s%s) %s";
    private static final String CONCAT_TEMPLATE = "%s%s";
    private static final String MENU_DEBUG_DECORATION_TEMPLATE = "%s ~ %s";
    private static final String MENU_DECORATION_TEMPLATE = "%s [%s]";
    private static final String MENU_TEMPLATE = "%s) %s";
    private static final String TITLE_TEMPLATE = "%s: %s";
    private static final String BACK_OPTION_STRING = "B";
    private static final String BACK_LONG_OPTION_STRING = "Back";
    private static final String EXIT_OPTION_STRING = "E";
    private static final String EXIT_LONG_OPTION_STRING = "Exit";
    private static final String ROOT_OPTION_STRING = "R";
    private static final String ROOT_LONG_OPTION_STRING = "Root";
    private static final String QUIT_OPTION_STRING = "Q";
    private static final String QUIT_LONG_OPTION_STRING = "Quit";
    private static final String ELLIPSIS = "...";
    private static final String PROMPT = "=>";
    private static final char INDENT_CHAR = '\t';
    private static final char NEWLINE = '\n';
    private static final int INFINITE_DISPLAY_DEPTH = 0;
    private static final String DISPLAY_DEPTH_PROPERTY = "com.sas.solstice.platform.application.common.menu.displayDepth";
    private String title;
    private int displayDepth;
    private IConsole console;
    private IMenuProvider menuProvider;
    private IMenu currentMenu;
    private IAvailabilityPolicy<IMenu> visibilityPolicy;
    private ICommandProvider commandProvider;

    public ConsoleMenuManager(String title) {
        this(title, 0);
    }

    public ConsoleMenuManager(String title, int displayDepth) {
        if (title == null) {
            throw new IllegalArgumentException("title must not be null");
        }
        if (displayDepth < 0) {
            throw new IllegalArgumentException("displayDepth must be greater than or equal to 0");
        }
        this.setTitle(title);
        this.setDisplayDepth(displayDepth);
    }

    private int basicGetDisplayDepth() {
        return this.displayDepth;
    }

    private String createChildLabel(IMenu child, String option, int depth) {
        String indendation = this.createIndentation(depth);
        String label = child.getLabel();
        String line = String.format(CHILD_MENU_TEMPLATE, indendation, option, label);
        return this.toDecoratedLabel(line, child);
    }

    private String createChildMenuOptionLabel(String parentOptionLabel, int number) {
        return String.format(CHILD_MENU_OPTION_TEMPLATE, parentOptionLabel, number);
    }

    private String createIndentation(int indent) {
        char[] chars = new char[indent];
        Arrays.fill(chars, '\t');
        return new String(chars);
    }

    private String createOptionLabel(IMenu menu, String option) {
        String label = menu.getLabel();
        String line = String.format(MENU_TEMPLATE, option, label);
        return this.toDecoratedLabel(line, menu);
    }

    private IMenu createQuitMenu() {
        IMenuProvider provider = this.getMenuProvider();
        return provider.createQuitMenu(QUIT_LONG_OPTION_STRING);
    }

    private String createSelectionDetails(IMenu menu) {
        String label = menu.getLabel();
        return String.format("Selected \"%s\".", label);
    }

    private IAvailabilityPolicy<IMenu> createVisibilityPolicy() {
        IMenuProvider menuProvider = this.getMenuProvider();
        ICommandProvider provider = this.getCommandProvider();
        return new ConsoleMenuVisibilityPolicy(menuProvider, provider);
    }

    private void display(IMenu parent) {
        List<IMenu> children = this.getMenus(parent);
        this.display(parent, children);
    }

    private void display(IMenu parent, List<IMenu> children) {
        StringBuffer buffer = new StringBuffer(500);
        this.displayTitleOn(parent, buffer);
        this.displayMenuOn(children, buffer);
        this.displayBackMenuOn(parent, buffer);
        this.displayRootMenuOn(parent, buffer);
        this.displayQuitMenuOn(buffer);
        this.println(buffer);
    }

    private void displayBackMenuOn(IMenu parent, StringBuffer buffer) {
        IMenuProvider provider;
        IMenu menu;
        boolean displayable;
        if (parent == null) {
            return;
        }
        String label = BACK_LONG_OPTION_STRING;
        IMenu grandparent = this.getParentOf(parent);
        if (grandparent != null) {
            String grandparentLabel = grandparent.getLabel();
            label = String.format("%s to \"%s\"", label, grandparentLabel);
        }
        if (!(displayable = (menu = (provider = this.getMenuProvider()).createBackMenu(label)).isAvailable())) {
            return;
        }
        this.displayMenuOn(menu, BACK_OPTION_STRING, buffer);
    }

    private void displayChildOn(IMenu child, String optionLabel, StringBuffer buffer, int depth) {
        String line = this.createChildLabel(child, optionLabel, depth);
        buffer.append(line);
        buffer.append('\n');
        this.displayChildrenOn(child, optionLabel, buffer, depth + 1);
    }

    private void displayChildrenOn(IMenu parent, String option, StringBuffer buffer) {
        this.displayChildrenOn(parent, option, buffer, 1);
    }

    private void displayChildrenOn(IMenu parent, String optionLabel, StringBuffer buffer, int depth) {
        int displayDepth = this.getDisplayDepth();
        if (depth == displayDepth) {
            return;
        }
        List<IMenu> children = this.getChildrenMenusOf(parent);
        this.displayChildrenOn(children, optionLabel, buffer, depth);
    }

    private void displayChildrenOn(List<IMenu> children, String optionLabel, StringBuffer buffer, int depth) {
        int number = 1;
        for (IMenu child : children) {
            String childOptionLabel = this.createChildMenuOptionLabel(optionLabel, number);
            this.displayChildOn(child, childOptionLabel, buffer, depth);
            ++number;
        }
    }

    private void displayMenuOn(IMenu menu, String option, StringBuffer buffer) {
        String line = this.createOptionLabel(menu, option);
        buffer.append(line);
        buffer.append('\n');
        this.displayChildrenOn(menu, option, buffer);
    }

    private void displayMenuOn(List<IMenu> menus, StringBuffer buffer) {
        int i = 1;
        for (IMenu menu : menus) {
            String option = String.valueOf(i);
            this.displayMenuOn(menu, option, buffer);
            ++i;
        }
    }

    private void displayQuitMenuOn(StringBuffer buffer) {
        IMenu menu = this.createQuitMenu();
        boolean displayable = menu.isAvailable();
        if (!displayable) {
            return;
        }
        this.displayMenuOn(menu, QUIT_OPTION_STRING, buffer);
    }

    private void displayRootMenuOn(IMenu parent, StringBuffer buffer) {
        if (parent == null) {
            return;
        }
        IMenu grandparent = this.getParentOf(parent);
        if (grandparent == null) {
            return;
        }
        IMenuProvider provider = this.getMenuProvider();
        IMenu menu = provider.createRootMenu(ROOT_LONG_OPTION_STRING);
        boolean displayable = menu.isAvailable();
        if (!displayable) {
            return;
        }
        this.displayMenuOn(menu, ROOT_OPTION_STRING, buffer);
    }

    private void displaySelectionDetails(IMenu parent, IMenu menu) {
        if (menu == null) {
            return;
        }
        boolean skip = menu.equals(parent);
        if (skip) {
            return;
        }
        String message = this.createSelectionDetails(menu);
        this.println(message);
    }

    private void displayTitleOn(IMenu parent, StringBuffer buffer) {
        buffer.append('\n');
        String title = this.getTitle(parent);
        buffer.append(title);
        buffer.append('\n');
    }

    private IMenu getAvailableMenuByCommandId(String commandId) {
        IMenuProvider provider = this.getMenuProvider();
        IMenu menu = provider.getByCommandId(commandId);
        if (menu == null) {
            return null;
        }
        boolean available = this.isAvailable(menu);
        if (!available) {
            return null;
        }
        return menu;
    }

    private List<IMenu> getAvailableMenus(List<IMenu> candidates) {
        int size = candidates.size();
        ArrayList<IMenu> menus = new ArrayList<IMenu>(size);
        for (IMenu menu : candidates) {
            boolean available = this.isAvailable(menu);
            if (!available) continue;
            menus.add(menu);
        }
        return menus;
    }

    private List<IMenu> getChildrenMenusOf(IMenu menu) {
        IMenuProvider provider = this.getMenuProvider();
        List<IMenu> candidates = provider.getChildrenOf(menu);
        return this.getAvailableMenus(candidates);
    }

    private ICommand<?> getCommand(String id) {
        if (id == null) {
            return null;
        }
        ICommandProvider commandProvider = this.getCommandProvider();
        return commandProvider.get(id);
    }

    @Override
    public ICommandProvider getCommandProvider() {
        if (this.commandProvider == null) {
            throw new IllegalStateException("commandProvider has not been set");
        }
        return this.commandProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IConsole getConsole() {
        ConsoleMenuManager consoleMenuManager = this;
        synchronized (consoleMenuManager) {
            if (this.console == null) {
                this.setConsole(new SystemConsole());
            }
            return this.console;
        }
    }

    private IMenu getCurrentMenu() {
        return this.currentMenu;
    }

    private String getDecoration(IMenu menu) {
        String id = menu.getCommandId();
        return this.getDecoration(id);
    }

    private String getDecoration(String id) {
        if (id == null) {
            return null;
        }
        ICommand<?> command = this.getCommand(id);
        if (command == null) {
            return null;
        }
        String decoration = command.getDecoration();
        return decoration == null ? null : decoration.trim();
    }

    private int getDisplayDepth() {
        int systemPropertyValue = this.getDisplayDepthSystemPropertyValue();
        return systemPropertyValue >= 0 ? systemPropertyValue : this.basicGetDisplayDepth();
    }

    private int getDisplayDepthSystemPropertyValue() {
        String value = System.getProperty(DISPLAY_DEPTH_PROPERTY);
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException exception) {
            return -1;
        }
    }

    private IMenu getMenu(String option, List<IMenu> menus) {
        int index = this.toPositiveInteger(option);
        if (index < 1) {
            return null;
        }
        int count = menus.size();
        if (index > count) {
            return null;
        }
        return menus.get(index - 1);
    }

    private IMenuProvider getMenuProvider() {
        if (this.menuProvider == null) {
            throw new IllegalStateException("menuProvider has not been set");
        }
        return this.menuProvider;
    }

    private List<IMenu> getMenus(IMenu parent) {
        List<IMenu> candidates = parent == null ? this.getRootMenus() : this.getChildrenMenusOf(parent);
        return this.getAvailableMenus(candidates);
    }

    private IMenu getParentOf(IMenu menu) {
        IMenuProvider provider = this.getMenuProvider();
        return provider.getParentOf(menu);
    }

    private List<IMenu> getRootMenus() {
        IMenuProvider provider = this.getMenuProvider();
        return provider.getRoots();
    }

    private String getTitle() {
        return this.title;
    }

    private String getTitle(IMenu parent) {
        String title = this.getTitle();
        if (parent != null) {
            String label = parent.getLabel();
            title = String.format(TITLE_TEMPLATE, title, label);
        }
        return title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IAvailabilityPolicy<IMenu> getVisibilityPolicy() {
        ConsoleMenuManager consoleMenuManager = this;
        synchronized (consoleMenuManager) {
            if (this.visibilityPolicy == null) {
                this.setVisibilityPolicy(this.createVisibilityPolicy());
            }
            return this.visibilityPolicy;
        }
    }

    private boolean isAvailable(IMenu menu) {
        IAvailabilityPolicy<IMenu> policy = this.getVisibilityPolicy();
        return policy.isAvailable(menu);
    }

    private boolean isBackOption(String option) {
        return option.equalsIgnoreCase(BACK_OPTION_STRING) || option.equalsIgnoreCase(BACK_LONG_OPTION_STRING);
    }

    private boolean isDebugging() {
        return Boolean.getBoolean("com.sas.solstice.platform.application.common.api.menu.debug");
    }

    private boolean isExitOption(String option) {
        return option.equalsIgnoreCase(EXIT_OPTION_STRING) || option.equalsIgnoreCase(EXIT_LONG_OPTION_STRING);
    }

    private boolean isHomeOption(String option) {
        return option.equalsIgnoreCase(ROOT_OPTION_STRING) || option.equalsIgnoreCase(ROOT_LONG_OPTION_STRING);
    }

    private boolean isParent(IMenu menu) {
        List<IMenu> children = this.getChildrenMenusOf(menu);
        return !children.isEmpty();
    }

    private boolean isQuitOption(String option) {
        return option.equalsIgnoreCase(QUIT_OPTION_STRING) || option.equalsIgnoreCase(QUIT_LONG_OPTION_STRING);
    }

    private boolean isSelectionMade(IMenu menu) {
        if (menu == null) {
            return false;
        }
        return !this.isParent(menu);
    }

    private void printCommandProviderOn(StringBuffer buffer) {
        ICommandProvider commandProvider = this.getCommandProvider();
        String value = StringUtility.toFormattedBinaryString("commandProvider", commandProvider);
        buffer.append(value);
    }

    private void printConsoleOn(StringBuffer buffer) {
        IConsole console = this.getConsole();
        String value = StringUtility.toFormattedBinaryString("console", console);
        buffer.append(value);
    }

    private void printCurrentMenuOn(StringBuffer buffer) {
        IMenu currentMenu = this.getCurrentMenu();
        String value = StringUtility.toFormattedBinaryString("currentMenu", currentMenu);
        buffer.append(value);
    }

    private void printDisplayDepthOn(StringBuffer buffer) {
        int displayDepth = this.getDisplayDepth();
        Object object = displayDepth == 0 ? "<Infinite>" : Integer.valueOf(displayDepth);
        String value = StringUtility.toFormattedBinaryString("displayDepth", object);
        buffer.append(value);
    }

    private void printDisplayPolicyOn(StringBuffer buffer) {
        IAvailabilityPolicy<IMenu> displayPolicy = this.getVisibilityPolicy();
        String value = StringUtility.toFormattedBinaryString("visibilityPolicy", displayPolicy);
        buffer.append(value);
    }

    private void println(Object object) {
        IConsole console = this.getConsole();
        console.println(object);
    }

    private void printMenuProviderOn(StringBuffer buffer) {
        IMenuProvider menuProvider = this.getMenuProvider();
        String value = StringUtility.toFormattedBinaryString("menuProvider", menuProvider);
        buffer.append(value);
    }

    private void printOn(StringBuffer buffer) {
        this.printTitleOn(buffer);
        this.printDisplayDepthOn(buffer);
        this.printConsoleOn(buffer);
        this.printMenuProviderOn(buffer);
        this.printCurrentMenuOn(buffer);
        this.printDisplayPolicyOn(buffer);
        this.printCommandProviderOn(buffer);
    }

    private void printTitleOn(StringBuffer buffer) {
        String title = this.getTitle();
        String value = StringUtility.toFormattedBinaryString("title", title);
        buffer.append(value);
    }

    private String readLine() {
        IConsole console = this.getConsole();
        try {
            return console.readLine(PROMPT);
        }
        catch (IOException exception) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMenu select() {
        ConsoleMenuManager consoleMenuManager = this;
        synchronized (consoleMenuManager) {
            IMenu menu = this.getCurrentMenu();
            menu = this.getParentOf(menu);
            while (!this.isSelectionMade(menu)) {
                menu = this.select(menu);
            }
            this.setCurrentMenu(menu);
            return menu;
        }
    }

    private IMenu select(IMenu menu) {
        this.display(menu);
        String option = this.readLine();
        option = this.trimWhitepsace(option);
        IMenu selection = this.select(menu, option);
        this.displaySelectionDetails(menu, selection);
        return selection;
    }

    private IMenu select(IMenu parent, String line) {
        IMenu menu = parent;
        StringTokenizer tokenizer = new StringTokenizer(line, ".,;/");
        while (tokenizer.hasMoreTokens()) {
            List<IMenu> children;
            String option = tokenizer.nextToken();
            menu = this.select(parent, option, children = this.getMenus(menu));
            if (menu != null) continue;
            return null;
        }
        return menu;
    }

    private IMenu select(IMenu parent, String option, List<IMenu> children) {
        if (option.isEmpty()) {
            return parent;
        }
        if (this.isBackOption(option)) {
            return this.getParentOf(parent);
        }
        if (this.isHomeOption(option)) {
            return null;
        }
        if (this.isQuitOption(option) || this.isExitOption(option)) {
            return this.createQuitMenu();
        }
        return this.select(option, children);
    }

    private IMenu select(String option, List<IMenu> children) {
        IMenu menu = this.getMenu(option, children);
        if (menu != null) {
            return menu;
        }
        menu = this.getAvailableMenuByCommandId(option);
        if (menu != null) {
            return menu;
        }
        String message = String.format("Error: Option \"%s\" is unrecognized.", option);
        this.println(message);
        return null;
    }

    @Override
    public void setCommandProvider(ICommandProvider commandProvider) {
        if (commandProvider == null) {
            throw new IllegalArgumentException("commandProvider must not be null");
        }
        this.commandProvider = commandProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConsole(IConsole console) {
        ConsoleMenuManager consoleMenuManager = this;
        synchronized (consoleMenuManager) {
            this.console = console;
        }
    }

    private void setCurrentMenu(IMenu currentMenu) {
        this.currentMenu = currentMenu;
    }

    private void setDisplayDepth(int displayDepth) {
        this.displayDepth = displayDepth;
    }

    @Override
    public void setMenuProvider(IMenuProvider menuProvider) {
        if (menuProvider == null) {
            throw new IllegalArgumentException("menuProvider must not be null");
        }
        this.menuProvider = menuProvider;
    }

    private void setTitle(String title) {
        this.title = title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisibilityPolicy(IAvailabilityPolicy<IMenu> visibilityPolicy) {
        ConsoleMenuManager consoleMenuManager = this;
        synchronized (consoleMenuManager) {
            this.visibilityPolicy = visibilityPolicy;
        }
    }

    private String toDebugDecoratedLabel(String line, IMenu menu) {
        boolean debugging = this.isDebugging();
        if (!debugging) {
            return line;
        }
        String debugLabel = menu.getDebugLabel();
        return String.format(MENU_DEBUG_DECORATION_TEMPLATE, line, debugLabel);
    }

    private String toDecoratedLabel(String line, IMenu menu) {
        String decoratedLine = line;
        String decoration = this.getDecoration(menu);
        if (decoration != null && !decoration.isEmpty()) {
            decoratedLine = String.format(MENU_DECORATION_TEMPLATE, decoratedLine, decoration);
        }
        decoratedLine = this.toDebugDecoratedLabel(decoratedLine, menu);
        boolean parent = this.isParent(menu);
        if (parent) {
            decoratedLine = this.toEllipsisString(decoratedLine);
        }
        return decoratedLine;
    }

    private String toEllipsisString(String line) {
        if (line.endsWith(ELLIPSIS)) {
            return line;
        }
        return String.format(CONCAT_TEMPLATE, line, ELLIPSIS);
    }

    private int toPositiveInteger(String value) {
        String trimmedValue = value.trim();
        try {
            return Integer.parseInt(trimmedValue);
        }
        catch (NumberFormatException exception) {
            return 0;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(150);
        String value = super.toString();
        buffer.append(value);
        this.printOn(buffer);
        return buffer.toString();
    }

    private String trimWhitepsace(String value) {
        String allWhitespaceRegex = "\\s";
        String replacement = "";
        return value.replaceAll(allWhitespaceRegex, replacement);
    }
}

