/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common.menu;

import com.sas.solstice.platform.application.common.DefaultAvailabilityPolicy;
import com.sas.solstice.platform.application.common.api.IAvailabilityPolicy;
import com.sas.solstice.platform.application.common.api.menu.IMenu;
import com.sas.solstice.platform.application.common.internal.util.StringUtility;
import com.sas.solstice.platform.application.common.menu.AbstractMenu;

public class ConsoleMenu
extends AbstractMenu {
    private static int nextOrdinal = 0;
    private String parentId;
    private String commandId;
    private IAvailabilityPolicy<IMenu> availabilityPolicy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int createOrdinal() {
        Class<ConsoleMenu> clazz = ConsoleMenu.class;
        synchronized (ConsoleMenu.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return nextOrdinal++;
        }
    }

    public ConsoleMenu(String id, String label) {
        this(id, label, id);
    }

    public ConsoleMenu(String id, String label, String commandId) {
        super(ConsoleMenu.createOrdinal(), id, label);
        if (commandId == null) {
            throw new IllegalArgumentException("commandId must not be null");
        }
        this.setCommandId(commandId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IAvailabilityPolicy<IMenu> getAvailabilityPolicy() {
        ConsoleMenu consoleMenu = this;
        synchronized (consoleMenu) {
            if (this.availabilityPolicy == null) {
                this.setAvailabilityPolicy(new DefaultAvailabilityPolicy<IMenu>());
            }
            return this.availabilityPolicy;
        }
    }

    @Override
    public String getCommandId() {
        return this.commandId;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public boolean isAvailable() {
        IAvailabilityPolicy<IMenu> policy = this.getAvailabilityPolicy();
        return policy.isAvailable(this);
    }

    private void printAvailabilityPolicyOn(StringBuffer buffer) {
        IAvailabilityPolicy<IMenu> availabilityPolicy = this.getAvailabilityPolicy();
        String message = StringUtility.toFormattedBinaryString("availabilityPolicy", availabilityPolicy);
        buffer.append(message);
    }

    private void printCommandIdOn(StringBuffer buffer) {
        String value = this.getCommandId();
        String message = StringUtility.toFormattedBinaryString("commandId", value);
        buffer.append(message);
    }

    @Override
    protected void printDebugOn(StringBuffer buffer) {
        super.printDebugOn(buffer);
        String id = this.getId();
        String commandId = this.getCommandId();
        boolean match = id.equals(commandId);
        if (match) {
            return;
        }
        this.printCommandIdOn(buffer);
    }

    @Override
    protected void printOn(StringBuffer buffer) {
        super.printOn(buffer);
        this.printParentIdOn(buffer);
        this.printCommandIdOn(buffer);
        this.printAvailabilityPolicyOn(buffer);
    }

    private void printParentIdOn(StringBuffer buffer) {
        String value = this.getParentId();
        String message = StringUtility.toFormattedBinaryString("parentId", value);
        buffer.append(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAvailabilityPolicy(IAvailabilityPolicy<IMenu> availabilityPolicy) {
        ConsoleMenu consoleMenu = this;
        synchronized (consoleMenu) {
            this.availabilityPolicy = availabilityPolicy;
        }
    }

    private void setCommandId(String commandId) {
        this.commandId = commandId;
    }

    @Override
    public void setParentId(String parentId) {
        this.parentId = parentId;
    }
}

