/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common.menu;

import com.sas.solstice.platform.application.common.api.menu.IMenu;
import com.sas.solstice.platform.application.common.internal.util.StringUtility;

public abstract class AbstractMenu
implements IMenu {
    private int ordinal;
    private int positionHint;
    private String id;
    private String label;
    private Object data;

    protected AbstractMenu(int ordinal, String id, String label) {
        if (ordinal < 0) {
            throw new IllegalArgumentException("ordinal must be greater than or equal to zero");
        }
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        this.setOrdinal(ordinal);
        this.setPositionHint(0x7FFFFFFE);
        this.setId(id);
        this.setLabel(label);
    }

    private int compareOrdinals(IMenu menu) {
        int ordinal = this.getOrdinal();
        int menuOrdinal = menu.getOrdinal();
        return ordinal - menuOrdinal;
    }

    @Override
    public int compareTo(IMenu menu) {
        int menuPositionHint;
        if (menu == null) {
            throw new IllegalArgumentException("menu must not be null");
        }
        int positionHint = this.getPositionHint();
        if (positionHint == (menuPositionHint = menu.getPositionHint())) {
            return this.compareOrdinals(menu);
        }
        return positionHint - menuPositionHint;
    }

    public boolean equals(Object object) {
        int thatOrdinal;
        boolean equal = super.equals(object);
        if (equal) {
            return true;
        }
        if (!(object instanceof IMenu)) {
            return false;
        }
        IMenu menu = (IMenu)object;
        int thisOrdinal = this.getOrdinal();
        return thisOrdinal == (thatOrdinal = menu.getOrdinal());
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public String getDebugLabel() {
        return this.toDebugString();
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final String getLabel() {
        return this.label;
    }

    @Override
    public final int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public int getPositionHint() {
        return this.positionHint;
    }

    public int hashCode() {
        return this.getOrdinal();
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    private void printDataOn(StringBuffer buffer) {
        Object value = this.getData();
        String message = StringUtility.toFormattedBinaryString("data", value);
        buffer.append(message);
    }

    protected void printDebugOn(StringBuffer buffer) {
        this.printIdOn(buffer, false);
        this.printOrdinalOn(buffer);
        this.printPositionHintOn(buffer);
        this.printDataOn(buffer);
    }

    private void printIdOn(StringBuffer buffer) {
        this.printIdOn(buffer, true);
    }

    private void printIdOn(StringBuffer buffer, boolean comma) {
        String value = this.getId();
        String message = StringUtility.toFormattedBinaryString("id", value, comma);
        buffer.append(message);
    }

    private void printLabelOn(StringBuffer buffer) {
        String value = this.getId();
        String message = StringUtility.toFormattedBinaryString("label", value);
        buffer.append(message);
    }

    protected void printOn(StringBuffer buffer) {
        this.printOrdinalOn(buffer);
        this.printPositionHintOn(buffer);
        this.printIdOn(buffer);
        this.printLabelOn(buffer);
        this.printDataOn(buffer);
    }

    private void printOrdinalOn(StringBuffer buffer) {
        int ordinal = this.getOrdinal();
        String message = StringUtility.toFormattedBinaryString("ordinal", ordinal);
        buffer.append(message);
    }

    private void printPositionHintOn(StringBuffer buffer) {
        int positionHint = this.getPositionHint();
        String message = StringUtility.toFormattedBinaryString("positionHint", positionHint);
        buffer.append(message);
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }

    private void setId(String id) {
        this.id = id;
    }

    @Override
    public final void setLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("label must not be null");
        }
        this.label = label;
    }

    private void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    @Override
    public final void setPositionHint(int positionHint) {
        if (positionHint <= 0) {
            throw new IllegalArgumentException("positionHint must be a positive integer");
        }
        this.positionHint = positionHint;
    }

    protected final String toDebugString() {
        StringBuffer buffer = new StringBuffer(100);
        this.printDebugOn(buffer);
        return buffer.toString();
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer(100);
        String value = super.toString();
        buffer.append(value);
        this.printOn(buffer);
        return buffer.toString();
    }
}

