/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common.internal.util;

import com.sas.solstice.platform.application.common.api.IConsole;
import com.sas.solstice.platform.application.common.internal.util.StringUtility;
import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;

public class SystemConsole
implements IConsole {
    private static final String NO_DEFAULT_VALUE = "";
    private BufferedReader reader;
    private PrintStream printStream;

    public SystemConsole() {
        this(System.in, System.out);
    }

    public SystemConsole(InputStream inputStream, OutputStream outputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream must not be null");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream must not be null");
        }
        this.setReader(this.createReader(inputStream));
        this.setPrintStream(this.createPrintStream(outputStream));
    }

    private void checkDefaultValue(String defaultValue) {
        if (defaultValue != null) {
            return;
        }
        throw new IllegalArgumentException("defaultValue must not be null");
    }

    private PrintStream createPrintStream(OutputStream outputStream) {
        if (outputStream instanceof PrintStream) {
            return (PrintStream)outputStream;
        }
        return new PrintStream(outputStream, true);
    }

    private BufferedReader createReader(InputStream stream) {
        InputStreamReader reader = new InputStreamReader(stream);
        return new BufferedReader(reader);
    }

    private PrintStream getPrintStream() {
        return this.printStream;
    }

    private BufferedReader getReader() {
        return this.reader;
    }

    @Override
    public void print(Object value) {
        PrintStream stream = this.getPrintStream();
        stream.print(value);
    }

    private void printLabel(String label) {
        if (label != null) {
            this.print(label);
        }
    }

    @Override
    public void println(Object value) {
        PrintStream stream = this.getPrintStream();
        stream.println(value);
    }

    private void printOn(StringBuffer buffer) {
        this.printPrintStreamOn(buffer);
        this.printReaderOn(buffer);
    }

    private void printPrintStreamOn(StringBuffer buffer) {
        PrintStream printStream = this.getPrintStream();
        String value = StringUtility.toFormattedBinaryString("printStream", printStream);
        buffer.append(value);
    }

    private void printReaderOn(StringBuffer buffer) {
        BufferedReader reader = this.getReader();
        String value = StringUtility.toFormattedBinaryString("reader", reader);
        buffer.append(value);
    }

    @Override
    public String readLine(String label) throws IOException {
        return this.readLine(label, NO_DEFAULT_VALUE);
    }

    @Override
    public String readLine(String label, String defaultValue) throws IOException {
        this.checkDefaultValue(defaultValue);
        this.printLabel(label);
        BufferedReader reader = this.getReader();
        String line = reader.readLine();
        if (line == null) {
            return defaultValue;
        }
        if (line.isEmpty()) {
            return defaultValue;
        }
        return line;
    }

    @Override
    public String readSensitiveLine(String label) throws IOException {
        return this.readSensitiveLine(label, NO_DEFAULT_VALUE);
    }

    @Override
    public String readSensitiveLine(String label, String defaultValue) throws IOException {
        Console console = System.console();
        if (console == null) {
            return this.readLine(label, defaultValue);
        }
        this.checkDefaultValue(defaultValue);
        this.printLabel(label);
        char[] characters = console.readPassword();
        return new String(characters);
    }

    private void setPrintStream(PrintStream printStream) {
        this.printStream = printStream;
    }

    private void setReader(BufferedReader reader) {
        this.reader = reader;
    }

    public String toString() {
        String value = super.toString();
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(value);
        this.printOn(buffer);
        return buffer.toString();
    }
}

