/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common.internal.util;

import com.sas.solstice.platform.application.common.api.IHierarchicalNode;
import com.sas.solstice.platform.application.common.api.IIdentifiable;
import com.sas.solstice.platform.application.common.internal.util.StringUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class HierarchicalNode<T extends IIdentifiable>
implements IHierarchicalNode<T> {
    private static final char INDENT_CHAR = '\t';
    private static final char NEWLINE = '\n';
    private T subject;
    private List<IHierarchicalNode<T>> descendents;

    HierarchicalNode(T subject, int size) {
        if (subject == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        if (size < 0) {
            throw new IllegalArgumentException("size must be greater than or equal to zero");
        }
        this.setSubject(subject);
        this.setDescendents(new ArrayList<IHierarchicalNode<T>>(size));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addChild(IHierarchicalNode<T> child) {
        List<IHierarchicalNode<T>> children;
        if (child == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        if (child == this) {
            return false;
        }
        List<IHierarchicalNode<T>> list = children = this.getDescendents();
        synchronized (list) {
            boolean exists = children.contains(child);
            if (exists) {
                return false;
            }
            children.add(child);
        }
        return true;
    }

    private String createIndentation(int indent) {
        char[] chars = new char[indent];
        Arrays.fill(chars, '\t');
        return new String(chars);
    }

    private void displayChildrenOn(StringBuffer buffer, IHierarchicalNode<T> parent, int level) {
        List<IHierarchicalNode<T>> children = parent.getChildren();
        this.displayOn(buffer, children, level + 1);
    }

    private void displayOn(StringBuffer buffer) {
        this.displayOn(buffer, this, 0);
    }

    private void displayOn(StringBuffer buffer, IHierarchicalNode<T> node, int level) {
        String indentation = this.createIndentation(level);
        buffer.append(indentation);
        T subject = node.getSubject();
        buffer.append(subject);
        buffer.append('\n');
        this.displayChildrenOn(buffer, node, level);
    }

    private void displayOn(StringBuffer buffer, List<IHierarchicalNode<T>> nodes, int level) {
        for (IHierarchicalNode<T> node : nodes) {
            this.displayOn(buffer, node, level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IHierarchicalNode<T>> getChildren() {
        List<IHierarchicalNode<T>> list;
        List<IHierarchicalNode<T>> list2 = list = this.getDescendents();
        synchronized (list2) {
            return new ArrayList<IHierarchicalNode<T>>(list);
        }
    }

    private List<IHierarchicalNode<T>> getDescendents() {
        return this.descendents;
    }

    @Override
    public T getSubject() {
        return this.subject;
    }

    private void printDescendentsOn(StringBuffer buffer) {
        List<IHierarchicalNode<T>> descendents = this.getDescendents();
        int size = descendents.size();
        String value = StringUtility.toFormattedBinaryString("descendents", size);
        buffer.append(value);
    }

    private void printOn(StringBuffer buffer) {
        this.printSubjectOn(buffer);
        this.printDescendentsOn(buffer);
    }

    private void printSubjectOn(StringBuffer buffer) {
        T subject = this.getSubject();
        String value = StringUtility.toFormattedBinaryString("subject", subject);
        buffer.append(value);
    }

    private void setDescendents(List<IHierarchicalNode<T>> descendents) {
        this.descendents = descendents;
    }

    private void setSubject(T subject) {
        this.subject = subject;
    }

    @Override
    public String toDisplayString() {
        List<IHierarchicalNode<T>> children = this.getDescendents();
        int estimate = 75 + children.size() * 25;
        StringBuffer buffer = new StringBuffer(estimate);
        this.displayOn(buffer);
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(75);
        String value = super.toString();
        buffer.append(value);
        this.printOn(buffer);
        return buffer.toString();
    }
}

