/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common.internal.util;

import com.sas.solstice.platform.application.common.api.IComposable;
import com.sas.solstice.platform.application.common.internal.util.StringUtility;
import com.sas.solstice.platform.application.common.internal.util.api.IGenericComposite;
import java.util.ArrayList;
import java.util.List;

public class GenericComposite<T extends IComposable>
implements IGenericComposite<T> {
    private List<T> composables;
    private String name;

    public GenericComposite(String name, int size) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (size < 0) {
            throw new IllegalArgumentException("size must be a positive integer");
        }
        this.setName(name);
        this.setComposables(new ArrayList(size));
    }

    public GenericComposite(String name, T ... composables) {
        this(name, composables.length);
        super.addAll(composables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T composable) {
        List<T> composables;
        this.checkComposable(composable);
        if (composable == this) {
            return false;
        }
        List<T> list = composables = this.basicGetComposables();
        synchronized (list) {
            boolean exists = composables.contains(composable);
            if (exists) {
                return false;
            }
            composables.add(composable);
        }
        return true;
    }

    private void addAll(T[] composables) {
        for (T composable : composables) {
            this.add(composable);
        }
    }

    private List<T> basicGetComposables() {
        return this.composables;
    }

    private void checkComposable(T composable) {
        if (composable != null) {
            return;
        }
        throw new IllegalArgumentException("composable must not be null");
    }

    @Override
    public List<T> getComposables() {
        List<T> composables = this.basicGetComposables();
        return new ArrayList<T>(composables);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    private void printComposablesOn(StringBuffer buffer) {
        List<T> composables = this.basicGetComposables();
        String value = StringUtility.toFormattedBinaryString("composables", composables);
        buffer.append(value);
    }

    private void printNameOn(StringBuffer buffer) {
        String name = this.getName();
        String value = StringUtility.toFormattedBinaryString("name", name);
        buffer.append(value);
    }

    private void printOn(StringBuffer buffer) {
        this.printNameOn(buffer);
        this.printComposablesOn(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(T composable) {
        List<T> composables;
        this.checkComposable(composable);
        List<T> list = composables = this.basicGetComposables();
        synchronized (list) {
            return composables.remove(composable);
        }
    }

    private void setComposables(List<T> composables) {
        this.composables = composables;
    }

    private void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        List<T> composables;
        List<T> list = composables = this.getComposables();
        synchronized (list) {
            return composables.size();
        }
    }

    public String toString() {
        String value = super.toString();
        StringBuffer buffer = new StringBuffer(75);
        buffer.append(value);
        this.printOn(buffer);
        return buffer.toString();
    }
}

