/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common.internal.command;

import com.sas.solstice.platform.application.common.api.command.ICommand;
import com.sas.solstice.platform.application.common.api.command.ICommandProvider;
import com.sas.solstice.platform.application.common.api.command.IParameterSpecification;
import java.util.List;

class CommandUsageGenerator {
    private static final String COMMAND_TEMPLATE = "-%s  %s";
    private static final String PARAMETER_TEMPLATE = "  <%s>  %s";
    private static final char NEWLINE = '\n';

    CommandUsageGenerator() {
    }

    public String generate(ICommandProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider must not be null");
        }
        List<ICommand<?>> commands = provider.getAll();
        int size = commands.size() * 100;
        StringBuffer buffer = new StringBuffer(size);
        this.generateUsageOn(commands, buffer);
        return buffer.toString();
    }

    private void generateUsageOn(ICommand<?> command, StringBuffer buffer) {
        boolean available = command.isAvailable();
        if (!available) {
            return;
        }
        this.printUsageOn(command, buffer);
        IParameterSpecification specification = command.getParameterSpecification();
        this.printUsageOn(specification, buffer);
    }

    private void generateUsageOn(List<ICommand<?>> commands, StringBuffer buffer) {
        for (ICommand<?> command : commands) {
            this.generateUsageOn(command, buffer);
        }
    }

    private void printUsageOn(ICommand<?> command, StringBuffer buffer) {
        String id = command.getId();
        String usage = command.getUsage();
        String line = String.format(COMMAND_TEMPLATE, id, usage);
        buffer.append(line);
        buffer.append('\n');
    }

    private void printUsageOn(IParameterSpecification.IParameter parameter, StringBuffer buffer) {
        String name = parameter.getName();
        String usage = parameter.getUsage();
        String line = String.format(PARAMETER_TEMPLATE, name, usage);
        buffer.append(line);
        buffer.append('\n');
    }

    private void printUsageOn(IParameterSpecification specification, StringBuffer buffer) {
        List<String> ids = specification.getIds();
        for (String id : ids) {
            IParameterSpecification.IParameter parameter = specification.getParameter(id);
            this.printUsageOn(parameter, buffer);
        }
    }
}

