/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common.internal.command;

import com.sas.solstice.platform.application.common.api.command.ICommand;
import com.sas.solstice.platform.application.common.api.command.ICommandProvider;
import com.sas.solstice.platform.application.common.api.command.ICommandRegistrar;
import com.sas.solstice.platform.application.common.internal.command.CommandUsageGenerator;
import com.sas.solstice.platform.application.common.internal.util.GenericRegistry;
import com.sas.solstice.platform.application.common.internal.util.api.IGenericRegistry;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandRegistry
implements ICommandRegistrar,
ICommandProvider {
    private static CommandRegistry instance;
    private static final Logger LOGGER;
    private IGenericRegistry<ICommand<?>> registry;

    public static CommandRegistry getInstance() {
        if (instance == null) {
            throw new IllegalStateException("CommandRegistry has not been instanciated by DS");
        }
        return instance;
    }

    private static void logError(String message) {
        LOGGER.error(message);
    }

    private static void setInstance(CommandRegistry instance) {
        CommandRegistry.instance = instance;
    }

    public CommandRegistry() {
        this.setRegistry(new GenericRegistry(53));
        CommandRegistry.setInstance(this);
    }

    @Override
    public ICommand<?> get(String id) {
        String formattedId = this.toFormattedId(id);
        IGenericRegistry<ICommand<?>> registry = this.getRegistry();
        return registry.get(formattedId);
    }

    @Override
    public List<ICommand<?>> getAll() {
        IGenericRegistry<ICommand<?>> registry = this.getRegistry();
        List<ICommand<?>> list = registry.getAll();
        return list;
    }

    private IGenericRegistry<ICommand<?>> getRegistry() {
        return this.registry;
    }

    @Override
    public String getUsage() {
        CommandUsageGenerator generator = new CommandUsageGenerator();
        return generator.generate(this);
    }

    @Override
    public void register(ICommand<?> command) {
        IGenericRegistry<ICommand<?>> registry = this.getRegistry();
        boolean status = registry.register(command);
        if (status) {
            return;
        }
        String id = command.getId();
        String message = String.format("Failed to register the command with the id \"%s\".", id);
        CommandRegistry.logError(message);
    }

    private void setRegistry(IGenericRegistry<ICommand<?>> registry) {
        this.registry = registry;
    }

    private String toFormattedId(String id) {
        if (id == null) {
            return null;
        }
        String value = id.trim();
        if (value.isEmpty()) {
            return value;
        }
        while (value.charAt(0) == '-') {
            value = value.substring(1);
        }
        return value;
    }

    @Override
    public void unregister(ICommand<?> command) {
        IGenericRegistry<ICommand<?>> registry = this.getRegistry();
        boolean status = registry.unregister(command);
        if (status) {
            return;
        }
        String id = command.getId();
        String message = String.format("Failed to unregister the command with the id \"%s\".", id);
        CommandRegistry.logError(message);
    }

    static {
        LOGGER = LogManager.getLogger(CommandRegistry.class);
    }
}

