/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common.command.parameter;

import com.sas.solstice.platform.application.common.api.command.IParameterSpecification;
import com.sas.solstice.platform.application.common.api.command.ParameterSpecificationException;
import com.sas.solstice.platform.application.common.command.parameter.AbstractParameterAdvisor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParameterSpecification
implements IParameterSpecification {
    private List<IParameterSpecification.IParameter> parameters;
    private IParameterSpecification.IParameterAdvisor advisor;

    public ParameterSpecification() {
        this.setParameters(new ArrayList<IParameterSpecification.IParameter>(3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(IParameterSpecification.IParameter parameter) {
        List<IParameterSpecification.IParameter> parameters;
        if (parameter == null) {
            throw new IllegalArgumentException("parameter must not be null");
        }
        String id = parameter.getId();
        if (id == null) {
            throw new IllegalArgumentException("parameter's id must not be null");
        }
        List<IParameterSpecification.IParameter> list = parameters = this.getParameters();
        synchronized (list) {
            boolean exists = this.exists(parameter);
            if (exists) {
                return false;
            }
            return parameters.add(parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> apply(IParameterSpecification.IParameterValuesProvider provider) throws ParameterSpecificationException {
        List<IParameterSpecification.IParameter> parameters = this.getParameters();
        int size = parameters.size();
        Map<String, String> map = this.createMap(size);
        List<IParameterSpecification.IParameter> list = parameters;
        synchronized (list) {
            this.apply(provider, parameters, map);
        }
        return map;
    }

    private void apply(IParameterSpecification.IParameterValuesProvider provider, IParameterSpecification.IParameter parameter, Map<String, String> map) throws ParameterSpecificationException {
        boolean required = this.isParameterRequired(parameter);
        if (!required) {
            return;
        }
        provider.apply(parameter);
        this.store(parameter, map);
    }

    private void apply(IParameterSpecification.IParameterValuesProvider provider, List<IParameterSpecification.IParameter> parameters, Map<String, String> map) throws ParameterSpecificationException {
        if (provider == null) {
            return;
        }
        for (IParameterSpecification.IParameter parameter : parameters) {
            this.apply(provider, parameter, map);
        }
    }

    private int calcuateHashedCollectionSizeEstimate(int capacity) {
        if (capacity <= 0) {
            return 0;
        }
        int size = capacity * 4 / 3 + 1;
        return size;
    }

    private Map<String, String> createMap(int capacity) {
        int size = this.calcuateHashedCollectionSizeEstimate(capacity);
        return new HashMap<String, String>(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exists(IParameterSpecification.IParameter parameter) {
        List<IParameterSpecification.IParameter> parameters;
        List<IParameterSpecification.IParameter> list = parameters = this.getParameters();
        synchronized (list) {
            boolean exists = parameters.contains(parameter);
            if (exists) {
                return true;
            }
            String id = parameter.getId();
            boolean bl = this.getParameter(id) != null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IParameterSpecification.IParameterAdvisor getAdvisor() {
        ParameterSpecification parameterSpecification = this;
        synchronized (parameterSpecification) {
            if (this.advisor == null) {
                this.setAdvisor(new DefaultParameterAdvisor());
            }
            return this.advisor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getIds() {
        ArrayList<String> list;
        List<IParameterSpecification.IParameter> parameters;
        List<IParameterSpecification.IParameter> list2 = parameters = this.getParameters();
        synchronized (list2) {
            int size = parameters.size();
            list = new ArrayList<String>(size);
            for (IParameterSpecification.IParameter parameter : parameters) {
                String id = parameter.getId();
                list.add(id);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IParameterSpecification.IParameter getParameter(String id) {
        List<IParameterSpecification.IParameter> parameters;
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        List<IParameterSpecification.IParameter> list = parameters = this.getParameters();
        synchronized (list) {
            for (IParameterSpecification.IParameter each : parameters) {
                String eachId = each.getId();
                boolean exists = eachId.equals(id);
                if (!exists) continue;
                return each;
            }
        }
        return null;
    }

    private List<IParameterSpecification.IParameter> getParameters() {
        return this.parameters;
    }

    private boolean isParameterRequired(IParameterSpecification.IParameter parameter) {
        IParameterSpecification.IParameterAdvisor advisor = this.getAdvisor();
        return advisor.isRequired(this, parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAdvisor(IParameterSpecification.IParameterAdvisor advisor) {
        ParameterSpecification parameterSpecification = this;
        synchronized (parameterSpecification) {
            this.advisor = advisor;
        }
    }

    private void setParameters(List<IParameterSpecification.IParameter> parameters) {
        this.parameters = parameters;
    }

    private void store(IParameterSpecification.IParameter parameter, Map<String, String> map) {
        String key = parameter.getId();
        String value = parameter.getValue();
        map.put(key, value);
    }

    private static class DefaultParameterAdvisor
    extends AbstractParameterAdvisor {
        private DefaultParameterAdvisor() {
        }

        @Override
        public boolean isRequired(IParameterSpecification specification, IParameterSpecification.IParameter parameter) {
            return true;
        }
    }
}

