/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common.command.parameter;

import com.sas.solstice.platform.application.common.api.command.IParameterSpecification;
import com.sas.solstice.platform.application.common.api.command.ParameterSpecificationException;
import com.sas.solstice.platform.application.common.command.validator.AbstractParameterValidator;
import com.sas.solstice.platform.application.common.internal.util.StringUtility;

public class Parameter
implements IParameterSpecification.IParameter {
    private String id;
    private String name;
    private String defaultValue;
    private String value;
    private boolean sensitive;
    private IParameterSpecification.IParameterValidator validator;
    private String usage;
    private boolean validating;

    public Parameter(String id, String name) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.setId(id);
        this.setName(name);
    }

    private void checkForRecursiveValidation() {
        boolean validating = this.isValidating();
        if (!validating) {
            return;
        }
        this.signalRecursiveValidationDetected();
    }

    private String getDefaultUsage() {
        String name = this.getName();
        return String.format("The \"%s\" parameter", name);
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUsage() {
        if (this.usage == null) {
            return this.getDefaultUsage();
        }
        return this.usage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IParameterSpecification.IParameterValidator getValidator() {
        Parameter parameter = this;
        synchronized (parameter) {
            if (this.validator == null) {
                this.setValidator(new DefaultParameterValidator());
            }
            return this.validator;
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isSensitive() {
        return this.sensitive;
    }

    private boolean isValidating() {
        return this.validating;
    }

    private void printDefaultValueOn(StringBuffer buffer) {
        String defaultValue = this.getDefaultValue();
        String value = StringUtility.toFormattedBinaryString("defaultValue", defaultValue);
        buffer.append(value);
    }

    private void printIdOn(StringBuffer buffer) {
        String id = this.getId();
        String value = StringUtility.toFormattedBinaryString("id", id);
        buffer.append(value);
    }

    private void printNameOn(StringBuffer buffer) {
        String name = this.getName();
        String value = StringUtility.toFormattedBinaryString("name", name);
        buffer.append(value);
    }

    private void printOn(StringBuffer buffer) {
        this.printIdOn(buffer);
        this.printNameOn(buffer);
        this.printValueOn(buffer);
        this.printDefaultValueOn(buffer);
        this.printSensitiveOn(buffer);
        this.printValidatorOn(buffer);
        this.printUsageOn(buffer);
    }

    private void printSensitiveOn(StringBuffer buffer) {
        boolean sensitive = this.isSensitive();
        String value = StringUtility.toFormattedBinaryString("sensitive", sensitive);
        buffer.append(value);
    }

    private void printUsageOn(StringBuffer buffer) {
        String usage = this.getUsage();
        String value = StringUtility.toFormattedBinaryString("usage", usage);
        buffer.append(value);
    }

    private void printValidatorOn(StringBuffer buffer) {
        IParameterSpecification.IParameterValidator validator = this.getValidator();
        String value = StringUtility.toFormattedBinaryString("validator", validator);
        buffer.append(value);
    }

    private void printValueOn(StringBuffer buffer) {
        String value = this.getValue();
        String formattedValue = StringUtility.toFormattedBinaryString("value", value);
        buffer.append(formattedValue);
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    private void setId(String id) {
        this.id = id;
    }

    private void setName(String name) {
        this.name = name;
    }

    @Override
    public void setSensitive(boolean sensitive) {
        this.sensitive = sensitive;
    }

    @Override
    public void setUsage(String usage) {
        this.usage = usage;
    }

    private void setValidating(boolean validating) {
        this.validating = validating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setValidator(IParameterSpecification.IParameterValidator validator) {
        Parameter parameter = this;
        synchronized (parameter) {
            this.validator = validator;
        }
    }

    @Override
    public void setValue(String value) throws ParameterSpecificationException {
        this.value = this.toValidValue(value);
    }

    private void signalRecursiveValidationDetected() {
        String id = this.getId();
        IParameterSpecification.IParameterValidator validator = this.getValidator();
        String message = String.format("recursive validation of the \"%s\" parameter has been detected; validator=\"%s\"", id, validator);
        throw new IllegalStateException(message);
    }

    public String toString() {
        String value = super.toString();
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(value);
        this.printOn(buffer);
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toValidValue(String value) throws ParameterSpecificationException {
        Parameter parameter = this;
        synchronized (parameter) {
            String string;
            this.checkForRecursiveValidation();
            IParameterSpecification.IParameterValidator validator = this.getValidator();
            this.setValidating(true);
            try {
                string = validator.validate(value, this);
                this.setValidating(false);
            }
            catch (Throwable throwable) {
                this.setValidating(false);
                throw throwable;
            }
            return string;
        }
    }

    private static class DefaultParameterValidator
    extends AbstractParameterValidator {
        private DefaultParameterValidator() {
        }

        @Override
        public String validate(String value, IParameterSpecification.IParameter parameter) throws ParameterSpecificationException {
            return value;
        }
    }
}

