/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common.command.parameter;

import com.sas.solstice.platform.application.common.api.command.IParameterSpecification;
import com.sas.solstice.platform.application.common.api.command.ParameterSpecificationException;
import java.util.List;

public class ListParameterValuesProvider
implements IParameterSpecification.IParameterValuesProvider {
    private List<String> arguments;

    public ListParameterValuesProvider(List<String> arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException("arguments must not be null");
        }
        this.setArguments(arguments);
    }

    @Override
    public void apply(IParameterSpecification.IParameter parameter) throws ParameterSpecificationException {
        String value = this.getNextArgument();
        if (value == null) {
            this.signalMissingValue(parameter);
        }
        parameter.setValue(value);
    }

    private List<String> getArguments() {
        return this.arguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNextArgument() throws ParameterSpecificationException {
        List<String> arguments;
        List<String> list = arguments = this.getArguments();
        synchronized (list) {
            boolean empty = arguments.isEmpty();
            if (empty) {
                return null;
            }
            return arguments.remove(0);
        }
    }

    private void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    private void signalMissingValue(IParameterSpecification.IParameter parameter) throws ParameterSpecificationException {
        String name = parameter.getName();
        String message = String.format("Error: The \"%s\" parameter is missing.", name);
        throw new ParameterSpecificationException(message);
    }
}

