/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common.command.parameter;

import com.sas.solstice.platform.application.common.api.IConsole;
import com.sas.solstice.platform.application.common.api.command.IParameterSpecification;
import com.sas.solstice.platform.application.common.api.command.ParameterSpecificationException;
import com.sas.solstice.platform.application.common.internal.util.SystemConsole;
import java.io.IOException;

public class ConsoleParameterValuesProvider
implements IParameterSpecification.IParameterValuesProvider {
    private static final String EMPTY_STRING = "";
    private IConsole console;

    @Override
    public void apply(IParameterSpecification.IParameter parameter) throws ParameterSpecificationException {
        String message = this.createPrompt(parameter);
        String defaultValue = parameter.getDefaultValue();
        boolean sensitive = parameter.isSensitive();
        boolean valid = false;
        while (!valid) {
            try {
                String value = this.readLine(message, defaultValue, sensitive);
                valid = this.apply(parameter, value);
            }
            catch (IOException exception) {
                throw new ParameterSpecificationException("failed to read value", exception);
            }
        }
    }

    private boolean apply(IParameterSpecification.IParameter parameter, String value) {
        boolean valid = true;
        try {
            parameter.setValue(value);
        }
        catch (ParameterSpecificationException exception) {
            valid = false;
            String errorMessage = exception.getMessage();
            this.println(errorMessage);
        }
        return valid;
    }

    private String createPrompt(IParameterSpecification.IParameter parameter) {
        String name = parameter.getName();
        boolean sensitive = parameter.isSensitive();
        String defaultValue = sensitive ? null : parameter.getDefaultValue();
        return this.createPrompt(name, defaultValue);
    }

    private String createPrompt(String name, String defaultValue) {
        if (defaultValue != null) {
            return String.format("%s [%s]: ", name, defaultValue);
        }
        return String.format("%s: ", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IConsole getConsole() {
        ConsoleParameterValuesProvider consoleParameterValuesProvider = this;
        synchronized (consoleParameterValuesProvider) {
            if (this.console == null) {
                this.setConsole(new SystemConsole());
            }
            return this.console;
        }
    }

    private void println(Object object) {
        IConsole console = this.getConsole();
        console.println(object);
    }

    private String readLine(String message, String defaultValue) throws IOException {
        IConsole console = this.getConsole();
        String validDefaultValue = EMPTY_STRING;
        if (defaultValue != null) {
            validDefaultValue = defaultValue;
        }
        return console.readLine(message, validDefaultValue);
    }

    private String readLine(String message, String defaultValue, boolean sensitive) throws IOException {
        if (sensitive) {
            return this.readSensitiveLine(message, defaultValue);
        }
        return this.readLine(message, defaultValue);
    }

    private String readSensitiveLine(String message, String defaultValue) throws IOException {
        IConsole console = this.getConsole();
        String validDefaultValue = EMPTY_STRING;
        if (defaultValue != null) {
            validDefaultValue = defaultValue;
        }
        return console.readSensitiveLine(message, validDefaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConsole(IConsole console) {
        ConsoleParameterValuesProvider consoleParameterValuesProvider = this;
        synchronized (consoleParameterValuesProvider) {
            this.console = console;
        }
    }
}

