/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common.command.parameter;

import com.sas.solstice.platform.application.common.api.command.IParameterSpecification;
import com.sas.solstice.platform.application.common.api.command.ParameterSpecificationException;
import com.sas.solstice.platform.application.common.command.parameter.ListParameterValuesProvider;
import java.util.ArrayList;
import java.util.List;

public class ArrayParameterValuesProvider
implements IParameterSpecification.IParameterValuesProvider {
    private IParameterSpecification.IParameterValuesProvider provider;

    public ArrayParameterValuesProvider(String ... arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException("arguments must not be null");
        }
        this.setProvider(this.createProvider(arguments));
    }

    @Override
    public void apply(IParameterSpecification.IParameter parameter) throws ParameterSpecificationException {
        IParameterSpecification.IParameterValuesProvider provider = this.getProvider();
        provider.apply(parameter);
    }

    private IParameterSpecification.IParameterValuesProvider createProvider(String[] arguments) {
        List<String> list = this.toList(arguments);
        return new ListParameterValuesProvider(list);
    }

    private IParameterSpecification.IParameterValuesProvider getProvider() {
        return this.provider;
    }

    private void setProvider(IParameterSpecification.IParameterValuesProvider provider) {
        this.provider = provider;
    }

    private List<String> toList(String[] arguments) {
        ArrayList<String> list = new ArrayList<String>(arguments.length);
        for (String argument : arguments) {
            list.add(argument);
        }
        return list;
    }
}

