/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common.command;

import com.sas.solstice.platform.application.common.api.IApplicationModel;
import com.sas.solstice.platform.application.common.api.command.ICommandProvider;
import com.sas.solstice.platform.application.common.command.AbstractCommand;
import java.util.Map;

public class UsageCommand<T extends IApplicationModel>
extends AbstractCommand<T> {
    private static final char NEWLINE = '\n';
    private ICommandProvider commandProvider;

    public UsageCommand(ICommandProvider commandProvider) {
        if (commandProvider == null) {
            throw new IllegalArgumentException("commandProvider must not be null");
        }
        this.setCommandProvider(commandProvider);
    }

    @Override
    public final int execute(T model, Map<String, String> parameters) {
        String usage = this.generateUsage(model);
        this.handleGeneratedUsage(model, usage);
        return 0;
    }

    protected final void generateCommandUsageOn(T model, StringBuffer buffer) {
        String usage = this.getCommandUsage(model);
        buffer.append(usage);
    }

    protected final void generateTitleOn(T model, StringBuffer buffer) {
        String title = this.getTitle(model);
        if (title == null) {
            return;
        }
        String line = this.toFormattedTitle(title);
        buffer.append(line);
        buffer.append('\n');
        buffer.append('\n');
    }

    private String generateUsage(T model) {
        StringBuffer buffer = new StringBuffer(500);
        this.generateUsageOn(model, buffer);
        return buffer.toString();
    }

    protected void generateUsageOn(T model, StringBuffer buffer) {
        this.generateTitleOn(model, buffer);
        this.generateCommandUsageOn(model, buffer);
    }

    private ICommandProvider getCommandProvider() {
        return this.commandProvider;
    }

    protected String getCommandUsage(T model) {
        ICommandProvider provider = this.getCommandProvider();
        return provider.getUsage();
    }

    protected String getDescription(T model, String description) {
        return description;
    }

    protected String getTitle(T model) {
        return model.getName();
    }

    protected void handleGeneratedUsage(T model, String usage) {
        model.println(usage);
    }

    private void setCommandProvider(ICommandProvider commandProvider) {
        this.commandProvider = commandProvider;
    }

    protected String toFormattedTitle(String title) {
        return String.format("Usage for the \"%s\"", title);
    }
}

