/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common;

import com.sas.solstice.platform.application.common.api.IApplication;
import com.sas.solstice.platform.application.common.api.IApplicationModel;
import com.sas.solstice.platform.application.common.api.command.CommandExecutionException;
import com.sas.solstice.platform.application.common.api.command.ICommand;
import com.sas.solstice.platform.application.common.api.command.ICommandProvider;
import com.sas.solstice.platform.application.common.api.command.IParameterSpecification;
import com.sas.solstice.platform.application.common.api.command.ParameterSpecificationException;
import com.sas.solstice.platform.application.common.api.menu.IMenu;
import com.sas.solstice.platform.application.common.api.menu.IMenuManager;
import com.sas.solstice.platform.application.common.command.parameter.ConsoleParameterValuesProvider;
import com.sas.solstice.platform.application.common.command.parameter.ListParameterValuesProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Application<T extends IApplicationModel>
implements IApplication {
    private static final char INDENT_CHAR = '\t';
    private static final char NEWLINE = '\n';
    private static final int RC_OK = 0;
    private static final String INTERACTIVE_ARGUMENT = "-interactive";
    private T model;
    private List<String> arguments;
    private IMenuManager menuManager;
    private volatile boolean running;

    public Application(T model, IMenuManager menuManager, String ... arguments) {
        if (model == null) {
            throw new IllegalArgumentException("model must not be null");
        }
        if (menuManager == null) {
            throw new IllegalArgumentException("menuManager must not be null");
        }
        this.setModel(model);
        this.setMenuManager(menuManager);
        this.setArguments(this.toList(arguments));
    }

    private String createIndentation(int indent) {
        char[] chars = new char[indent];
        Arrays.fill(chars, '\t');
        return new String(chars);
    }

    private int execute(ICommand<T> command, IParameterSpecification.IParameterValuesProvider provider) throws ParameterSpecificationException, CommandExecutionException {
        T model = this.getModel();
        Map<String, String> parameters = this.getParameters(command, provider);
        return command.execute(model, parameters);
    }

    private List<String> getArguments() {
        return this.arguments;
    }

    private ICommand<T> getAvailableCommand(String id) {
        ICommand<T> command;
        String commandId = id;
        if (id.equals("?") || id.equals("-?")) {
            commandId = "help";
        }
        if ((command = this.getCommand(commandId)) == null) {
            return null;
        }
        boolean available = command.isAvailable();
        if (!available) {
            return null;
        }
        return command;
    }

    private ICommand<T> getCommand(String id) {
        ICommandProvider provider = this.getCommandProvider();
        return provider.get(id);
    }

    private ICommandProvider getCommandProvider() {
        IMenuManager manager = this.getMenuManager();
        return manager.getCommandProvider();
    }

    private IMenuManager getMenuManager() {
        return this.menuManager;
    }

    private T getModel() {
        return this.model;
    }

    private Map<String, String> getParameters(ICommand<T> command, IParameterSpecification.IParameterValuesProvider provider) throws ParameterSpecificationException {
        IParameterSpecification specification = command.getParameterSpecification();
        return specification.apply(provider);
    }

    private void handleException(Throwable exception) {
        String message = this.toFormattedMessage(exception);
        this.println(message);
    }

    private int internalRun() throws ParameterSpecificationException, CommandExecutionException {
        boolean interactive = this.isInteractiveMode();
        if (interactive) {
            return this.runInInteractiveMode();
        }
        return this.runInHeadlessMode();
    }

    private boolean isInteractiveMode() {
        List<String> arguments = this.getArguments();
        return arguments != null && arguments.contains(INTERACTIVE_ARGUMENT);
    }

    private boolean isRunning() {
        return this.running;
    }

    private void logCommandNotFound(String id) {
        String message = String.format("The command \"%s\" could not be found!", id);
        this.println(message);
    }

    private void printExceptionOn(Throwable exception, StringBuffer buffer, int level) {
        if (exception == null) {
            return;
        }
        Object line = exception.getMessage();
        if (line == null) {
            line = exception;
        }
        String indentation = this.createIndentation(level);
        buffer.append(indentation);
        line = String.format("- %s", line);
        buffer.append(line);
        buffer.append('\n');
        Throwable cause = exception.getCause();
        this.printExceptionOn(cause, buffer, level + 1);
    }

    private void println(Object value) {
        System.out.println(value);
    }

    private int runInHeadlessMode() throws ParameterSpecificationException, CommandExecutionException {
        List<String> arguments = this.getArguments();
        while (!arguments.isEmpty()) {
            String id = arguments.remove(0);
            ICommand<T> command = this.getAvailableCommand(id);
            if (command == null) {
                this.logCommandNotFound(id);
                return -1;
            }
            ListParameterValuesProvider provider = new ListParameterValuesProvider(arguments);
            int rc = this.execute(command, provider);
            if (rc == 0) continue;
            return rc;
        }
        return 0;
    }

    private int runInInteractiveMode() {
        String id;
        ConsoleParameterValuesProvider provider = new ConsoleParameterValuesProvider();
        while (this.isRunning() && !(id = this.selectFromMenu()).equals("com.sas.solstice.platform.application.common.api.menu.quit")) {
            ICommand<T> command = this.getAvailableCommand(id);
            if (command == null) {
                this.logCommandNotFound(id);
                continue;
            }
            try {
                int rc = this.execute(command, provider);
                if (rc == 0) continue;
                String message = String.format("The command \"%s\" exited with the return code %d.", id, rc);
                this.println(message);
            }
            catch (CommandExecutionException exception) {
                this.handleException(exception);
            }
            catch (ParameterSpecificationException exception) {
                this.handleException(exception);
            }
            catch (IllegalArgumentException exception) {
                this.handleException(exception);
            }
        }
        return 0;
    }

    private String selectFromMenu() {
        IMenuManager manager = this.getMenuManager();
        IMenu menu = manager.select();
        if (menu == null) {
            return null;
        }
        return menu.getCommandId();
    }

    private void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    private void setMenuManager(IMenuManager menuManager) {
        this.menuManager = menuManager;
    }

    private void setModel(T model) {
        this.model = model;
    }

    private void setRunning(boolean running) {
        this.running = running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int start() {
        int rc = -1;
        Application application = this;
        synchronized (application) {
            if (this.isRunning()) {
                return 0;
            }
            this.setRunning(true);
            try {
                rc = this.internalRun();
            }
            catch (ParameterSpecificationException exception) {
                this.handleException(exception);
            }
            catch (CommandExecutionException exception) {
                this.handleException(exception);
            }
            finally {
                this.setRunning(false);
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int stop() {
        Application application = this;
        synchronized (application) {
            if (!this.isRunning()) {
                return 0;
            }
            this.setRunning(false);
        }
        return 0;
    }

    private String toFormattedMessage(Throwable exception) {
        StringBuffer buffer = new StringBuffer(100);
        this.printExceptionOn(exception, buffer, 0);
        return buffer.toString();
    }

    private List<String> toList(String[] values) {
        if (values == null || values.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(values.length);
        for (String value : values) {
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }
}

