/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.property.internal.bundle;

import com.sas.deployment.property.internal.PropertyManager;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public class Component {
    private PropertyManager propertyManager;

    public void activate() {
        System.out.println("Component activating.");
        Properties properties = System.getProperties();
        this.propertyManager = new PropertyManager(properties);
        this.loadUserProperties();
    }

    public void deactivate() {
        this.propertyManager.unloadAll();
        this.propertyManager = null;
        System.out.println("Component deactivated.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUserProperties() {
        String propertyFile = System.getProperty("solstice.input.properties");
        if (propertyFile == null) {
            return;
        }
        try (FileInputStream stream = new FileInputStream(propertyFile);
             InputStreamReader reader = new InputStreamReader((InputStream)stream, "UTF-8");){
            this.propertyManager.load(reader);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }
}

