/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.property.internal;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertyManager {
    private Properties _targetProperties;
    private Map<String, ChangeRecord> _changeRecords;

    public PropertyManager(Properties targetProperties) {
        this.checkObjectIsNotNull(targetProperties);
        this._targetProperties = targetProperties;
        this._changeRecords = new HashMap<String, ChangeRecord>(31);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Reader reader) throws IOException {
        this.checkObjectIsNotNull(reader);
        PropertyManager propertyManager = this;
        synchronized (propertyManager) {
            this.loadProperties(reader);
        }
    }

    private void loadProperties(Reader reader) throws IOException {
        Properties properties = this.createProperties(reader);
        this.commitProperties(properties);
    }

    private Properties createProperties(Reader reader) throws IOException {
        Properties properties = new Properties();
        properties.load(reader);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadAll() {
        PropertyManager propertyManager = this;
        synchronized (propertyManager) {
            this.unloadProperties();
        }
    }

    private void checkObjectIsNotNull(Object object) {
        if (object != null) {
            return;
        }
        throw new IllegalArgumentException("object must not be null");
    }

    private void commitProperties(Properties properties) {
        Set<String> keys = properties.stringPropertyNames();
        for (String key : keys) {
            String value = properties.getProperty(key);
            this.loadProperty(key, value);
        }
    }

    private void unloadProperties() {
        for (ChangeRecord record : this._changeRecords.values()) {
            this.unloadProperty(record);
        }
        this._changeRecords.clear();
    }

    private void unloadProperty(ChangeRecord record) {
        boolean unload = this.modifyProperty(record);
        if (!unload) {
            return;
        }
        String key = record.getKey();
        String originalValue = record.getOriginalValue();
        if (originalValue == null) {
            this._targetProperties.remove(key);
            return;
        }
        this._targetProperties.setProperty(key, originalValue);
    }

    private void loadProperty(String key, String value) {
        String existingValue = this._targetProperties.getProperty(key);
        if (!this.modifyProperty(key)) {
            return;
        }
        this._targetProperties.setProperty(key, value);
        this.recordChanges(key, value, existingValue);
    }

    private boolean modifyProperty(String key) {
        ChangeRecord record = this._changeRecords.get(key);
        return this.modifyProperty(record, key);
    }

    private boolean modifyProperty(ChangeRecord record) {
        String key = record.getKey();
        return this.modifyProperty(record, key);
    }

    private boolean modifyProperty(ChangeRecord record, String key) {
        String currentValue = this._targetProperties.getProperty(key);
        if (record == null) {
            return currentValue == null;
        }
        String assignedValue = record.getAssignedValue();
        return assignedValue.equals(currentValue);
    }

    private void recordChanges(String key, String value, String existingValue) {
        ChangeRecord record = this._changeRecords.get(key);
        if (record == null) {
            record = new ChangeRecord(key, existingValue);
            this._changeRecords.put(key, record);
        }
        record.setAssignedValue(value);
    }

    private static class ChangeRecord {
        private String _key;
        private String _originalValue;
        private String _assignedValue;

        ChangeRecord(String key, String originalValue) {
            this._key = key;
            this._originalValue = originalValue;
        }

        String getKey() {
            return this._key;
        }

        String getOriginalValue() {
            return this._originalValue;
        }

        String getAssignedValue() {
            return this._assignedValue;
        }

        void setAssignedValue(String assignedValue) {
            this._assignedValue = assignedValue;
        }
    }
}

