/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.config.app.commands.internal.windows;

import com.sas.deployment.config.app.api.IAgentConfigurationTool;
import com.sas.solstice.platform.application.common.api.command.IParameterSpecification;
import com.sas.solstice.platform.application.common.command.AbstractCommand;
import com.sas.solstice.platform.application.common.command.parameter.AbstractParameterAdvisor;
import com.sas.solstice.platform.application.common.command.parameter.Parameter;
import java.util.Map;

public class SetServiceUserCommand
extends AbstractCommand<IAgentConfigurationTool> {
    public static final String USERNAME_PARAMETER_ID = "wrapper.ntservice.account";
    public static final String PASSWORD_PARAMETER_ID = "wrapper.ntservice.password";
    private String decoration;

    @Override
    protected void buildParameterSpecification(IParameterSpecification specification) {
        IParameterSpecification.IParameter usernameParameter = this.createUsernameParameter();
        specification.add(usernameParameter);
        IParameterSpecification.IParameter passwordParameter = this.createPasswordParameter();
        specification.add(passwordParameter);
        ParameterAdvisor advisor = new ParameterAdvisor();
        specification.setAdvisor(advisor);
    }

    private IParameterSpecification.IParameter createPasswordParameter() {
        Parameter parameter = new Parameter(PASSWORD_PARAMETER_ID, "Service Password");
        parameter.setSensitive(true);
        parameter.setUsage("Set the service user password.");
        return parameter;
    }

    private IParameterSpecification.IParameter createUsernameParameter() {
        Parameter parameter = new Parameter(USERNAME_PARAMETER_ID, "Service User");
        parameter.setUsage("Set the service user.");
        return parameter;
    }

    @Override
    public int execute(IAgentConfigurationTool model, Map<String, String> parameters) {
        String username = parameters.get(USERNAME_PARAMETER_ID);
        String password = parameters.get(PASSWORD_PARAMETER_ID);
        model.setServiceUserCredentials(username, password);
        this.setDecoration(username);
        model.println("The credentials for the service user have been set.");
        model.print(Character.valueOf('\n'));
        return 0;
    }

    @Override
    public String getDecoration() {
        return this.decoration;
    }

    private void setDecoration(String decoration) {
        this.decoration = decoration;
    }

    private static class ParameterAdvisor
    extends AbstractParameterAdvisor {
        private ParameterAdvisor() {
        }

        private String getUsername(IParameterSpecification specification) {
            IParameterSpecification.IParameter parameter = specification.getParameter(SetServiceUserCommand.USERNAME_PARAMETER_ID);
            return parameter.getValue();
        }

        private boolean isPasswordParameter(IParameterSpecification.IParameter parameter) {
            String id = parameter.getId();
            return id.equals(SetServiceUserCommand.PASSWORD_PARAMETER_ID);
        }

        private boolean isPasswordRequired(IParameterSpecification specification) {
            String username = this.getUsername(specification);
            return !username.isEmpty();
        }

        @Override
        public boolean isRequired(IParameterSpecification specification, IParameterSpecification.IParameter parameter) {
            boolean required = true;
            if (this.isPasswordParameter(parameter)) {
                required = this.isPasswordRequired(specification);
            }
            return required;
        }
    }
}

