/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.config.app.commands.internal.windows;

import com.sas.deployment.config.app.api.IAgentConfigurationTool;
import com.sas.deployment.config.app.commands.internal.windows.AbstractTanukiCommand;
import java.util.List;

public class AddServiceCommand
extends AbstractTanukiCommand {
    private static final String WRAPPER_CONF_FILENAME = "wrapper.conf";
    private static final String INSTALL = "-i";

    private void addServiceUserParameters(IAgentConfigurationTool model, List<String> parameters) {
        IAgentConfigurationTool.IServiceUserCredentials credentials = model.getServiceUserCredentials();
        String username = credentials.getUsername();
        boolean empty = username.isEmpty();
        if (empty) {
            return;
        }
        parameters.add(WRAPPER_CONF_FILENAME);
        String usernameParameter = this.createUsernameParameter(credentials);
        parameters.add(usernameParameter);
        String passwordParameter = this.createPasswordParameter(credentials);
        parameters.add(passwordParameter);
    }

    @Override
    protected void collectParameters(IAgentConfigurationTool model, List<String> parameters) {
        parameters.add(INSTALL);
        this.addServiceUserParameters(model, parameters);
    }

    private String createPasswordParameter(IAgentConfigurationTool.IServiceUserCredentials credentials) {
        String value = credentials.getPassword();
        return this.toKeyValuePair("wrapper.ntservice.password", value);
    }

    private String createUsernameParameter(IAgentConfigurationTool.IServiceUserCredentials credentials) {
        String value = credentials.getUsername();
        return this.toKeyValuePair("wrapper.ntservice.account", value);
    }

    @Override
    protected void printExecutionStatusMessageOn(StringBuffer buffer, int rc, String stdout, String stderr) {
        String name = this.getServiceName();
        if (rc == 0) {
            String message = String.format("Successfully added the Windows Service \"%s\".", name);
            buffer.append(message);
            buffer.append('\n');
            return;
        }
        String message = String.format("Failed to add the Windows Service \"%s\".", name);
        buffer.append(message);
        buffer.append('\n');
        super.printExecutionStatusMessageOn(buffer, rc, stdout, stderr);
    }

    private String toKeyValuePair(String key, String value) {
        return String.format("\"%s=%s\"", key, value);
    }
}

