/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.config.app.commands.internal.util;

import com.sas.deployment.config.app.commands.internal.IExecutorStrategy;
import com.sas.deployment.config.app.commands.internal.util.ProcessStreamHandler;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RuntimeProcessExecutor
implements IExecutorStrategy {
    private static final Logger LOGGER = LogManager.getLogger(RuntimeProcessExecutor.class);

    private Process execute(String[] commands) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        return runtime.exec(commands);
    }

    @Override
    public int execute(String[] commands, OutputStream outputStream, OutputStream errorStream) throws IOException {
        boolean empty;
        if (commands == null) {
            throw new IllegalArgumentException("commands must not be null");
        }
        boolean bl = empty = commands.length == 0;
        if (empty) {
            throw new IllegalArgumentException("commands must not be empty");
        }
        Process process = this.execute(commands);
        return this.handleProcess(process, outputStream, errorStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int handleProcess(Process process, OutputStream stdoutStream, OutputStream stderrStream) {
        ProcessStreamHandler handler = new ProcessStreamHandler(process, stdoutStream, stderrStream);
        handler.start();
        try {
            int n = process.waitFor();
            return n;
        }
        catch (InterruptedException exception) {
            String message = exception.getMessage();
            this.logError(message);
            int n = -1;
            return n;
        }
        finally {
            handler.stop();
        }
    }

    private void logError(String message) {
        LOGGER.error(message);
    }
}

