/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.config.app.commands.internal.unix;

import com.sas.deployment.config.app.commands.internal.unix.AbstractShellScriptCommand;
import java.util.List;

public class StartCommand
extends AbstractShellScriptCommand {
    private static final String SAS_DEPLOYMENT_AGENT_FAILED_TO_START = "SAS Deployment Agent failed to start.";
    private static final String SAS_DEPLOYMENT_AGENT_STARTED_SUCCESSFULLY = "SAS Deployment Agent started successfully";

    @Override
    protected void collectShellTokens(List<String> tokens) {
        tokens.add("cd");
        tokens.add(this.buildWorkingDirectory());
        tokens.add("&&");
        tokens.add(this.buildScriptName());
        tokens.add("start");
    }

    @Override
    String getDefaultScriptName() {
        if (this.getPlatformName().startsWith("z/OS")) {
            return "agentadmin_zos.sh";
        }
        return "agentadmin.sh";
    }

    @Override
    protected void printExecutionStatusMessageOn(StringBuffer buffer, int rc, String stdout, String stderr) {
        if (rc == 0) {
            buffer.append(SAS_DEPLOYMENT_AGENT_STARTED_SUCCESSFULLY);
            buffer.append('\n');
            return;
        }
        buffer.append(SAS_DEPLOYMENT_AGENT_FAILED_TO_START);
        buffer.append('\n');
        super.printExecutionStatusMessageOn(buffer, rc, stdout, stderr);
    }
}

