/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.config.app.commands.internal.unix;

final class CommandUtils {
    private CommandUtils() {
        throw new IllegalStateException("CommandUtils contains class methods only.  Do not call constructor");
    }

    public static String createAbsolutePath(String root, String child) {
        if (root == null) {
            throw new IllegalArgumentException("root must not be null");
        }
        String separator = "/";
        StringBuilder builder = new StringBuilder(30);
        boolean absolute = root.startsWith(separator);
        if (!absolute) {
            builder.append(separator);
        }
        builder.append(root);
        boolean trailingSeparator = root.endsWith(separator);
        if (!trailingSeparator) {
            builder.append(separator);
        }
        if (child == null) {
            return builder.toString();
        }
        boolean invalid = child.startsWith(separator);
        if (invalid) {
            throw new IllegalArgumentException("child must not be absolute");
        }
        builder.append(child);
        trailingSeparator = child.endsWith(separator);
        if (!trailingSeparator) {
            builder.append(separator);
        }
        return builder.toString();
    }

    public static String getSystemProperty(String key, String defaultValue) {
        String value = System.getProperty(key, defaultValue);
        if (value != null) {
            return value;
        }
        String message = String.format("the property \"%s\" was not found", key);
        throw new IllegalStateException(message);
    }

    public static String validateProperty(String value) {
        if (value == null) {
            throw new IllegalArgumentException("property must not be null");
        }
        String key = value.trim();
        boolean empty = key.isEmpty();
        if (empty) {
            throw new IllegalArgumentException("property must not be empty");
        }
        return key;
    }
}

