/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.config.app.commands.internal.unix;

import com.sas.deployment.config.app.commands.internal.AbstractPlatformCommand;
import com.sas.solstice.platform.application.common.api.IApplicationModel;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractUnixShellCommand
extends AbstractPlatformCommand<IApplicationModel> {
    private static final String COMMAND_NAME = "/bin/sh";
    private static final String COMMAND_OPTION = "-c";
    protected static final String SINGLE_QUOTE_ARG = "'%s'";
    protected static final String DISCARD_STDOUT = "1>/dev/null";
    protected static final String REDIRECT_STDERR = "2>&1";
    protected static final String ECHO = "echo";
    protected static final String LAST_BACKGROUND_CMD_PID = "$!";
    protected static final String REDIRECT_TO = ">";
    protected static final String PID_FILE = ".pid";
    protected static final String AND_SHELL_CMD = "&&";
    protected static final String CMD_SEPERATOR = ";";
    protected static final String START_SUB_SHELL_GROUP = "(";
    protected static final String END_SUB_SHELL_GROUP = ")";
    protected static final String START_SHELL_GROUP = "{";
    protected static final String END_SHELL_GROUP = "}";

    AbstractUnixShellCommand() {
    }

    @Override
    protected void collectParameters(IApplicationModel model, List<String> parameters) {
        super.collectParameters(model, parameters);
        parameters.add(COMMAND_OPTION);
        String shellCmds = this.getShellCommands();
        parameters.add(shellCmds);
    }

    protected String getPlatformName() {
        return System.getProperty("os.name");
    }

    protected abstract void collectShellTokens(List<String> var1);

    @Override
    protected String getCommandName() {
        return COMMAND_NAME;
    }

    private String getShellCommands() {
        ArrayList<String> tokens = new ArrayList<String>(15);
        this.collectShellTokens(tokens);
        boolean empty = tokens.isEmpty();
        if (empty) {
            throw new IllegalStateException("tokens must not be empty");
        }
        StringBuilder builder = new StringBuilder(75);
        for (String token : tokens) {
            builder.append(token);
            builder.append(' ');
        }
        return builder.toString();
    }
}

