/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.config.app.commands.internal.jmx;

import com.sas.deployment.agent.jmx.client.api.IAgentMBeanProvider;
import com.sas.deployment.common.control.AgentMBean;
import com.sas.deployment.property.editor.IPropertyEditor;
import com.sas.solstice.platform.application.common.api.IApplicationModel;
import com.sas.solstice.platform.application.common.api.command.CommandExecutionException;
import com.sas.solstice.platform.application.common.command.AbstractCommand;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StopCommand
extends AbstractCommand<IApplicationModel> {
    private static final String LOCALHOST_NAME = "localhost";
    private static final Logger LOGGER = LogManager.getLogger(StopCommand.class);
    static final String AGENT_CONNECTION_ATTEMPT_FAILED = "Could not connect to SAS Deployment Agent on host \"%s\".";
    private static final String AGENT_SHUTDOWN = "SAS Deployment Agent on host \"%s\" has been shut down.";
    private static final String FAILED = "Could not shut down SAS Deployment Agent on host \"%s\".";
    private static final String AGENT_FAILED_DISCONNECT_ATTEMPT = "Disconnected from Agent during shutdown.";
    private static final String FALSE = "false";
    public static final String AGENT_SERVER_PORT_PROPERTY = "solstice.agent.jmx.port";
    static final String AGENT_SECURITY_ENABLED = "solstice.security.enabled";
    static final String AGENT_SECURITY_CLIENT_AUTH = "solstice.security.client.auth";
    static final String AGENT_SECURITY_KEYSTORE_PASS = "solstice.security.keystore.password";
    static final String AGENT_SECURITY_KEYSTORE = "solstice.security.keystore";
    static final String AGENT_SECURITY_TRUSTSTORE = "solstice.security.truststore";
    static final String AGENT_SECURITY_TRUSTSTORE_PASS = "solstice.security.truststore.password";
    private final IAgentMBeanProvider _agentMBeanProvider;
    private final IPropertyEditor _propertyEditor;
    private Properties securityProperties;

    public StopCommand(IAgentMBeanProvider agentMBeanProvider, IPropertyEditor editor) {
        if (agentMBeanProvider == null) {
            throw new IllegalArgumentException("agentMBeanProvider must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("editor must not be null");
        }
        this._agentMBeanProvider = agentMBeanProvider;
        this._propertyEditor = editor;
    }

    private AgentMBean connectToAgent(String host) throws IOException {
        IAgentMBeanProvider beanProvider = this.getBeanProvider();
        Properties properties = this.getSecurityProperties();
        return beanProvider.startAgent(host, properties);
    }

    private void disconnectFromAgent(String host) throws IOException {
        IAgentMBeanProvider beanProvider = this.getBeanProvider();
        beanProvider.stopAgent(host);
    }

    @Override
    public int execute(IApplicationModel model, Map<String, String> parameters) throws CommandExecutionException {
        if (model == null) {
            throw new IllegalArgumentException("model should not be null");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("parameters should not be null");
        }
        if (!parameters.isEmpty()) {
            throw new IllegalArgumentException("parameters should not be empty");
        }
        boolean result = this.shutdownAgent(LOCALHOST_NAME);
        int rc = result ? 0 : -1;
        this.logExecutionStatusMessage(model, rc);
        return rc;
    }

    IAgentMBeanProvider getBeanProvider() {
        return this._agentMBeanProvider;
    }

    IPropertyEditor getPropertyEditor() {
        return this._propertyEditor;
    }

    private String getRemoteAgentPort() {
        IPropertyEditor editor = this.getPropertyEditor();
        String port = editor.getProperty(AGENT_SERVER_PORT_PROPERTY);
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getSecurityProperties() {
        StopCommand stopCommand = this;
        synchronized (stopCommand) {
            Properties properties = this.loadSecurityProperties(this._propertyEditor);
            properties = this.validateSecurityProperties(properties);
            this.setSecurityProperties(properties);
            return this.securityProperties;
        }
    }

    static boolean isClientAuthEnabled(Properties p) {
        String value = p.getProperty(AGENT_SECURITY_CLIENT_AUTH, FALSE);
        Boolean enabled = Boolean.parseBoolean(value);
        return enabled;
    }

    static boolean isSecurityEnabled(Properties p) {
        String value = p.getProperty(AGENT_SECURITY_ENABLED, FALSE);
        Boolean enabled = Boolean.parseBoolean(value);
        return enabled;
    }

    Properties loadSecurityProperties(IPropertyEditor editor) {
        Properties properties = new Properties();
        String[] securityKeys = new String[]{AGENT_SECURITY_ENABLED, AGENT_SECURITY_CLIENT_AUTH, AGENT_SECURITY_KEYSTORE, AGENT_SECURITY_KEYSTORE_PASS};
        for (int i = 0; i < securityKeys.length; ++i) {
            String value = editor.getProperty(securityKeys[i]);
            if (value == null || value.isEmpty()) continue;
            properties.setProperty(securityKeys[i], value);
        }
        return properties;
    }

    private void logExecutionStatusMessage(IApplicationModel model, int rc) {
        String message = rc == 0 ? AGENT_SHUTDOWN : FAILED;
        message = String.format(message, LOCALHOST_NAME);
        model.println(message);
    }

    void setRemoteAgentPort() {
        String port = this.getRemoteAgentPort();
        if (port != null) {
            System.setProperty(AGENT_SERVER_PORT_PROPERTY, port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSecurityProperties(Properties securityProperties) {
        StopCommand stopCommand = this;
        synchronized (stopCommand) {
            this.securityProperties = securityProperties;
        }
    }

    private void setupTrustStore(Properties p) {
        String keyStore = p.getProperty(AGENT_SECURITY_KEYSTORE, "");
        String keyStorePass = p.getProperty(AGENT_SECURITY_KEYSTORE_PASS, "");
        p.setProperty(AGENT_SECURITY_TRUSTSTORE, keyStore);
        p.setProperty(AGENT_SECURITY_TRUSTSTORE_PASS, keyStorePass);
    }

    boolean shutdownAgent(String host) throws CommandExecutionException {
        AgentMBean agent;
        if (host == null) {
            throw new IllegalArgumentException("host must not be null");
        }
        if (!host.equals(LOCALHOST_NAME)) {
            String msg = String.format("host must be \"%s\" received \"%s\"", LOCALHOST_NAME, host);
            throw new IllegalArgumentException(msg);
        }
        this.setRemoteAgentPort();
        try {
            agent = this.connectToAgent(host);
        }
        catch (IOException ioEx) {
            String msg = String.format(AGENT_CONNECTION_ATTEMPT_FAILED, host);
            throw new CommandExecutionException(msg, ioEx);
        }
        boolean result = this.stopAgent(agent);
        try {
            this.disconnectFromAgent(host);
        }
        catch (IOException ioEx) {
            LOGGER.debug(AGENT_FAILED_DISCONNECT_ATTEMPT, (Throwable)ioEx);
        }
        return result;
    }

    private boolean stopAgent(AgentMBean agent) {
        return agent.stopAgent();
    }

    Properties validateSecurityProperties(Properties p) {
        if (p == null) {
            throw new IllegalArgumentException("p should not be null");
        }
        if (!p.containsKey(AGENT_SECURITY_ENABLED) || !StopCommand.isSecurityEnabled(p)) {
            return null;
        }
        this.setupTrustStore(p);
        return p;
    }
}

