/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.config.app.commands.internal;

import com.sas.deployment.application.commands.AbstractServiceWrapperEditorCommand;
import com.sas.deployment.servicewrapper.editor.IServiceWrapperEditor;
import com.sas.solstice.platform.application.common.api.command.IParameterSpecification;
import com.sas.solstice.platform.application.common.command.validator.BooleanParameterValidator;

class SetAutoStartCommand
extends AbstractServiceWrapperEditorCommand {
    private static final String DEMAND_START = "DEMAND_START";
    private static final String AUTO_START = "AUTO_START";

    SetAutoStartCommand(IServiceWrapperEditor serviceWrapperEditor) {
        super(serviceWrapperEditor);
    }

    @Override
    protected String fromStorageFormat(String mode) {
        if (DEMAND_START.equals(mode)) {
            return Boolean.FALSE.toString();
        }
        if (AUTO_START.equals(mode)) {
            return Boolean.TRUE.toString();
        }
        return null;
    }

    @Override
    protected String getParameterId() {
        return "wrapper.ntservice.starttype";
    }

    @Override
    protected String getParameterLabel() {
        return "Enable AutoStart";
    }

    @Override
    protected String getParameterUsage() {
        return "True to enable autostart, or false to disable autostart.";
    }

    @Override
    protected IParameterSpecification.IParameterValidator getParameterValidator() {
        return new BooleanParameterValidator();
    }

    @Override
    protected String getPostExecutionMessage(String value) {
        return String.format("Autostart has been set to \"%s\".", value);
    }

    @Override
    protected String toStorageFormat(String value) {
        boolean state = Boolean.valueOf(value);
        return state ? AUTO_START : DEMAND_START;
    }
}

