/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.config.app.commands.internal;

import com.sas.deployment.config.app.commands.internal.IExecutorStrategy;
import com.sas.deployment.config.app.commands.internal.util.RuntimeProcessExecutor;
import com.sas.solstice.platform.application.common.api.IApplicationModel;
import com.sas.solstice.platform.application.common.api.command.CommandExecutionException;
import com.sas.solstice.platform.application.common.command.AbstractCommand;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractPlatformCommand<T extends IApplicationModel>
extends AbstractCommand<T> {
    private IExecutorStrategy executorStrategy;

    protected void collectParameters(T model, List<String> parameters) {
    }

    private String[] composeCommand(T model) {
        String name;
        ArrayList<String> parameters = new ArrayList<String>(5);
        this.collectParameters(model, parameters);
        int size = parameters.size() + 1;
        String[] command = new String[size];
        command[0] = name = this.getCommandName();
        this.injectParameters(parameters, command);
        return command;
    }

    private String createExecutionStatusMessage(int rc, String stdout, String stderr) {
        StringBuffer buffer = new StringBuffer(250);
        this.printExecutionStatusMessageOn(buffer, rc, stdout, stderr);
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int execute(T model, Map<String, String> parameters) throws CommandExecutionException {
        int n;
        IExecutorStrategy executorStrategy = this.getExecutorStrategy();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream(4096);
        try {
            String[] command = this.composeCommand(model);
            int rc = executorStrategy.execute(command, outputStream, errorStream);
            String stdout = ((Object)outputStream).toString();
            String stderr = ((Object)errorStream).toString();
            String message = this.createExecutionStatusMessage(rc, stdout, stderr);
            model.println(message);
            n = rc;
        }
        catch (Throwable throwable) {
            try {
                ((OutputStream)outputStream).close();
                ((OutputStream)errorStream).close();
                throw throwable;
            }
            catch (IOException ex) {
                this.handleException(ex);
                return -1;
            }
        }
        ((OutputStream)outputStream).close();
        ((OutputStream)errorStream).close();
        return n;
    }

    protected abstract String getCommandName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IExecutorStrategy getExecutorStrategy() {
        AbstractPlatformCommand abstractPlatformCommand = this;
        synchronized (abstractPlatformCommand) {
            if (this.executorStrategy == null) {
                RuntimeProcessExecutor value = new RuntimeProcessExecutor();
                this.setExecutorStrategy(value);
            }
            return this.executorStrategy;
        }
    }

    private void injectParameters(List<String> parameters, String[] command) {
        int index = 1;
        Iterator<String> iterator = parameters.iterator();
        while (iterator.hasNext()) {
            String parameter;
            command[index] = parameter = iterator.next();
            ++index;
        }
    }

    protected String parseMessageFromStandardError(String stderr) {
        return stderr;
    }

    protected String parseMessageFromStandardOut(String stdout) {
        return stdout;
    }

    protected void printExecutionStatusMessageOn(StringBuffer buffer, int rc, String stdout, String stderr) {
        if (rc == 0) {
            return;
        }
        this.printStandardOutOn(buffer, stdout);
        this.printStandardErrorOn(buffer, stderr);
    }

    private void printStandardErrorOn(StringBuffer buffer, String stderror) {
        String message = this.parseMessageFromStandardError(stderror);
        boolean empty = message.isEmpty();
        if (empty) {
            return;
        }
        buffer.append('\t');
        buffer.append(message);
        buffer.append('\n');
    }

    private void printStandardOutOn(StringBuffer buffer, String stdout) {
        String message = this.parseMessageFromStandardOut(stdout);
        boolean empty = message.isEmpty();
        if (empty) {
            return;
        }
        buffer.append('\t');
        buffer.append(message);
        buffer.append('\n');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExecutorStrategy(IExecutorStrategy executorStrategy) {
        AbstractPlatformCommand abstractPlatformCommand = this;
        synchronized (abstractPlatformCommand) {
            this.executorStrategy = executorStrategy;
        }
    }
}

