/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.common.utilities;

import com.sas.deployment.common.api.IEncodedPassword;
import com.sas.deployment.common.utilities.EncodedPassword;
import com.sas.solstice.platform.core.password.SasPasswordEncodingException;
import com.sas.solstice.platform.core.password.SasPasswordString;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SecurityConfig {
    public static final String PROP_SECURITY_ENABLED = "solstice.security.enabled";
    public static final String PROP_SECURITY_CLIENT_AUTH = "solstice.security.client.auth";
    public static final String PROP_SECURITY_KEYSTORE = "solstice.security.keystore";
    public static final String PROP_SECURITY_KEYSTORE_PASSWORD = "solstice.security.keystore.password";
    public static final String PROP_SECURITY_TRUSTSTORE = "solstice.security.truststore";
    public static final String PROP_SECURITY_TRUSTSTORE_PASSWORD = "solstice.security.truststore.password";
    private static final String MSG_JMX_CLIENT_ENVIRONMENT_PROPERTY_SET = "JMX client environment property \"%s\" set to \"%s\".";
    private static final String MSG_JMX_SERVER_ENVIRONMENT_PROPERTY_SET = "JMX server environment property \"%s\" set to \"%s\".";
    private static final String MSG_FILE_NOT_ACCESSIBLE = "The file \"%s\" specified by the \"%s\" property is not readable.";
    private static final String MSG_FILE_NOT_FOUND = "The file \"%s\" specified by the \"%s\" property was not found.";
    private static final String MSG_PROPERTY_VALUE = "Property \"%s\" value is \"%s\".";
    private static final String MSG_REQUIRED_PROPERTY_MISSING = "Missing or empty \"%s\" property, security cannot be enabled.";
    private static final String MSG_TLS_PROPERTY_VALUE = "TLS property \"%s\" set to \"%s\".";
    static final String TYPE_KEYSTORE = "keystore";
    static final String TYPE_TRUSTSTORE = "truststore";
    private static final Logger LOGGER = LogManager.getLogger(SecurityConfig.class);
    private boolean _securityEnabled;
    private boolean _tlsSetupDone;
    private boolean _clientAuth;
    private boolean _isServer = false;
    private String _trustStorePath;
    private String _keyStorePath;
    private IEncodedPassword _keyStorePassword;
    private IEncodedPassword _trustStorePassword;

    private static void logDebug(String message) {
        LOGGER.debug(message);
    }

    private static void logError(String message) {
        LOGGER.error(message);
    }

    public SecurityConfig() {
        this(null, false);
    }

    public SecurityConfig(Properties securityProperties, boolean isServer) {
        this.setIsServer(isServer);
        Properties properties = this.toValidProperties(securityProperties);
        this.logProperties(properties);
        boolean enabled = this.getBooleanProperty(properties, PROP_SECURITY_ENABLED);
        if (!enabled) {
            return;
        }
        this.initializeUsing(properties);
        if (isServer) {
            this.checkKeyStorePath();
            if (this.isClientAuth()) {
                this.checkTrustStorePath();
            }
            return;
        }
        this.checkTrustStorePath();
        if (this.isClientAuth()) {
            this.checkKeyStorePath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSecurityToClientEnvironment(Map<String, Object> environment) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, SasPasswordEncodingException, UnrecoverableKeyException, KeyManagementException {
        this.checkEnvironment(environment);
        boolean enabled = this.isSecurityEnabled();
        if (!enabled) {
            return;
        }
        String value = "TLS";
        environment.put("jmx.remote.profiles", value);
        String message = String.format(MSG_JMX_CLIENT_ENVIRONMENT_PROPERTY_SET, "jmx.remote.profiles", value);
        SecurityConfig.logDebug(message);
        KeyStore trustStore = KeyStore.getInstance("JKS");
        String trustStorePath = this.getTrustStorePath();
        try (FileInputStream trustStoreFile = null;){
            trustStoreFile = new FileInputStream(trustStorePath);
            String encodedTrustStorePassword = new String(this.getTrustStorePassword());
            char[] decodedTrustStorePasswordChars = SasPasswordString.decodeChars(encodedTrustStorePassword.toCharArray());
            trustStore.load(trustStoreFile, decodedTrustStorePasswordChars);
            Arrays.fill(decodedTrustStorePasswordChars, '\u0000');
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        KeyManager[] keyManagers = null;
        if (this.isClientAuth()) {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            String keyStorePath = this.getKeyStorePath();
            try (FileInputStream keyStoreFile = null;){
                keyStoreFile = new FileInputStream(keyStorePath);
                String encodedkeyStorePassword = new String(this.getKeyStorePassword());
                char[] decodedkeyStorePasswordChars = SasPasswordString.decodeChars(encodedkeyStorePassword.toCharArray());
                keyStore.load(keyStoreFile, decodedkeyStorePasswordChars);
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStore, decodedkeyStorePasswordChars);
                Arrays.fill(decodedkeyStorePasswordChars, '\u0000');
                keyManagers = keyManagerFactory.getKeyManagers();
            }
        }
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(keyManagers, trustManagers, null);
        SSLSocketFactory socketFactory = sslContext.getSocketFactory();
        environment.put("jmx.remote.tls.socket.factory", socketFactory);
    }

    public void addSecurityToServerEnvironment(Map<String, Object> environment) {
        this.checkEnvironment(environment);
        boolean enabled = this.isSecurityEnabled();
        if (!enabled) {
            return;
        }
        String value = "TLS";
        environment.put("jmx.remote.profiles", value);
        String message = String.format(MSG_JMX_SERVER_ENVIRONMENT_PROPERTY_SET, "jmx.remote.profiles", value);
        SecurityConfig.logDebug(message);
        boolean clientAuth = this.isClientAuth();
        if (clientAuth) {
            value = Boolean.TRUE.toString();
            environment.put("jmx.remote.tls.need.client.authentication", value);
            message = String.format(MSG_JMX_SERVER_ENVIRONMENT_PROPERTY_SET, "jmx.remote.tls.need.client.authentication", value);
            SecurityConfig.logDebug(message);
        }
    }

    private void checkEnvironment(Map<String, Object> environment) {
        if (environment != null) {
            return;
        }
        throw new IllegalArgumentException("environment must not be null");
    }

    private void checkFile(String name, String property) {
        File f = new File(name);
        if (!f.exists()) {
            String message = String.format(MSG_FILE_NOT_FOUND, name, property);
            SecurityConfig.logError(message);
            throw new IllegalArgumentException(message);
        }
        if (!f.canRead()) {
            String message = String.format(MSG_FILE_NOT_ACCESSIBLE, name, property);
            throw new IllegalArgumentException(message);
        }
    }

    private void checkKeyStorePath() {
        String path = this.getKeyStorePath();
        if (path == null || path.isEmpty()) {
            String message = String.format(MSG_REQUIRED_PROPERTY_MISSING, PROP_SECURITY_KEYSTORE);
            SecurityConfig.logError(message);
            throw new IllegalArgumentException(message);
        }
        this.checkFile(path, PROP_SECURITY_KEYSTORE);
    }

    private void checkTrustStorePath() {
        String path = this.getTrustStorePath();
        if (path == null || path.isEmpty()) {
            String message = String.format(MSG_REQUIRED_PROPERTY_MISSING, PROP_SECURITY_TRUSTSTORE);
            SecurityConfig.logError(message);
            throw new IllegalArgumentException(message);
        }
        this.checkFile(path, PROP_SECURITY_TRUSTSTORE);
    }

    private boolean getBooleanProperty(Properties properties, String key) {
        String value = this.getProperty(properties, key);
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public String getEncodedKeyStorePassword() {
        return this._keyStorePassword.getEncodedPassword();
    }

    public String getEncodedTrustStorePassword() {
        return this._trustStorePassword.getEncodedPassword();
    }

    public char[] getKeyStorePassword() {
        return this._keyStorePassword.getPassword();
    }

    public String getKeyStorePath() {
        return this._keyStorePath;
    }

    private String getProperty(Properties properties, String key) {
        String value = properties.getProperty(key);
        if (value == null) {
            value = System.getProperty(key);
        }
        return value;
    }

    public char[] getTrustStorePassword() {
        return this._trustStorePassword.getPassword();
    }

    public String getTrustStorePath() {
        return this._trustStorePath;
    }

    private void initializeUsing(Properties properties) {
        this.setSecurityEnabled(this.getBooleanProperty(properties, PROP_SECURITY_ENABLED));
        this.setClientAuth(this.getBooleanProperty(properties, PROP_SECURITY_CLIENT_AUTH));
        this.setTrustStorePath(this.getProperty(properties, PROP_SECURITY_TRUSTSTORE));
        this.setKeyStorePath(this.getProperty(properties, PROP_SECURITY_KEYSTORE));
        EncodedPassword kspw = new EncodedPassword(TYPE_KEYSTORE);
        this.setKeyStorePassword(kspw);
        kspw.setEncodedPassword(this.getProperty(properties, PROP_SECURITY_KEYSTORE_PASSWORD));
        EncodedPassword tspw = new EncodedPassword(TYPE_TRUSTSTORE);
        this.setTrustStorePassword(tspw);
        tspw.setEncodedPassword(this.getProperty(properties, PROP_SECURITY_TRUSTSTORE_PASSWORD));
    }

    public boolean isClientAuth() {
        return this._clientAuth;
    }

    public boolean isSecurityEnabled() {
        return this._securityEnabled;
    }

    public boolean isServer() {
        return this._isServer;
    }

    public boolean isTlsSetupDone() {
        return this._tlsSetupDone;
    }

    private void logProperties(Properties properties) {
        this.logProperty(properties, PROP_SECURITY_ENABLED);
        this.logProperty(properties, PROP_SECURITY_CLIENT_AUTH);
        this.logProperty(properties, PROP_SECURITY_KEYSTORE);
        this.logProperty(properties, PROP_SECURITY_TRUSTSTORE);
    }

    private void logProperty(Properties properties, String key) {
        String value = this.getProperty(properties, key);
        String message = String.format(MSG_PROPERTY_VALUE, key, value);
        LOGGER.debug(message);
    }

    private void logTlsProperty(String key) {
        String value = System.getProperty(key);
        String message = String.format(MSG_TLS_PROPERTY_VALUE, key, value);
        SecurityConfig.logDebug(message);
    }

    public void setClientAuth(boolean clientAuth) {
        this._clientAuth = clientAuth;
    }

    public void setIsServer(boolean server) {
        this._isServer = server;
    }

    public void setKeyStorePassword(IEncodedPassword encodedPassword) {
        this._keyStorePassword = encodedPassword;
    }

    public void setTrustStorePassword(IEncodedPassword encodedPassword) {
        this._trustStorePassword = encodedPassword;
    }

    public void setKeyStorePath(String keyStorePath) {
        this._keyStorePath = keyStorePath;
    }

    private void setProperty(String key, String value) {
        System.setProperty(key, value);
    }

    public void setSecurityEnabled(boolean securityEnabled) {
        this._securityEnabled = securityEnabled;
    }

    public void setTlsProperties() {
        if (this.isSecurityEnabled() && !this.isTlsSetupDone()) {
            this.setTlsSetupDone(true);
            if (this.isServer()) {
                this.setTlsPropertiesForServer();
            }
            this.logTlsProperty("javax.net.debug");
            this.logTlsProperty("javax.net.ssl.keyStore");
            this.logTlsProperty("javax.net.ssl.trustStore");
        }
    }

    private void setTlsPropertiesForServer() {
        this.setProperty("javax.net.ssl.keyStore", this.getKeyStorePath());
        this.setProperty("javax.net.ssl.keyStorePassword", new String(this.getKeyStorePassword()));
        if (this.isClientAuth()) {
            this.setProperty("javax.net.ssl.trustStore", this.getTrustStorePath());
            this.setProperty("javax.net.ssl.trustStorePassword", new String(this.getTrustStorePassword()));
        }
    }

    public void setTlsSetupDone(boolean tlsSetupDone) {
        this._tlsSetupDone = tlsSetupDone;
    }

    public void setTrustStorePath(String trustStorePath) {
        this._trustStorePath = trustStorePath;
    }

    private Properties toValidProperties(Properties properties) {
        return properties == null ? System.getProperties() : properties;
    }
}

