/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.common.utilities;

import com.sas.deployment.common.api.IEncodedPassword;
import com.sas.deployment.common.api.IPrompter;
import com.sas.solstice.platform.core.password.SasPasswordEncodingException;
import com.sas.solstice.platform.core.password.SasPasswordString;
import java.io.Console;
import java.io.IOException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EncodedPassword
implements IEncodedPassword {
    private static final String MSG_PASSWORD_PROMPT = "Enter the %s password: ";
    private static final String MSG_PASSWORD_PROMPT_ERROR = "I/O error prompting for the password.";
    private static final String MSG_PASSWORD_DECODING_ERROR = "Error decoding the password - reason code is %d.";
    private static final String MSG_PASSWORD_ENCODING_ERROR = "Error encoding the %s password.";
    private String _encodedPassword;
    private final String _passwordType;
    private IPrompter _prompter;
    private static final Logger LOGGER = LogManager.getLogger(EncodedPassword.class);

    public EncodedPassword(String type) {
        this._passwordType = type;
        this._prompter = this.createPrompter();
    }

    private IPrompter createPrompter() {
        Console console = System.console();
        if (console == null) {
            return new PromptWithSystem();
        }
        return new PromptWithConsole();
    }

    private void encodePassword(char[] password) {
        if (password == null) {
            return;
        }
        try {
            String encodedPassword = new String(SasPasswordString.encodeChars(password));
            this.setEncodedPassword(encodedPassword);
        }
        catch (SasPasswordEncodingException exception) {
            String message = String.format(MSG_PASSWORD_ENCODING_ERROR, this.getPasswordType());
            LOGGER.warn(message, (Throwable)exception);
        }
    }

    @Override
    public String getEncodedPassword() {
        return this._encodedPassword;
    }

    @Override
    public char[] getPassword() {
        String encoded = this.getEncodedPassword();
        if (encoded == null) {
            return this.promptForAndSavePassword();
        }
        return EncodedPassword.uncodeEncryptedString(encoded);
    }

    @Override
    public String getPasswordType() {
        return this._passwordType;
    }

    public IPrompter getPrompter() {
        return this._prompter;
    }

    private char[] promptForAndSavePassword() {
        IPrompter prompter = this.getPrompter();
        String prompt = String.format(MSG_PASSWORD_PROMPT, this.getPasswordType());
        char[] password = prompter.promptForPassword(prompt);
        this.encodePassword(password);
        return password;
    }

    @Override
    public void setEncodedPassword(String encodedPassword) {
        this._encodedPassword = encodedPassword;
    }

    void setPrompter(IPrompter prompter) {
        this._prompter = prompter;
    }

    public static char[] uncodeEncryptedString(String encoded) {
        SasPasswordString.DecodeResult result = null;
        try {
            result = SasPasswordString.decodeCharsWithResult(encoded.toCharArray());
            int reason = result.getReason();
            if (reason == 0) {
                return result.getValueChars();
            }
            String message = String.format(MSG_PASSWORD_DECODING_ERROR, reason);
            LOGGER.error(message);
        }
        catch (SasPasswordEncodingException exception) {
            String message = String.format(MSG_PASSWORD_DECODING_ERROR, -1);
            LOGGER.error(message, (Throwable)exception);
        }
        return null;
    }

    private static class PromptWithSystem
    implements IPrompter {
        private PromptWithSystem() {
        }

        @Override
        public char[] promptForPassword(String promptMsg) {
            char[] password = null;
            while (password == null || password.length <= 1) {
                int len;
                System.out.println(promptMsg);
                byte[] bytes = new byte[256];
                try {
                    len = System.in.read(bytes);
                    bytes[len] = 0;
                }
                catch (IOException exception) {
                    String msg = String.format(EncodedPassword.MSG_PASSWORD_PROMPT_ERROR, new Object[0]);
                    LOGGER.error(msg, (Throwable)exception);
                    return null;
                }
                password = new char[len];
                for (int i = 0; i < len - 1; ++i) {
                    password[i] = (char)(bytes[i] & 0xFF);
                }
                Arrays.fill(bytes, (byte)0);
            }
            return password;
        }
    }

    private static class PromptWithConsole
    implements IPrompter {
        private PromptWithConsole() {
        }

        @Override
        public char[] promptForPassword(String promptMsg) {
            Console console = System.console();
            char[] password = null;
            while (password == null || password.length == 0) {
                password = console.readPassword(promptMsg, new Object[0]);
            }
            return password;
        }
    }
}

