/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.common.ext;

import com.sas.deployment.common.ext.ContentExt;
import com.sas.deployment.common.ext.DeploymentDescriptorExt;
import com.sas.deployment.common.ext.ObjectFactoryExt;
import com.sas.solstice.platform.core.model.ContentType;
import com.sas.solstice.platform.core.model.ContentsType;
import com.sas.solstice.platform.core.model.DisplayTextType;
import com.sas.solstice.platform.core.model.PackageDescriptorType;
import com.sas.solstice.platform.core.model.PackageIdentityType;
import com.sas.solstice.platform.core.model.SDDContentPurposeType;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PackageDescriptorExt
extends PackageDescriptorType {
    private static final Logger LOGGER = LogManager.getLogger(PackageDescriptorExt.class);
    private static final long serialVersionUID = 1L;
    private static final String MSG_ORDER_MUST_NOT_BE_NULL = "order must not be null";
    private static final String DEFAULT_COUNTRY = "US";
    private static final String DEFAULT_LANGUAGE = "en";
    private static final String OBJECT_FACTORY = "com.sun.xml.internal.bind.ObjectFactory";
    public static final String PURPOSE_DESCRIPTION_CONTENT = SDDContentPurposeType.CONTENT.value();
    private static final String SDD_CONTENT_ORDER_PURPOSE = "order";
    private static final Properties UNMARSHAL_PROPERTIES = new Properties();
    private Map<ContentExt, PackageDescriptorExt> _packageRefs = new HashMap<ContentExt, PackageDescriptorExt>(17);
    private Map<String, ContentExt> _contentById = new HashMap<String, ContentExt>(17);
    private Unmarshaller _unmarshaller = null;
    private URI _location;
    private URI _distributionPointRoot;
    private DeploymentDescriptorExt _deploymentDescriptor;
    private Properties _properties;

    public ContentExt getOrderDescriptorContent(String order) {
        if (order == null) {
            throw new IllegalArgumentException(MSG_ORDER_MUST_NOT_BE_NULL);
        }
        ContentExt content = this.getContentForID(order);
        if (content == null) {
            return null;
        }
        String purpose = content.getPurpose();
        boolean purposeOrder = this.isPurposeOrder(purpose);
        if (!purposeOrder) {
            return null;
        }
        return content;
    }

    public URI getOrderDescriptorURI(String order) throws IOException {
        if (order == null) {
            throw new IllegalArgumentException(MSG_ORDER_MUST_NOT_BE_NULL);
        }
        ContentExt content = this.getOrderDescriptorContent(order);
        if (content == null) {
            return null;
        }
        String pathname = content.getPathname();
        URI uri = null;
        try {
            uri = new URI(pathname);
        }
        catch (URISyntaxException exception) {
            String message = String.format("Failed to get order destriptor URI for \"%s\"", order);
            throw new IOException(message, exception);
        }
        return uri;
    }

    public PackageDescriptorExt packageForContentRef(String ref) {
        if (ref == null) {
            throw new IllegalArgumentException("ref must not be null");
        }
        ContentExt content = this.getContentForID(ref);
        if (content == null) {
            return null;
        }
        return this.packageForContent(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentExt getContentForID(String id) {
        Map<String, ContentExt> contentById;
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        Map<String, ContentExt> map = contentById = this.getContentById();
        synchronized (map) {
            ContentExt content = contentById.get(id);
            if (content != null) {
                return content;
            }
            return this.findContentForId(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentExt findContentForId(String id) {
        Map<String, ContentExt> contentById;
        ContentExt content = null;
        boolean found = false;
        List<ContentType> list = this.getContentList();
        Iterator<ContentType> iterator = list.iterator();
        Map<String, ContentExt> map = contentById = this.getContentById();
        synchronized (map) {
            while (!found && iterator.hasNext()) {
                ContentType contentType = iterator.next();
                content = (ContentExt)contentType;
                String key = content.getId();
                contentById.put(key, content);
                found = id.equals(key);
            }
        }
        return found ? content : null;
    }

    private List<ContentType> getContentList() {
        return this.getContents().getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageDescriptorExt packageForContent(ContentExt content) {
        PackageDescriptorExt packageDescriptor;
        Map<ContentExt, PackageDescriptorExt> packageRefs;
        if (content == null) {
            throw new IllegalArgumentException("content must not be null");
        }
        String purpose = content.getPurpose();
        if (!this.isPurposePackageDescriptor(purpose) && !this.isPurposeOrder(purpose)) {
            return null;
        }
        String pathname = content.getPathname();
        LOGGER.debug("packageForContent() - getting package for " + pathname);
        Map<ContentExt, PackageDescriptorExt> map = packageRefs = this.getPackageRefs();
        synchronized (map) {
            packageDescriptor = packageRefs.get(content);
            if (packageDescriptor != null) {
                return packageDescriptor;
            }
            packageDescriptor = this.fetchPackageDescriptorExt(content);
            packageRefs.put(content, packageDescriptor);
        }
        return packageDescriptor;
    }

    private PackageDescriptorExt fetchPackageDescriptorExt(ContentExt content) {
        URI distributionPointRoot = this.getDistributionPointRoot();
        URI contentUri = content.getAbsoluteUri(distributionPointRoot);
        PackageDescriptorExt packageDescriptor = (PackageDescriptorExt)this.loadDescriptor(contentUri);
        if (packageDescriptor == null) {
            return null;
        }
        packageDescriptor.resolvePackageProperties(distributionPointRoot);
        packageDescriptor.setLocation(contentUri);
        packageDescriptor.setDistributionPointRoot(distributionPointRoot);
        return packageDescriptor;
    }

    private boolean isPurposePackageDescriptor(String purpose) {
        String value = SDDContentPurposeType.PACKAGE_DESCRIPTOR.value();
        return purpose.equalsIgnoreCase(value);
    }

    private boolean isPurposeOrder(String purpose) {
        return purpose.equalsIgnoreCase(SDD_CONTENT_ORDER_PURPOSE);
    }

    private <T> T loadDescriptor(URI uri) {
        LOGGER.info("load(URI) - loading descriptor, uri=" + uri);
        if (uri == null) {
            return null;
        }
        T result = null;
        try {
            URL url = uri.toURL();
            result = this.loadDescriptor(url);
        }
        catch (MalformedURLException exception) {
            String message = String.format("failed to load descriptor \"%s\"", uri);
            LOGGER.error(message, (Throwable)exception);
        }
        return result;
    }

    private <T> T loadDescriptor(URL url) {
        Object result = null;
        try {
            Unmarshaller unmarshaller = this.getUnmarshaller();
            JAXBElement element = (JAXBElement)unmarshaller.unmarshal(url);
            result = element.getValue();
        }
        catch (JAXBException exception) {
            String message = String.format("failed to unmarshal \"%s\"", url);
            LOGGER.error(message, (Throwable)exception);
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Unmarshaller getUnmarshaller() throws JAXBException {
        PackageDescriptorExt packageDescriptorExt = this;
        synchronized (packageDescriptorExt) {
            if (this._unmarshaller == null) {
                this._unmarshaller = this.createUnmarshaller();
                Object[] object = PackageDescriptorExt.createFactoryObjectsArray();
                this._unmarshaller.setProperty(OBJECT_FACTORY, (Object)object);
            }
            return this._unmarshaller;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentDescriptorExt getDeploymentDescriptor() {
        if (this._deploymentDescriptor != null) {
            return this._deploymentDescriptor;
        }
        List<ContentType> list = this.getContentList();
        String value = SDDContentPurposeType.DEPLOYMENT_DESCRIPTOR.value();
        Map<String, ContentExt> map = this.getContentById();
        for (ContentType contentType : list) {
            ContentExt content = (ContentExt)contentType;
            String id = contentType.getId();
            Map<String, ContentExt> map2 = map;
            synchronized (map2) {
                ContentExt contentById = map.get(id);
                if (contentById == null) {
                    map.put(id, content);
                }
            }
            String purpose = this.getContentPurpose(contentType);
            boolean match = purpose.equalsIgnoreCase(value);
            if (!match) continue;
            URI distributionPointRoot = this.getDistributionPointRoot();
            URI contentUri = content.getAbsoluteUri(distributionPointRoot);
            this._deploymentDescriptor = (DeploymentDescriptorExt)this.loadDescriptor(contentUri);
            Properties properties = this.getProperties();
            this._deploymentDescriptor.resolveDeploymentProperties(properties);
            this._deploymentDescriptor.setPackageDescriptor(this);
        }
        return this._deploymentDescriptor;
    }

    public void resolvePackageProperties(URI uri) {
        String softwareID = this.getPackageIdentity().getSoftwareID();
        String message = String.format("PackageDescriptor::resolvePackageProperties() - resolving \"%s\" for \"%s\"", softwareID, uri);
        LOGGER.info(message);
        ContentsType contents = this.getContents();
        if (contents == null) {
            LOGGER.info("PackageDescriptor::resolvePackageProperties() - there are no contents in this package to resolve");
            return;
        }
        LOGGER.info("PackageDescriptor::resolvePackageProperties() - resolving content types");
        List<ContentType> contentList = this.getContentList();
        Properties descriptorLanguageBundle = this.getDescriptorLanguageBundle(uri, contentList);
        this.setProperties(descriptorLanguageBundle);
        this.setPackageIdentityProperties();
    }

    private void setPackageIdentityProperties() {
        Properties properties = this.getProperties();
        if (properties == null) {
            return;
        }
        PackageIdentityType packageIdentity = this.getPackageIdentity();
        DisplayTextType name = packageIdentity.getName();
        String translatedName = this.setValueFor(properties, name);
        DisplayTextType description = packageIdentity.getDescription();
        String translatedDescription = this.setValueFor(properties, description);
        DisplayTextType shortDescription = packageIdentity.getShortDescription();
        String translatedShortDescription = this.setValueFor(properties, shortDescription);
        this.logFoundProperties(translatedName, translatedDescription, translatedShortDescription);
    }

    private void logFoundProperties(String translatedName, String translatedDescription, String translatedShortDescription) {
        StringBuffer buffer = new StringBuffer(150);
        char newline = '\n';
        String message = String.format("DeploymentDescriptor::resolveDeploymentProperties() - found properties:", new Object[0]);
        buffer.append(message);
        buffer.append(newline);
        message = String.format(" translatedName:\"%s\"", translatedName);
        buffer.append(message);
        buffer.append(newline);
        message = String.format(" translatedDescription:\"%s\"", translatedDescription);
        buffer.append(message);
        buffer.append(newline);
        message = String.format(" translatedShortDescription:\"%s\"", translatedShortDescription);
        buffer.append(message);
        message = buffer.toString();
        LOGGER.info(message);
    }

    private String setValueFor(Properties properties, DisplayTextType displayText) {
        if (displayText == null) {
            return null;
        }
        String key = displayText.getTranslationKey();
        if (key == null) {
            return null;
        }
        String translatedValue = properties.getProperty(key);
        if (translatedValue == null) {
            return null;
        }
        displayText.setValue(translatedValue);
        return translatedValue;
    }

    public Properties getDescriptorLanguageBundle(URI uri, List<ContentType> contents) {
        Properties properties = null;
        Iterator<ContentType> iterator = contents.iterator();
        boolean found = false;
        ContentType content = null;
        while (!found && iterator.hasNext()) {
            content = iterator.next();
            found = this.isDescriptorLanguageBundle(content);
        }
        if (found) {
            String filename = this.getFilename(content);
            if (uri != null) {
                filename = String.format("%s%s", uri, filename);
            }
            try {
                properties = this.loadProperties(filename);
            }
            catch (IOException exception) {
                String error = exception.getMessage();
                String message = String.format("Failed to load the properties file \"%s\": %s", filename, error);
                LOGGER.info(message);
            }
        }
        return properties;
    }

    private String getCountry() {
        Locale locale = Locale.getDefault();
        return locale.getCountry();
    }

    private String getLanguage() {
        Locale locale = Locale.getDefault();
        return locale.getLanguage();
    }

    private boolean isDefaultCountry() {
        String value = this.getCountry();
        return value.equalsIgnoreCase(DEFAULT_COUNTRY);
    }

    private boolean isDefaultLanguage() {
        String value = this.getLanguage();
        return value.equalsIgnoreCase(DEFAULT_LANGUAGE);
    }

    private String getFilename(ContentType content) {
        String filename = content.getPathname();
        if (this.isDefaultCountry() && this.isDefaultLanguage()) {
            return filename;
        }
        filename = this.toLocalizedFilename(filename);
        return filename;
    }

    private String toLocalizedFilename(String filename) {
        String localizedFilename;
        boolean withExtension;
        String language = this.getLanguage();
        String country = this.getCountry();
        int lastPeriod = filename.lastIndexOf(46);
        boolean bl = withExtension = lastPeriod != -1;
        if (withExtension) {
            String name = filename.substring(0, lastPeriod);
            int length = filename.length();
            String extension = filename.substring(lastPeriod, length);
            localizedFilename = String.format("%s_%s_%s%s", name, language, country, extension);
        } else {
            localizedFilename = String.format("%s_%s_%s", filename, language, country);
        }
        File file = new File(localizedFilename);
        boolean exists = file.exists();
        if (!exists) {
            localizedFilename = filename;
        }
        return localizedFilename;
    }

    private boolean isDescriptorLanguageBundle(ContentType content) {
        String purpose = this.getContentPurpose(content);
        return purpose.equalsIgnoreCase(SDDContentPurposeType.DESCRIPTOR_LANGUAGE_BUNDLE.value());
    }

    private String getContentPurpose(ContentType content) {
        return content.getPurpose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(String filename) throws IOException {
        String propertyFilename;
        String message = String.format("loadProperties() - from reference \"%s\"", filename);
        LOGGER.info(message);
        try {
            URI uri = new URI(filename);
            propertyFilename = uri.toString();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        message = String.format("loadProperties() - from \"%s\"", propertyFilename);
        LOGGER.info(message);
        Properties properties = new Properties();
        try (InputStream stream = this.createInputStream(propertyFilename);){
            properties.load(stream);
        }
        return properties;
    }

    private InputStream createInputStream(String filename) throws IOException {
        if (filename.startsWith("http:") || filename.startsWith("file:")) {
            URL url = new URL(filename);
            return url.openStream();
        }
        return new FileInputStream(filename);
    }

    protected Map<ContentExt, PackageDescriptorExt> getPackageRefs() {
        return this._packageRefs;
    }

    protected void setPackageRefs(Map<ContentExt, PackageDescriptorExt> contentRefs) {
        this._packageRefs = contentRefs;
    }

    private static Object[] createFactoryObjectsArray() {
        return new Object[]{new ObjectFactoryExt()};
    }

    private Unmarshaller createUnmarshaller() throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)"com.sas.solstice.platform.core.model");
        return jc.createUnmarshaller();
    }

    public URI getLocation() {
        return this._location;
    }

    public void setLocation(URI location) {
        this._location = location;
    }

    protected Map<String, ContentExt> getContentById() {
        return this._contentById;
    }

    protected void setContentById(Map<String, ContentExt> contentById) {
        this._contentById = contentById;
    }

    public Properties getProperties() {
        return this._properties;
    }

    public void setProperties(Properties properties) {
        this._properties = properties;
    }

    public void setDistributionPointRoot(URI distributionPointRoot) {
        this._distributionPointRoot = distributionPointRoot;
    }

    public URI getDistributionPointRoot() {
        return this._distributionPointRoot;
    }

    static {
        UNMARSHAL_PROPERTIES.put(OBJECT_FACTORY, PackageDescriptorExt.createFactoryObjectsArray());
    }
}

