/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.common.ext;

import com.sas.deployment.common.ext.PackageDescriptorExt;
import com.sas.solstice.platform.core.model.CompositeInstallableType;
import com.sas.solstice.platform.core.model.ConfigurationUnitType;
import com.sas.solstice.platform.core.model.DeploymentDescriptorType;
import com.sas.solstice.platform.core.model.DisplayTextType;
import com.sas.solstice.platform.core.model.IdentityType;
import com.sas.solstice.platform.core.model.InstallableUnitType;
import com.sas.solstice.platform.core.model.LocalizationUnitType;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeploymentDescriptorExt
extends DeploymentDescriptorType {
    private static final Logger LOGGER = LogManager.getLogger(DeploymentDescriptorExt.class);
    private static final long serialVersionUID = -5123968477354965676L;
    @XmlTransient
    private PackageDescriptorExt _packageDescriptor;

    private void generateResolveLogMessageFor(String variable) {
        String message = String.format("PackageDescriptor::resolveDeploymentProperties() - there are no \"%s\" types in this package to resolve properties for.", variable);
        LOGGER.info(message);
    }

    public PackageDescriptorExt getPackageDescriptor() {
        return this._packageDescriptor;
    }

    public void resolveDeploymentProperties(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties must not be null");
        }
        LOGGER.info("PackageDescriptor::resolveDeploymentProperties() - resolving properties from Package Descriptor");
        boolean empty = properties.isEmpty();
        if (empty) {
            return;
        }
        List<CompositeInstallableType> compositeInstallable = this.getCompositeInstallable();
        this.resolvePropertiesForUnit(properties, compositeInstallable);
        InstallableUnitType installableUnit = this.getInstallableUnit();
        this.resolvePropertiesForUnit(properties, installableUnit);
        ConfigurationUnitType configurationUnit = this.getConfigurationUnit();
        this.resolvePropertiesForUnit(properties, configurationUnit);
        LocalizationUnitType localizationUnit = this.getLocalizationUnit();
        this.resolvePropertiesForUnit(properties, localizationUnit);
    }

    private void resolveProperties(Properties properties, IdentityType identity) {
        DisplayTextType name = identity.getName();
        String translatedName = null;
        if (name != null) {
            translatedName = this.setValueFor(properties, name);
        }
        DisplayTextType description = identity.getDescription();
        String translatedDescription = null;
        if (description != null) {
            translatedDescription = this.setValueFor(properties, description);
        }
        DisplayTextType shortDescription = identity.getShortDescription();
        String translatedShortDescription = null;
        if (shortDescription != null) {
            translatedShortDescription = this.setValueFor(properties, shortDescription);
        }
        String message = String.format("DeploymentDescriptor::resolveDeploymentProperties() - found properties:", new Object[0]);
        LOGGER.info(message);
        message = String.format(" translatedName:\"%s\"", translatedName);
        LOGGER.info(message);
        message = String.format(" translatedDescription:\"%s\"", translatedDescription);
        LOGGER.info(message);
        message = String.format(" translatedShortDescription:\"%s\"", translatedShortDescription);
        LOGGER.info(message);
    }

    private void resolvePropertiesFor(Properties properties, IdentityType identity) {
        if (identity == null) {
            return;
        }
        this.resolveProperties(properties, identity);
    }

    private void resolvePropertiesForUnit(Properties properties, ConfigurationUnitType configurationUnit) {
        if (configurationUnit == null) {
            this.generateResolveLogMessageFor("configuration unit");
            return;
        }
        IdentityType identity = configurationUnit.getIdentity();
        this.resolvePropertiesFor(properties, identity);
    }

    private void resolvePropertiesForUnit(Properties properties, InstallableUnitType installableUnit) {
        if (installableUnit == null) {
            this.generateResolveLogMessageFor("installation unit");
            return;
        }
        IdentityType identity = installableUnit.getIdentity();
        this.resolvePropertiesFor(properties, identity);
    }

    private void resolvePropertiesForUnit(Properties properties, List<CompositeInstallableType> compositeInstallable) {
        boolean empty = compositeInstallable.isEmpty();
        if (empty) {
            this.generateResolveLogMessageFor("composite installable unit");
            return;
        }
        for (CompositeInstallableType composite : compositeInstallable) {
            IdentityType identity = composite.getIdentity();
            this.resolvePropertiesFor(properties, identity);
        }
    }

    private void resolvePropertiesForUnit(Properties properties, LocalizationUnitType localizationUnit) {
        if (localizationUnit == null) {
            this.generateResolveLogMessageFor("localization unit");
            return;
        }
        IdentityType identity = localizationUnit.getIdentity();
        this.resolvePropertiesFor(properties, identity);
    }

    public void setPackageDescriptor(PackageDescriptorExt packageDescriptor) {
        this._packageDescriptor = packageDescriptor;
    }

    private String setValueFor(Properties properties, DisplayTextType displayText) {
        if (displayText == null) {
            return null;
        }
        String key = displayText.getTranslationKey();
        if (key == null) {
            return null;
        }
        String translatedValue = properties.getProperty(key);
        if (translatedValue == null) {
            return null;
        }
        displayText.setValue(translatedValue);
        return translatedValue;
    }
}

