/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.common.control;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class AgentInfo
implements Serializable {
    private static final long serialVersionUID = -676750798473886718L;
    static final String EQUAL = "=";
    static final String NEWLINE = "\n";
    static final String TAB = "\t";
    static final String OUT_AGENT_INFORMATION = "Agent Information:";
    static final String OUT_CONFIGURATION_PROPERTIES = "Configuration properties:";
    static final String OUT_INSTALL_LOCATION_IS = "Install location is ";
    static final String OUT_IS = " is ";
    static final String OUT_IS_NOT = " is not ";
    static final String OUT_PROVISIONING = "Provisioning";
    static final String OUT_SUPPORTED = "supported";
    static final String OUT_VERSION_IS = "Version is ";
    static final String SOLSTICE_PREFIX = "solstice.";
    private String _agentVersion;
    private Boolean _canProvision;
    private Map<String, String> _configProperties;
    private String _installLocation;

    public AgentInfo(String agentVersion, String installLocation) {
        this.setAgentVersion(agentVersion);
        this.setCanProvision(null);
        this.setInstallLocation(installLocation);
        this.setConfigProperties(new TreeMap<String, String>());
        this.populateConfigProperties();
    }

    public String getAgentVersion() {
        return this._agentVersion;
    }

    public Boolean getCanProvision() {
        return this._canProvision;
    }

    public Map<String, String> getConfigProperties() {
        return this._configProperties;
    }

    public String getInstallLocation() {
        return this._installLocation;
    }

    public final void populateConfigProperties() {
        Properties sysProps = System.getProperties();
        Set<Map.Entry<Object, Object>> s = sysProps.entrySet();
        for (Map.Entry<Object, Object> entry : s) {
            String key = (String)entry.getKey();
            if (!key.startsWith(SOLSTICE_PREFIX) || key.equals("solstice.security.keystore.password") || key.equals("solstice.security.truststore.password")) continue;
            this._configProperties.put(key, (String)entry.getValue());
        }
    }

    public final void setAgentVersion(String agentVersion) {
        this._agentVersion = agentVersion;
    }

    public final void setCanProvision(Boolean canProvision) {
        this._canProvision = canProvision;
    }

    public final void setConfigProperties(Map<String, String> configProperties) {
        this._configProperties = configProperties;
    }

    public final void setInstallLocation(String installLocation) {
        this._installLocation = installLocation;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append(OUT_AGENT_INFORMATION);
        out.append(NEWLINE);
        out.append(OUT_VERSION_IS);
        out.append(this.getAgentVersion());
        out.append(NEWLINE);
        out.append(OUT_INSTALL_LOCATION_IS);
        out.append(this.getInstallLocation());
        out.append(NEWLINE);
        if (this.getCanProvision() != null) {
            out.append(OUT_PROVISIONING);
            out.append(this.getCanProvision() != false ? OUT_IS : OUT_IS_NOT);
            out.append(OUT_SUPPORTED);
            out.append(NEWLINE);
        }
        out.append(OUT_CONFIGURATION_PROPERTIES);
        out.append(NEWLINE);
        Set<Map.Entry<String, String>> props = this.getConfigProperties().entrySet();
        for (Map.Entry<String, String> prop : props) {
            out.append(TAB);
            out.append(prop.getKey());
            out.append(EQUAL);
            out.append(prop.getValue());
            out.append(NEWLINE);
        }
        out.append(NEWLINE);
        return out.toString();
    }
}

