/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.application.commands.security.internal;

import com.sas.deployment.application.commands.AbstractPropertyEditorCommand;
import com.sas.deployment.application.commands.PasswordParameterValidator;
import com.sas.deployment.property.editor.IPropertyEditor;
import com.sas.solstice.platform.application.common.api.IApplicationModel;
import com.sas.solstice.platform.application.common.api.command.IParameterSpecification;
import com.sas.solstice.platform.application.common.command.parameter.Parameter;
import java.util.Map;

class SetTruststorePasswordCommand
extends AbstractPropertyEditorCommand<IApplicationModel> {
    private static final String PASSWORD_ID = "solstice.security.truststore.password";

    SetTruststorePasswordCommand(IPropertyEditor propertyEditor) {
        super(propertyEditor);
    }

    @Override
    protected void buildParameterSpecification(IParameterSpecification specification) {
        specification.add(this.createSecurityPasswordParameter());
    }

    private IParameterSpecification.IParameter createSecurityPasswordParameter() {
        Parameter parameter = new Parameter(PASSWORD_ID, "Truststore Password");
        parameter.setValidator(new PasswordParameterValidator());
        parameter.setUsage("The truststore password.");
        return parameter;
    }

    @Override
    public int execute(IApplicationModel model, Map<String, String> parameters) {
        String value = parameters.get(PASSWORD_ID);
        this.setPassword(value);
        model.println("The truststore password has been set.");
        return 0;
    }

    @Override
    public String getDecoration() {
        String value = this.getPassword();
        return this.toSensitiveString(value);
    }

    private String getPassword() {
        return this.getProperty(PASSWORD_ID);
    }

    private void setPassword(String password) {
        this.setProperty(PASSWORD_ID, password);
    }
}

