/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.application.commands.security.internal;

import com.sas.deployment.application.commands.AbstractPropertyEditorCommand;
import com.sas.deployment.property.editor.IPropertyEditor;
import com.sas.solstice.platform.application.common.api.IApplicationModel;
import com.sas.solstice.platform.application.common.api.command.IParameterSpecification;
import com.sas.solstice.platform.application.common.command.parameter.Parameter;
import com.sas.solstice.platform.application.common.command.validator.FileParameterValidator;
import java.util.Map;

class SetTruststoreCommand
extends AbstractPropertyEditorCommand<IApplicationModel> {
    private static final String TRUSTSTORE_FILE_ID = "solstice.security.truststore";

    SetTruststoreCommand(IPropertyEditor propertyEditor) {
        super(propertyEditor);
    }

    @Override
    protected void buildParameterSpecification(IParameterSpecification specification) {
        specification.add(this.createTruststoreFileParameter());
    }

    private IParameterSpecification.IParameter createTruststoreFileParameter() {
        Parameter parameter = new Parameter(TRUSTSTORE_FILE_ID, "Truststore File");
        String value = this.getTruststoreFile();
        parameter.setDefaultValue(value);
        parameter.setValidator(new FileParameterValidator());
        parameter.setUsage("The fully-qualified path to the truststore file.");
        return parameter;
    }

    @Override
    public int execute(IApplicationModel model, Map<String, String> parameters) {
        String value = parameters.get(TRUSTSTORE_FILE_ID);
        this.setTruststoreFile(value);
        String message = String.format("The truststore file has been set to \"%s\".", value);
        model.println(message);
        return 0;
    }

    @Override
    public String getDecoration() {
        return this.getTruststoreFile();
    }

    private String getTruststoreFile() {
        return this.getProperty(TRUSTSTORE_FILE_ID);
    }

    private void setTruststoreFile(String path) {
        this.setProperty(TRUSTSTORE_FILE_ID, path);
    }
}

