/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.application.commands.security.internal;

import com.sas.deployment.application.commands.AbstractPropertyEditorCommand;
import com.sas.deployment.property.editor.IPropertyEditor;
import com.sas.solstice.platform.application.common.api.IApplicationModel;
import com.sas.solstice.platform.application.common.api.command.IParameterSpecification;
import com.sas.solstice.platform.application.common.command.parameter.Parameter;
import com.sas.solstice.platform.application.common.command.validator.NumericParameterValidator;
import java.util.Map;

class SetPortCommand
extends AbstractPropertyEditorCommand<IApplicationModel> {
    private static final String PORT_ID = "solstice.agent.jmx.port";
    private static final String PORT_NAME = "Port";

    SetPortCommand(IPropertyEditor propertyEditor) {
        super(propertyEditor);
    }

    @Override
    protected void buildParameterSpecification(IParameterSpecification specification) {
        specification.add(this.createPortParameter());
    }

    private IParameterSpecification.IParameter createPortParameter() {
        Parameter parameter = new Parameter(PORT_ID, PORT_NAME);
        String value = this.getPort();
        parameter.setDefaultValue(value);
        parameter.setValidator(new NumericParameterValidator(1, 65535));
        parameter.setUsage("The port number (1-65535).");
        return parameter;
    }

    @Override
    public int execute(IApplicationModel model, Map<String, String> parameters) {
        String value = parameters.get(PORT_ID);
        this.setPort(value);
        String message = String.format("The port was set to \"%s\".", value);
        model.println(message);
        return 0;
    }

    @Override
    public String getDecoration() {
        return this.getPort();
    }

    private String getPort() {
        return this.getProperty(PORT_ID);
    }

    private void setPort(String port) {
        this.setProperty(PORT_ID, port);
    }
}

