/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.application.commands.security.internal;

import com.sas.deployment.application.commands.AbstractPropertyEditorCommand;
import com.sas.deployment.property.editor.IPropertyEditor;
import com.sas.solstice.platform.application.common.api.IApplicationModel;
import com.sas.solstice.platform.application.common.api.command.IParameterSpecification;
import com.sas.solstice.platform.application.common.command.parameter.Parameter;
import com.sas.solstice.platform.application.common.command.validator.FileParameterValidator;
import java.util.Map;

class SetKeystoreCommand
extends AbstractPropertyEditorCommand<IApplicationModel> {
    private static final String KEYSTORE_FILE_ID = "solstice.security.keystore";

    SetKeystoreCommand(IPropertyEditor propertyEditor) {
        super(propertyEditor);
    }

    @Override
    protected void buildParameterSpecification(IParameterSpecification specification) {
        specification.add(this.createKeystoreFileParameter());
    }

    private IParameterSpecification.IParameter createKeystoreFileParameter() {
        Parameter parameter = new Parameter(KEYSTORE_FILE_ID, "Keystore File");
        String value = this.getKeystoreFile();
        parameter.setDefaultValue(value);
        parameter.setValidator(new FileParameterValidator());
        parameter.setUsage("The fully-qualified path to the keystore file.");
        return parameter;
    }

    @Override
    public int execute(IApplicationModel model, Map<String, String> parameters) {
        String value = parameters.get(KEYSTORE_FILE_ID);
        this.setKeystoreFile(value);
        String message = String.format("The keystore file has been set to \"%s\".", value);
        model.println(message);
        return 0;
    }

    @Override
    public String getDecoration() {
        return this.getKeystoreFile();
    }

    private String getKeystoreFile() {
        return this.getProperty(KEYSTORE_FILE_ID);
    }

    private void setKeystoreFile(String path) {
        this.setProperty(KEYSTORE_FILE_ID, path);
    }
}

