/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.application.commands.internal;

import com.sas.deployment.application.commands.AbstractServiceWrapperEditorCommand;
import com.sas.deployment.servicewrapper.editor.IServiceWrapperEditor;
import com.sas.solstice.platform.application.common.api.command.IParameterSpecification;
import com.sas.solstice.platform.application.common.command.validator.FileParameterValidator;

public class SetJreCommand
extends AbstractServiceWrapperEditorCommand {
    public SetJreCommand(IServiceWrapperEditor serviceWrapperEditor) {
        super(serviceWrapperEditor);
    }

    @Override
    protected String getParameterId() {
        return "wrapper.java.command";
    }

    @Override
    protected String getParameterLabel() {
        return "JRE Path";
    }

    @Override
    protected String getParameterUsage() {
        return "The fully-qualified folder path to the JRE location.";
    }

    @Override
    protected IParameterSpecification.IParameterValidator getParameterValidator() {
        return new FileParameterValidator();
    }

    @Override
    protected String getPostExecutionMessage(String value) {
        return String.format("The JRE path has been set to \"%s\".", value);
    }

    @Override
    protected String toStorageFormat(String value) {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            return value;
        }
        if (osName.startsWith("Win")) {
            return value.replace('\\', '/');
        }
        return value;
    }
}

