/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.application.commands.internal;

import com.sas.deployment.application.commands.internal.SetJreCommand;
import com.sas.deployment.application.commands.internal.SetLogsLocationCommand;
import com.sas.deployment.property.editor.IPropertyEditor;
import com.sas.deployment.servicewrapper.editor.IServiceWrapperEditor;
import com.sas.solstice.platform.application.common.api.IApplicationModel;
import com.sas.solstice.platform.application.common.api.command.ICommand;
import com.sas.solstice.platform.application.common.api.command.ICommandProvider;
import com.sas.solstice.platform.application.common.api.command.ICommandRegistrar;
import com.sas.solstice.platform.application.common.command.UsageCommand;
import java.util.ArrayList;
import java.util.List;

public class Component {
    private IPropertyEditor propertyEditor;
    private IServiceWrapperEditor serviceWrapperEditor;
    private ICommandRegistrar commandRegistrar;
    private ICommandProvider commandProvider;
    private List<ICommand<IApplicationModel>> commands;

    public void activate() {
        List<ICommand<IApplicationModel>> commands = this.build();
        this.setCommands(commands);
        this.register();
    }

    private List<ICommand<IApplicationModel>> build() {
        ArrayList<ICommand<IApplicationModel>> commands = new ArrayList<ICommand<IApplicationModel>>(5);
        this.buildSetJreCommand(commands);
        this.buildSetLogsLocationCommand(commands);
        this.buildUsageCommand(commands);
        return commands;
    }

    private void buildSetJreCommand(List<ICommand<IApplicationModel>> commands) {
        IServiceWrapperEditor editor = this.getServiceWrapperEditor();
        SetJreCommand command = new SetJreCommand(editor);
        commands.add(command);
    }

    private void buildSetLogsLocationCommand(List<ICommand<IApplicationModel>> commands) {
        IPropertyEditor propertyEditor = this.getPropertyEditor();
        IServiceWrapperEditor serviceWrapperEditor = this.getServiceWrapperEditor();
        SetLogsLocationCommand command = new SetLogsLocationCommand(propertyEditor, serviceWrapperEditor);
        commands.add(command);
    }

    private void buildUsageCommand(List<ICommand<IApplicationModel>> commands) {
        ICommandProvider provider = this.getCommandProvider();
        UsageCommand command = new UsageCommand(provider);
        commands.add(command);
    }

    public void deactivate() {
        this.unregister();
        this.destroy();
    }

    private void destroy() {
        this.setCommands(null);
    }

    private ICommandProvider getCommandProvider() {
        return this.commandProvider;
    }

    private ICommandRegistrar getCommandRegistrar() {
        return this.commandRegistrar;
    }

    private List<ICommand<IApplicationModel>> getCommands() {
        return this.commands;
    }

    private IPropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    private IServiceWrapperEditor getServiceWrapperEditor() {
        return this.serviceWrapperEditor;
    }

    private void register() {
        List<ICommand<IApplicationModel>> commands = this.getCommands();
        for (ICommand<IApplicationModel> command : commands) {
            this.register(command);
        }
    }

    private void register(ICommand<IApplicationModel> command) {
        ICommandRegistrar registrar = this.getCommandRegistrar();
        registrar.register(command);
    }

    public void setCommandProvider(ICommandProvider commandProvider) {
        this.commandProvider = commandProvider;
    }

    public void setCommandRegistrar(ICommandRegistrar commandRegistrar) {
        this.commandRegistrar = commandRegistrar;
    }

    private void setCommands(List<ICommand<IApplicationModel>> commands) {
        this.commands = commands;
    }

    public void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
    }

    public void setServiceWrapperEditor(IServiceWrapperEditor serviceWrapperEditor) {
        this.serviceWrapperEditor = serviceWrapperEditor;
    }

    private void unregister() {
        List<ICommand<IApplicationModel>> commands = this.getCommands();
        for (ICommand<IApplicationModel> command : commands) {
            this.unregister(command);
        }
    }

    private void unregister(ICommand<IApplicationModel> command) {
        ICommandRegistrar registrar = this.getCommandRegistrar();
        registrar.unregister(command);
    }
}

