/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.application.commands;

import com.sas.deployment.servicewrapper.editor.IServiceWrapperEditor;
import com.sas.solstice.platform.application.common.api.IApplicationModel;
import com.sas.solstice.platform.application.common.api.command.IParameterSpecification;
import com.sas.solstice.platform.application.common.command.AbstractCommand;
import com.sas.solstice.platform.application.common.command.parameter.Parameter;
import java.util.Map;

public abstract class AbstractServiceWrapperEditorCommand
extends AbstractCommand<IApplicationModel> {
    private IServiceWrapperEditor serviceWrapperEditor;

    protected AbstractServiceWrapperEditorCommand(IServiceWrapperEditor serviceWrapperEditor) {
        if (serviceWrapperEditor == null) {
            throw new IllegalArgumentException("serviceWrapperEditor must not be null");
        }
        this.setServiceWrapperEditor(serviceWrapperEditor);
    }

    @Override
    protected void buildParameterSpecification(IParameterSpecification specification) {
        IParameterSpecification.IParameter parameter = this.createParameter();
        specification.add(parameter);
    }

    private IParameterSpecification.IParameter createParameter() {
        String id = this.getParameterId();
        String label = this.getParameterLabel();
        Parameter parameter = new Parameter(id, label);
        String value = this.getDefaultParameterValue();
        parameter.setDefaultValue(value);
        IParameterSpecification.IParameterValidator validator = this.getParameterValidator();
        parameter.setValidator(validator);
        boolean sensitive = this.isParameterSensitive();
        parameter.setSensitive(sensitive);
        String usage = this.getParameterUsage();
        parameter.setUsage(usage);
        return parameter;
    }

    private void displayPostExecutionMessage(IApplicationModel model, String value) {
        String message = this.getPostExecutionMessage(value);
        if (message == null) {
            return;
        }
        model.println(message);
    }

    @Override
    public int execute(IApplicationModel model, Map<String, String> parameters) {
        String value = this.storeParameterValue(parameters);
        this.displayPostExecutionMessage(model, value);
        return 0;
    }

    protected String fromStorageFormat(String value) {
        return value;
    }

    @Override
    public final String getDecoration() {
        String value = this.load();
        boolean sensitive = this.isParameterSensitive();
        if (sensitive) {
            return this.toSensitiveString(value);
        }
        return this.toDecorationFormat(value);
    }

    protected String getDefaultParameterValue() {
        return this.load();
    }

    protected abstract String getParameterId();

    protected abstract String getParameterLabel();

    protected abstract String getParameterUsage();

    protected IParameterSpecification.IParameterValidator getParameterValidator() {
        return null;
    }

    protected abstract String getPostExecutionMessage(String var1);

    private String getProperty(String key) {
        IServiceWrapperEditor editor = this.getServiceWrapperEditor();
        return editor.getProperty(key);
    }

    private IServiceWrapperEditor getServiceWrapperEditor() {
        return this.serviceWrapperEditor;
    }

    protected boolean isParameterSensitive() {
        return false;
    }

    private String load() {
        String id = this.getParameterId();
        String value = this.getProperty(id);
        return this.fromStorageFormat(value);
    }

    private void setProperty(String key, String value) {
        IServiceWrapperEditor editor = this.getServiceWrapperEditor();
        editor.setProperty(key, value);
    }

    private void setServiceWrapperEditor(IServiceWrapperEditor serviceWrapperEditor) {
        this.serviceWrapperEditor = serviceWrapperEditor;
    }

    private void store(String id, String value) {
        String formattedValue = this.toStorageFormat(value);
        this.setProperty(id, formattedValue);
    }

    private String storeParameterValue(Map<String, String> parameters) {
        String id = this.getParameterId();
        String value = parameters.get(id);
        this.store(id, value);
        return value;
    }

    protected String toDecorationFormat(String value) {
        return value;
    }

    protected String toStorageFormat(String value) {
        return value;
    }
}

