/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.agent.main;

import com.sas.deployment.agent.app.Agent;
import com.sas.deployment.agent.app.bundle.AgentDataComponent;
import com.sas.deployment.agent.events.internal.OperationEventBroadcaster;
import com.sas.deployment.agent.jmx.server.Server;
import com.sas.deployment.agent.main.api.IInstanceRegistry;
import com.sas.deployment.agent.main.api.IStoppable;
import com.sas.deployment.common.control.AgentMBean;
import com.sas.deployment.common.control.IAgentDataComponent;
import com.sas.deployment.common.control.OperationEventBroadcasterMBean;
import com.sas.deployment.property.internal.bundle.Component;
import com.sas.solstice.platform.api.deployment.IDeployAPI;
import com.sas.solstice.platform.core.IEventSender;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;

class InstanceRegistry
implements IInstanceRegistry {
    private static final int DEFAULT_SIZE = 15;
    private Map<Class<?>, Object> instances;
    private List<IStoppable> stoppables;

    InstanceRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStoppable(IStoppable stoppable) {
        InstanceRegistry instanceRegistry = this;
        synchronized (instanceRegistry) {
            List<IStoppable> stoppables = this.getStoppables();
            stoppables.add(stoppable);
        }
    }

    private <T> T create(Class<T> clazz) {
        if (clazz == IAgentDataComponent.class) {
            return (T)this.createAgentDataComponent();
        }
        if (clazz == AgentMBean.class) {
            return (T)this.createAgent();
        }
        if (clazz == Component.class) {
            return (T)this.createComponent();
        }
        if (clazz == IDeployAPI.class) {
            return (T)this.createDeployApi();
        }
        if (clazz == IEventSender.class) {
            return (T)this.createEventSender();
        }
        if (clazz == OperationEventBroadcasterMBean.class) {
            return (T)this.createOperationEventBroadcasterMBean();
        }
        if (clazz == Server.class) {
            return (T)this.createServer();
        }
        return null;
    }

    private AgentMBean createAgent() {
        Agent instance = new Agent();
        IAgentDataComponent agentDataComponent = this.getAgentDataComponent();
        instance.setAgentDataComponent(agentDataComponent);
        IDeployAPI deployApi = this.getDeployApi();
        instance.setDeployAPI(deployApi);
        instance.start();
        this.addStoppable(() -> instance.stopAgent());
        return instance;
    }

    private IAgentDataComponent createAgentDataComponent() {
        AgentDataComponent instance = new AgentDataComponent();
        instance.start();
        this.addStoppable(() -> instance.stop());
        return instance;
    }

    private Component createComponent() {
        Component instance = new Component();
        instance.activate();
        this.addStoppable(() -> instance.deactivate());
        return instance;
    }

    private IDeployAPI createDeployApi() {
        return null;
    }

    private IEventSender createEventSender() {
        return (IEventSender)((Object)this.getOperationEventBroadcasterMBean());
    }

    private OperationEventBroadcasterMBean createOperationEventBroadcasterMBean() {
        OperationEventBroadcaster instance = new OperationEventBroadcaster();
        try {
            instance.start();
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException exception) {
            exception.printStackTrace();
        }
        IStoppable stoppable = () -> {
            try {
                instance.stop();
            }
            catch (InstanceNotFoundException | MBeanRegistrationException exception) {
                exception.printStackTrace();
            }
        };
        this.addStoppable(stoppable);
        return instance;
    }

    private Server createServer() {
        Server instance = new Server();
        OperationEventBroadcasterMBean eventBroadcaster = this.getOperationEventBroadcasterMBean();
        instance.setEventBroadcaster(eventBroadcaster);
        AgentMBean agent = this.getAgent();
        instance.setImplementation(agent);
        try {
            instance.start();
        }
        catch (IOException | InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException exception) {
            exception.printStackTrace();
        }
        IStoppable stoppable = () -> {
            try {
                instance.stop();
            }
            catch (IOException | InstanceNotFoundException | MBeanRegistrationException exception) {
                exception.printStackTrace();
            }
        };
        this.addStoppable(stoppable);
        return instance;
    }

    private <T> T get(Class<T> clazz) {
        String name = clazz.getSimpleName();
        Map<Class<?>, Object> instances = this.getInstances();
        Object instance = instances.get(clazz);
        if (instance == null) {
            instance = this.create(clazz);
            if (instance == null) {
                this.log("Failed to created an instance of %s", name);
                return null;
            }
            instances.put(clazz, instance);
            this.log("Registered %s: %s", name, instance);
        }
        this.log("Getting %s: %s", name, instance);
        return (T)instance;
    }

    @Override
    public AgentMBean getAgent() {
        return this.get(AgentMBean.class);
    }

    @Override
    public IAgentDataComponent getAgentDataComponent() {
        return this.get(IAgentDataComponent.class);
    }

    @Override
    public Component getComponent() {
        return this.get(Component.class);
    }

    @Override
    public IDeployAPI getDeployApi() {
        return this.get(IDeployAPI.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Class<?>, Object> getInstances() {
        InstanceRegistry instanceRegistry = this;
        synchronized (instanceRegistry) {
            if (this.instances == null) {
                HashMap instances = new HashMap(15);
                this.setInstances(instances);
            }
            return this.instances;
        }
    }

    private OperationEventBroadcasterMBean getOperationEventBroadcasterMBean() {
        return this.get(OperationEventBroadcasterMBean.class);
    }

    @Override
    public Server getServer() {
        return this.get(Server.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IStoppable> getStoppables() {
        InstanceRegistry instanceRegistry = this;
        synchronized (instanceRegistry) {
            if (this.stoppables == null) {
                ArrayList<IStoppable> stoppables = new ArrayList<IStoppable>(15);
                this.setStoppables(stoppables);
            }
            return this.stoppables;
        }
    }

    private void log(String format, Object ... values) {
    }

    private void setInstances(Map<Class<?>, Object> instances) {
        this.instances = instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStoppables(List<IStoppable> stoppables) {
        InstanceRegistry instanceRegistry = this;
        synchronized (instanceRegistry) {
            this.stoppables = stoppables;
        }
    }

    @Override
    public void start() {
        this.log("started", new Object[0]);
    }

    @Override
    public void stop() {
        this.stopStoppables();
        this.setInstances(null);
        this.log("stopped", new Object[0]);
    }

    private void stopStoppables() {
        List<IStoppable> stoppables = this.getStoppables();
        for (IStoppable stoppable : stoppables) {
            this.log("stopping %s", stoppable);
            stoppable.stop();
        }
        this.setStoppables(null);
    }
}

