/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.agent.jmx.client.internal;

import com.sas.deployment.agent.jmx.client.internal.Log;
import com.sas.deployment.agent.jmx.client.internal.OperationEventListener;
import com.sas.deployment.common.control.AgentMBean;
import com.sas.deployment.common.utilities.SecurityConfig;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

class RemoteAgentManager
implements NotificationListener {
    private static final String LOCALHOST_NAME = "localhost";
    private static final String FAILED_TO_CONNECT = "Failed to connect to the host \"%s\".";
    private static final String PORT = "port";
    private static final Log LOG = RemoteAgentManager.createLog();
    private String _host;
    private AgentMBean _agent;
    private JMXConnector _connector;
    private ObjectName _eventBroadcasterMBeanName;
    private NotificationListener _eventListener;
    private static SecurityConfig securityConfig;

    private static Log createLog() {
        return new Log(RemoteAgentManager.class);
    }

    private static void logDebug(String message, Object ... values) {
        LOG.debug(message, values);
    }

    private static void logDebug(String message, Throwable throwable, Object ... values) {
        LOG.debug(message, throwable, values);
    }

    private static void logError(String message, Object ... values) {
        LOG.error(message, values);
    }

    private static void logError(String message, Throwable throwable, Object ... values) {
        LOG.error(message, throwable, values);
    }

    private static void logInfo(String message, Throwable throwable, Object ... values) {
        LOG.info(message, throwable, values);
    }

    RemoteAgentManager(String host) {
        this(host, null);
    }

    RemoteAgentManager(String host, Properties securityProperties) {
        this.setHost(host);
        RemoteAgentManager.initializeSecurity(securityProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeSecurity(Properties securityProperties) {
        Class<RemoteAgentManager> clazz = RemoteAgentManager.class;
        synchronized (RemoteAgentManager.class) {
            if (RemoteAgentManager.getSecurityConfig() == null) {
                SecurityConfig config = RemoteAgentManager.createSecurityConfig(securityProperties);
                RemoteAgentManager.setSecurityConfig(config);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void addProtocolProviderPackagesPropertyTo(Map<String, Object> environment) {
        String value = "com.sun.jmx.remote.protocol";
        RemoteAgentManager.logDebug("Adding protocol provider packages to environment: \"%s\".", value);
        environment.put("jmx.remote.protocol.provider.pkgs", value);
    }

    private void addSecurityPropertiesTo(Map<String, Object> environment) throws IOException {
        RemoteAgentManager.logDebug("Adding security config properties to environment.", new Object[0]);
        SecurityConfig config = RemoteAgentManager.getSecurityConfig();
        try {
            config.addSecurityToClientEnvironment(environment);
        }
        catch (Exception e) {
            String message = e.getMessage();
            IOException ioEx = new IOException(message);
            StackTraceElement[] stack = e.getStackTrace();
            ioEx.setStackTrace(stack);
            throw ioEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AgentMBean basicGetAgent() {
        RemoteAgentManager remoteAgentManager = this;
        synchronized (remoteAgentManager) {
            return this._agent;
        }
    }

    private String basicToString() {
        return super.toString();
    }

    private JMXConnector connectToRemoteHost() throws IOException {
        RemoteAgentManager.logDebug("Connecting to remote host.", new Object[0]);
        JMXConnector connector = this.createRemoteConnector();
        this.setConnector(connector);
        connector.addConnectionNotificationListener(this, null, null);
        connector.connect();
        RemoteAgentManager.logDebug("Connected to \"%s\".", connector);
        return connector;
    }

    private AgentMBean createAgent() throws IOException {
        JMXConnector connector = this.connectToRemoteHost();
        try {
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            AgentMBean agent = this.createMBeanProxy(connection);
            if (agent.isProvisioningSupported()) {
                this.createNotificationListener(connection);
            }
            return agent;
        }
        catch (IOException exception) {
            RemoteAgentManager.logError("Failed to create proxy to AgentMBean.", exception, new Object[0]);
            this.disconnectFromRemoteHost();
            throw exception;
        }
    }

    private AgentMBean createMBeanProxy(MBeanServerConnection connection) throws IOException {
        RemoteAgentManager.logDebug("Creating proxy to AgentMBean using the connection \"%s\".", connection);
        ObjectName name = this.createRemoteMBeanName("com.sas.solstice:TYPE=Agent");
        RemoteAgentManager.logDebug("Created MBean name \"%s\".", name);
        AgentMBean agent = JMX.newMBeanProxy(connection, name, AgentMBean.class, true);
        RemoteAgentManager.logDebug("Created proxy to AgentMBean \"%s\".", agent);
        return agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNotificationListener(MBeanServerConnection connection) throws IOException {
        ObjectName name;
        RemoteAgentManager.logDebug("Registering notification listener", new Object[0]);
        RemoteAgentManager remoteAgentManager = this;
        synchronized (remoteAgentManager) {
            name = this.getEventBroadcasterMBeanName();
            if (name == null) {
                name = this.createRemoteMBeanName("com.sas.solstice:TYPE=EventBroadcaster");
                this.setEventBroadcasterMBeanName(name);
            }
        }
        OperationEventListener listener = new OperationEventListener();
        try {
            connection.addNotificationListener(name, listener, null, (Object)connection);
            this.setEventListener(listener);
        }
        catch (InstanceNotFoundException infEx) {
            String msg = "Failed to register OperationEventListener. Notifications disabled.";
            RemoteAgentManager.logInfo(msg, infEx, new Object[0]);
        }
    }

    private JMXConnector createRemoteConnector() throws IOException {
        Map<String, Object> environment = this.createRemoteEnvironment();
        JMXServiceURL url = this.createRemoteServiceUrl();
        RemoteAgentManager.logDebug("Trying to connect to \"%s\".", url);
        return JMXConnectorFactory.connect(url, environment);
    }

    private Map<String, Object> createRemoteEnvironment() throws IOException {
        RemoteAgentManager.logDebug("Creating remote environment.", new Object[0]);
        HashMap<String, Object> environment = new HashMap<String, Object>();
        this.addProtocolProviderPackagesPropertyTo(environment);
        this.addSecurityPropertiesTo(environment);
        RemoteAgentManager.logDebug("Created remote environment \"%s\".", environment);
        return environment;
    }

    private ObjectName createRemoteMBeanName(String name) throws IOException {
        RemoteAgentManager.logDebug("Creating remote MBean name \"%s\".", name);
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException exception) {
            String host = this.getHost();
            String message = String.format("Failed to create remote MBean name \"%s\" for the host \"%s\".", name, host);
            RemoteAgentManager.logDebug(message, exception, new Object[0]);
            throw new IOException(message, exception);
        }
    }

    private JMXServiceURL createRemoteServiceUrl() throws IOException {
        String spec = this.createRemoteUrlSpec();
        RemoteAgentManager.logDebug("Creating a JMXServiceURL for the spec \"%s\".", spec);
        try {
            return new JMXServiceURL(spec);
        }
        catch (MalformedURLException exception) {
            String host = this.getHost();
            String message = String.format("Failed to create remote service URL \"%s\" for the host \"%s\".", spec, host);
            RemoteAgentManager.logError(message, exception, new Object[0]);
            throw new IOException(message, exception);
        }
    }

    private String createRemoteUrlSpec() {
        String spec = "service:jmx:jmxmp://";
        String host = this.getHost();
        String port = this.getRemotePort();
        spec = spec.concat(host);
        spec = spec.concat(":");
        spec = spec.concat(port);
        RemoteAgentManager.logDebug("Created the remote URL spec \"%s\".", spec);
        return spec;
    }

    private static SecurityConfig createSecurityConfig(Properties securityProperties) {
        RemoteAgentManager.logDebug("Creating security config and setting TLS properties.", new Object[0]);
        SecurityConfig instance = new SecurityConfig(securityProperties, false);
        instance.setTlsProperties();
        return instance;
    }

    private void disconnectFromRemoteHost() {
        JMXConnector connector = this.getConnector();
        this.removeNotificationListener(connector);
        RemoteAgentManager.logDebug("Closing the JMXConnector \"%s\".", connector);
        try {
            connector.close();
            RemoteAgentManager.logDebug("Closed the JMXConnector \"%s\".", connector);
            this.removeConnectorNotificationListener(connector);
        }
        catch (IOException exception) {
            RemoteAgentManager.logError("Failed to close the JMXConnector \"%s\". Reason: \"%s\".", connector, exception);
        }
        finally {
            this.setConnector(null);
        }
    }

    AgentMBean getAgent() {
        AgentMBean agent = this.basicGetAgent();
        if (agent != null) {
            RemoteAgentManager.logDebug("Getting the agent MBean \"%s\".", agent);
            return agent;
        }
        throw new IllegalStateException("remote agent manager has not been started");
    }

    private JMXConnector getConnector() {
        return this._connector;
    }

    private ObjectName getEventBroadcasterMBeanName() {
        return this._eventBroadcasterMBeanName;
    }

    private NotificationListener getEventListener() {
        return this._eventListener;
    }

    private String getHost() {
        return this._host;
    }

    private String getRemotePort() {
        String port = System.getProperty("solstice.agent.jmx.port", "5660");
        RemoteAgentManager.logDebug("The remote port is \"%s\".", port);
        return port;
    }

    private static SecurityConfig getSecurityConfig() {
        return securityConfig;
    }

    @Override
    public void handleNotification(Notification notif, Object handback) {
        if (notif instanceof JMXConnectionNotification) {
            JMXConnectionNotification conNotif = (JMXConnectionNotification)notif;
            if (conNotif.getType().equals("jmx.remote.connection.closed")) {
                LOG.debug(String.format("JMX connection closed for %s", conNotif.getConnectionId()), new Object[0]);
            } else if (conNotif.getType().equals("jmx.remote.connection.failed")) {
                LOG.warn(String.format("JMX connection failed for %s", conNotif.getConnectionId()), new Object[0]);
            } else if (conNotif.getType().equals("jmx.remote.connection.opened")) {
                LOG.debug(String.format("New JMX connection opened for %s", conNotif.getConnectionId()), new Object[0]);
            } else if (conNotif.getType().equals("jmx.remote.connection.notifs.lost")) {
                LOG.warn(String.format("JMX connection for %s may have lost notifications", conNotif.getConnectionId()), new Object[0]);
            }
        } else {
            LOG.debug(String.format("Notification received: %s", notif.toString()), new Object[0]);
        }
    }

    boolean isAgentAvailable() {
        String host = this.getHost();
        RemoteAgentManager.logDebug("Check to see if the agent is available at the host \"%s\".", host);
        boolean available = true;
        try {
            this.createAgent();
            this.disconnectFromRemoteHost();
        }
        catch (IOException exception) {
            RemoteAgentManager.logDebug(FAILED_TO_CONNECT, exception, host);
            available = false;
        }
        catch (UndeclaredThrowableException exception) {
            RemoteAgentManager.logDebug(FAILED_TO_CONNECT, exception, host);
            available = false;
        }
        RemoteAgentManager.logDebug("Is the agent available at the host \"%s\"? %s", host, available);
        return available;
    }

    boolean isStarted() {
        return !this.isStopped();
    }

    private boolean isStopped() {
        AgentMBean agent = this.basicGetAgent();
        boolean status = agent == null;
        return status;
    }

    private void printHostOn(StringBuffer buffer) {
        String host = this.getHost();
        String value = String.format(", host=\"%s\"", host);
        buffer.append(value);
    }

    private void printOn(StringBuffer buffer) {
        String value = this.basicToString();
        buffer.append(value);
        this.printHostOn(buffer);
    }

    private void removeConnectorNotificationListener(JMXConnector connector) {
        try {
            connector.removeConnectionNotificationListener(this);
        }
        catch (ListenerNotFoundException lnfEx) {
            String msg = String.format("Failure removing notification listener for JMX connector to %s", this.getHost());
            LOG.warn(msg, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNotificationListener(JMXConnector connector) {
        ObjectName broadcaster = this.getEventBroadcasterMBeanName();
        NotificationListener listener = this.getEventListener();
        if (listener == null) {
            return;
        }
        try {
            LOG.debug(String.format("Removing notification listener for events from %s", broadcaster), new Object[0]);
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            connection.removeNotificationListener(broadcaster, listener);
        }
        catch (IOException ioEx) {
            String msg = String.format("Failure removing notification listener for events from %s, unable to get MBeanServerConnection.", this.getHost());
            LOG.warn(msg, ioEx);
        }
        catch (InstanceNotFoundException infEx) {
            String msg = String.format("Failure removing notification listener for events from %s, %s MBean not found.", this.getHost(), broadcaster);
            LOG.warn(msg, infEx);
        }
        catch (ListenerNotFoundException lnfEx) {
            String msg = String.format("Failure removing notification listener for events from %s, no listener found.", this.getHost());
            LOG.warn(msg, lnfEx);
        }
        finally {
            this.setEventListener(null);
        }
    }

    private void setAgent(AgentMBean agent) {
        this._agent = agent;
    }

    private void setConnector(JMXConnector connector) {
        this._connector = connector;
    }

    private void setEventBroadcasterMBeanName(ObjectName name) {
        this._eventBroadcasterMBeanName = name;
    }

    private void setEventListener(NotificationListener listener) {
        this._eventListener = listener;
    }

    final void setHost(String host) {
        this._host = host;
    }

    private static void setSecurityConfig(SecurityConfig config) {
        securityConfig = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() throws IOException {
        RemoteAgentManager.logDebug("Starting.", new Object[0]);
        RemoteAgentManager remoteAgentManager = this;
        synchronized (remoteAgentManager) {
            boolean started = this.isStarted();
            if (started) {
                RemoteAgentManager.logDebug("Already started.", new Object[0]);
                return;
            }
            AgentMBean agent = this.createAgent();
            this.setAgent(agent);
        }
        RemoteAgentManager.logDebug("Started.", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        RemoteAgentManager.logDebug("Stopping.", new Object[0]);
        RemoteAgentManager remoteAgentManager = this;
        synchronized (remoteAgentManager) {
            boolean stopped = this.isStopped();
            if (stopped) {
                RemoteAgentManager.logDebug("Already stopped.", new Object[0]);
                return;
            }
            try {
                this.disconnectFromRemoteHost();
            }
            finally {
                this.setAgent(null);
            }
        }
        RemoteAgentManager.logDebug("Stopped.", new Object[0]);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        this.printOn(buffer);
        return buffer.toString();
    }
}

