/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.agent.jmx.client.internal;

import com.sas.deployment.agent.jmx.client.api.IAgentMBeanProvider;
import com.sas.deployment.agent.jmx.client.internal.Log;
import com.sas.deployment.agent.jmx.client.internal.OperationEventListener;
import com.sas.deployment.agent.jmx.client.internal.RemoteAgentManager;
import com.sas.deployment.common.control.AgentMBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class AgentMBeanProvider
implements IAgentMBeanProvider {
    private static final Log LOG = AgentMBeanProvider.createLog();
    private AgentMBean _localAgent;
    private MBeanServer _localMBeanServer;
    private NotificationListener _localEventListener;
    private ObjectName _localEventBroadcasterMBeanName;
    private Map<String, RemoteAgentManager> _remoteAgentManagersByHost;

    private static Log createLog() {
        return new Log(AgentMBeanProvider.class);
    }

    private static void logDebug(String message, Object ... values) {
        LOG.debug(message, values);
    }

    private static void logError(String message, Object ... values) {
        LOG.error(message, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteAgentManager basicGetRemoteAgentManager(String host) {
        AgentMBeanProvider agentMBeanProvider = this;
        synchronized (agentMBeanProvider) {
            Map<String, RemoteAgentManager> map = this.getRemoteAgentManagersByHost();
            return map.get(host);
        }
    }

    private RemoteAgentManager createAndStartRemoteAgentManager(String host, Properties securityProperties) throws IOException {
        RemoteAgentManager manager = this.createRemoteAgentManager(host, securityProperties);
        this.startRemoteAgentManager(manager);
        return manager;
    }

    private RemoteAgentManager createRemoteAgentManager(String host, Properties securityProperties) {
        AgentMBeanProvider.logDebug("Creating RemoteAgentManager for the host \"%s\".", host);
        RemoteAgentManager manager = new RemoteAgentManager(host, securityProperties);
        AgentMBeanProvider.logDebug("Created RemoteAgentManager: \"%s\".", manager);
        return manager;
    }

    private void createNotificationListener(MBeanServerConnection connection) throws IOException {
        AgentMBeanProvider.logDebug("Registering notification listener", new Object[0]);
        ObjectName name = this.createEventBroadcasterMBeanName();
        this.setLocalEventListener(new OperationEventListener());
        try {
            connection.addNotificationListener(name, this.getLocalEventListener(), null, (Object)connection);
            AgentMBeanProvider.logDebug("Notification listener successfully registered", new Object[0]);
        }
        catch (InstanceNotFoundException infEx) {
            String msg = "Failed to register OperationEventListener. Notifications disabled.";
            AgentMBeanProvider.logError(msg, infEx);
            this.setLocalEventListener(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectName createEventBroadcasterMBeanName() throws IOException {
        String name = "com.sas.solstice:TYPE=EventBroadcaster";
        AgentMBeanProvider.logDebug("Creating MBean name \"%s\".", name);
        ObjectName on = null;
        try {
            AgentMBeanProvider agentMBeanProvider = this;
            synchronized (agentMBeanProvider) {
                on = this.getLocalEventBroadcasterMBeanName();
                if (on == null) {
                    on = new ObjectName("com.sas.solstice:TYPE=EventBroadcaster");
                    this.setLocalEventBroadcasterMBeanName(on);
                }
            }
            return on;
        }
        catch (MalformedObjectNameException exception) {
            String message = String.format("Failed to create events MBean name \"%s\".", name);
            AgentMBeanProvider.logDebug(message, exception);
            throw new IOException(message, exception);
        }
    }

    private AgentMBean getLocalAgent() {
        return this._localAgent;
    }

    private ObjectName getLocalEventBroadcasterMBeanName() {
        return this._localEventBroadcasterMBeanName;
    }

    private NotificationListener getLocalEventListener() {
        return this._localEventListener;
    }

    private MBeanServer getLocalMBeanServer() {
        if (this._localMBeanServer == null) {
            this._localMBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        return this._localMBeanServer;
    }

    private AgentMBean getRemoteAgent(String host, Properties securityProperties) throws IOException {
        RemoteAgentManager manager = this.getRemoteAgentManager(host, securityProperties);
        AgentMBean agent = manager.getAgent();
        AgentMBeanProvider.logDebug("The remote agent for the host \"%s\" is \"%s\".", host, agent);
        return agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteAgentManager getRemoteAgentManager(String host, Properties securityProperties) throws IOException {
        RemoteAgentManager manager;
        AgentMBeanProvider.logDebug("Getting the remote agent for the host \"%s\".", host);
        AgentMBeanProvider agentMBeanProvider = this;
        synchronized (agentMBeanProvider) {
            manager = this.basicGetRemoteAgentManager(host);
            if (manager == null) {
                manager = this.createAndStartRemoteAgentManager(host, securityProperties);
                Map<String, RemoteAgentManager> map = this.getRemoteAgentManagersByHost();
                map.put(host, manager);
            }
        }
        AgentMBeanProvider.logDebug("Got the remote agent manager %s.", manager);
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, RemoteAgentManager> getRemoteAgentManagersByHost() {
        AgentMBeanProvider agentMBeanProvider = this;
        synchronized (agentMBeanProvider) {
            if (this._remoteAgentManagersByHost == null) {
                HashMap<String, RemoteAgentManager> map = new HashMap<String, RemoteAgentManager>(11);
                this.setRemoteAgentManagersByHost(map);
            }
            return this._remoteAgentManagersByHost;
        }
    }

    @Override
    public boolean isAgentAvailable(String host, Properties connectionProperties) {
        AgentMBeanProvider.logDebug("Checking to see if an agent is available at the host \"%s\".", host);
        boolean remote = this.isRemoteHost(host);
        boolean available = remote ? this.isRemoteAgentAvailable(host, connectionProperties) : this.isLocalAgentAvailable();
        AgentMBeanProvider.logDebug("Agent is available?: %s", available);
        return available;
    }

    private boolean isLocalAgentAvailable() {
        AgentMBeanProvider.logDebug("Checking to see if a local agent is available.", new Object[0]);
        return true;
    }

    private boolean isRemoteAgentAvailable(String host, Properties connectionProperties) {
        AgentMBeanProvider.logDebug("Checking to see if a remote agent is available at the host \"%s\".", host);
        RemoteAgentManager manager = new RemoteAgentManager(host, connectionProperties);
        return manager.isAgentAvailable();
    }

    private boolean isRemoteHost(String host) {
        boolean remote = host != null;
        AgentMBeanProvider.logDebug("Is the host \"%s\" remote?: %s", host, remote);
        return remote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNotificationListener() {
        ObjectName broadcaster = this.getLocalEventBroadcasterMBeanName();
        NotificationListener listener = this.getLocalEventListener();
        if (broadcaster == null || listener == null) {
            return;
        }
        MBeanServer mbs = this.getLocalMBeanServer();
        try {
            LOG.debug(String.format("Removing notification listener for events from %s", broadcaster), new Object[0]);
            mbs.removeNotificationListener(broadcaster, listener);
        }
        catch (InstanceNotFoundException infEx) {
            String msg = String.format("Failure removing event notification listener, %s MBean not found.", broadcaster);
            LOG.warn(msg, infEx);
        }
        catch (ListenerNotFoundException lnfEx) {
            String msg = String.format("Failure removing event notification listener, no listener found.", new Object[0]);
            LOG.warn(msg, lnfEx);
        }
        finally {
            this.setLocalEventListener(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteAgentManager removeRemoteAgentManager(String host) {
        RemoteAgentManager manager;
        AgentMBeanProvider.logDebug("Removing the RemoteAgentManager for the host \"%s\".", host);
        AgentMBeanProvider agentMBeanProvider = this;
        synchronized (agentMBeanProvider) {
            Map<String, RemoteAgentManager> map = this.getRemoteAgentManagersByHost();
            manager = map.remove(host);
        }
        boolean removed = manager != null;
        AgentMBeanProvider.logDebug("Removed the RemoteAgentManager for the host \"%s\"? %s", host, removed);
        return manager;
    }

    public void setLocalAgent(AgentMBean localAgent) {
        this._localAgent = localAgent;
    }

    private void setLocalEventListener(NotificationListener listener) {
        this._localEventListener = listener;
    }

    private void setLocalEventBroadcasterMBeanName(ObjectName name) {
        this._localEventBroadcasterMBeanName = name;
    }

    private void setRemoteAgentManagersByHost(Map<String, RemoteAgentManager> remoteAgentManagersByHost) {
        this._remoteAgentManagersByHost = remoteAgentManagersByHost;
    }

    public void start() {
        AgentMBeanProvider.logDebug("Starting.", new Object[0]);
        AgentMBeanProvider.logDebug("Started.", new Object[0]);
    }

    @Override
    public AgentMBean startAgent(String host, Properties securityProperties) throws IOException {
        boolean remote = this.isRemoteHost(host);
        if (remote) {
            return this.getRemoteAgent(host, securityProperties);
        }
        MBeanServer mbs = this.getLocalMBeanServer();
        this.createNotificationListener(mbs);
        return this.getLocalAgent();
    }

    private void startRemoteAgentManager(RemoteAgentManager manager) throws IOException {
        AgentMBeanProvider.logDebug("Starting RemoteAgentManager: \"%s\".", manager);
        manager.start();
        AgentMBeanProvider.logDebug("Started RemoteAgentManager: \"%s\".", manager);
    }

    public void stop() {
        AgentMBeanProvider.logDebug("Stopping.", new Object[0]);
        this.stopAndRemoveAllRemoteAgentManagers();
        AgentMBeanProvider.logDebug("Stopped.", new Object[0]);
    }

    @Override
    public boolean stopAgent(String host) {
        boolean remote = this.isRemoteHost(host);
        if (remote) {
            return this.stopRemoteAgentManager(host);
        }
        this.removeNotificationListener();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAndRemoveAllRemoteAgentManagers() {
        boolean ok = true;
        AgentMBeanProvider.logDebug("Stopping and removing all RemoteAgentManagers.", new Object[0]);
        AgentMBeanProvider agentMBeanProvider = this;
        synchronized (agentMBeanProvider) {
            Map<String, RemoteAgentManager> map = this.getRemoteAgentManagersByHost();
            Collection<RemoteAgentManager> managers = map.values();
            Iterator<RemoteAgentManager> iterator = managers.iterator();
            while (ok && iterator.hasNext()) {
                RemoteAgentManager manager = iterator.next();
                ok = this.stopRemoteAgentManager(manager);
            }
            if (ok) {
                map.clear();
            }
        }
        AgentMBeanProvider.logDebug("Stopped and removed all RemoteAgentManagers? %s", ok);
    }

    private boolean stopRemoteAgentManager(RemoteAgentManager manager) {
        if (manager == null) {
            return false;
        }
        AgentMBeanProvider.logDebug("Stopping %s.", manager);
        manager.stop();
        return true;
    }

    private boolean stopRemoteAgentManager(String host) {
        RemoteAgentManager manager = this.removeRemoteAgentManager(host);
        return this.stopRemoteAgentManager(manager);
    }
}

