/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.agent.events.internal;

import com.sas.deployment.common.control.OperationEventBroadcasterMBean;
import com.sas.solstice.platform.core.IEventSender;
import com.sas.solstice.platform.core.dao.PlatformMessage;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import javax.management.StandardEmitterMBean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OperationEventBroadcaster
implements IEventSender,
OperationEventBroadcasterMBean {
    private static Logger logger = LogManager.getLogger(OperationEventBroadcaster.class);
    static final String NOTIFICATION_TYPE = "solstice.*";
    private StandardEmitterMBean _mbean;
    private MBeanServer _mbeanServer;
    private ObjectName _mbeanName;
    private long _sequence = 0L;

    StandardEmitterMBean getMBean() {
        return this._mbean;
    }

    ObjectName getMBeanName() {
        return this._mbeanName;
    }

    MBeanServer getMBeanServer() {
        return this._mbeanServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextSequence() {
        OperationEventBroadcaster operationEventBroadcaster = this;
        synchronized (operationEventBroadcaster) {
            long next = this.getSequence() + 1L;
            this.setSequence(next);
            return next;
        }
    }

    long getSequence() {
        return this._sequence;
    }

    private void registerMBean() throws MalformedObjectNameException, NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanRegistrationException {
        logger.debug("registerMBean: registering OperationEventBroadcasterMBean...");
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        String[] types = new String[]{NOTIFICATION_TYPE};
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, Notification.class.getName(), "Solstice operation events");
        NotificationBroadcasterSupport emitter = new NotificationBroadcasterSupport(info);
        StandardEmitterMBean mbean = new StandardEmitterMBean(this, OperationEventBroadcasterMBean.class, (NotificationEmitter)emitter);
        this.setMBean(mbean);
        String name = "com.sas.solstice:TYPE=EventBroadcaster";
        ObjectName mbeanName = new ObjectName(name);
        this.setMBeanName(mbeanName);
        mbeanServer.registerMBean(mbean, mbeanName);
        this.setMBeanServer(mbeanServer);
        logger.debug("registerMBean: MBean registration complete");
    }

    @Override
    public void sendEvent(String type, PlatformMessage message) {
        long sequence = this.getNextSequence();
        Notification notif = new Notification(type, this.getMBeanName(), sequence);
        notif.setUserData(message);
        this.getMBean().sendNotification(notif);
    }

    void setMBean(StandardEmitterMBean mbean) {
        this._mbean = mbean;
    }

    void setMBeanName(ObjectName mbeanName) {
        this._mbeanName = mbeanName;
    }

    void setMBeanServer(MBeanServer mbeanServer) {
        this._mbeanServer = mbeanServer;
    }

    void setSequence(long sequence) {
        this._sequence = sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws MalformedObjectNameException, NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanRegistrationException {
        logger.debug("start: starting EventSender service...");
        OperationEventBroadcaster operationEventBroadcaster = this;
        synchronized (operationEventBroadcaster) {
            this.registerMBean();
        }
        logger.debug("start: EventSender service started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws MBeanRegistrationException, InstanceNotFoundException {
        logger.debug("stop: stopping EventSender service...");
        OperationEventBroadcaster operationEventBroadcaster = this;
        synchronized (operationEventBroadcaster) {
            this.unregisterMBean();
        }
        logger.debug("stop: EventSender service stopped");
    }

    private void unregisterMBean() throws MBeanRegistrationException, InstanceNotFoundException {
        MBeanServer mbeanServer = this.getMBeanServer();
        if (mbeanServer == null) {
            logger.debug("unregisterMBean: MBean was never registered.");
            return;
        }
        ObjectName name = this.getMBeanName();
        try {
            logger.debug("unregisterMBean: unregistering OperationEventBroadcasterMBean...");
            mbeanServer.unregisterMBean(name);
        }
        finally {
            this.setMBeanServer(null);
        }
        logger.debug("unregisterMBean: MBean has been unregistered.");
    }
}

