/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jmx.support;

import com.atomikos.datasource.pool.event.ConnectionPoolExhaustedEvent;
import com.atomikos.icatch.event.Event;
import com.atomikos.icatch.event.EventListener;
import com.atomikos.util.DateHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class JmxConnectionPoolEventListener
implements EventListener {
    private static Map<String, Date> uniqueResourceNameToLastExhaustionDateMap = new HashMap<String, Date>();

    public void eventOccurred(Event event) {
        if (event instanceof ConnectionPoolExhaustedEvent) {
            ConnectionPoolExhaustedEvent eEvent = (ConnectionPoolExhaustedEvent)event;
            JmxConnectionPoolEventListener.putLastExhaustionDateForPool(eEvent);
        }
    }

    private static synchronized void putLastExhaustionDateForPool(ConnectionPoolExhaustedEvent eEvent) {
        uniqueResourceNameToLastExhaustionDateMap.put(eEvent.uniqueResourceName, new Date(eEvent.eventCreationTimestamp));
    }

    public static String getLastConnectionPoolExhaustionDate(String uniqueResourceName) {
        String ret = DateHelper.format((Date)new Date(0L));
        Date lastExhaustionDate = JmxConnectionPoolEventListener.getLastExhaustionDateForPool(uniqueResourceName);
        if (lastExhaustionDate != null) {
            ret = DateHelper.format((Date)lastExhaustionDate);
        }
        return ret;
    }

    private static synchronized Date getLastExhaustionDateForPool(String uniqueResourceName) {
        return uniqueResourceNameToLastExhaustionDateMap.get(uniqueResourceName);
    }
}

